## Usage

```js
const isAccessor = require('{%= name %}');
const obj = {
  get foo() {},
  bar: {get: function() {}}
};

isAccessor(obj, 'foo'); //=> true
isAccessor(obj, 'bar'); //=> false

// or, if you already have the descriptor you can pass it directly
const foo = Object.getOwnPropertyDescriptor(obj, 'foo');
isAccessor(foo); //=> true

const bar = Object.getOwnPropertyDescriptor(obj, 'bar');
isAccessor(bar); //=> false
```
