import { JSONSchema4 } from 'json-schema';
import { Options as $RefOptions } from 'json-schema-ref-parser';
import { Options as PrettierOptions } from 'prettier';
export { EnumJSONSchema, JSONSchema, NamedEnumJSONSchema, CustomTypeJSONSchema } from './types/JSONSchema';
export interface Options {
    /**
     * Disclaimer comment prepended to the top of each generated file.
     */
    bannerComment: string;
    /**
     * Root directory for resolving [`$ref`](https://tools.ietf.org/id/draft-pbryan-zyp-json-ref-03.html)s.
     */
    cwd: string;
    /**
     * Declare external schemas referenced via `$ref`?
     */
    declareExternallyReferenced: boolean;
    /**
     * Prepend enums with [`const`](https://www.typescriptlang.org/docs/handbook/enums.html#computed-and-constant-members)?
     */
    enableConstEnums: boolean;
    /**
     * Format code? Set this to `false` to improve performance.
     */
    format: boolean;
    /**
     * Ignore maxItems and minItems for `array` types, preventing tuples being generated.
     */
    ignoreMinAndMaxItems: boolean;
    /**
     * Append all index signatures with `| undefined` so that they are strictly typed.
     *
     * This is required to be compatible with `strictNullChecks`.
     */
    strictIndexSignatures: boolean;
    /**
     * A [Prettier](https://prettier.io/docs/en/options.html) configuration.
     */
    style: PrettierOptions;
    /**
     * Generate code for `definitions` that aren't referenced by the schema?
     */
    unreachableDefinitions: boolean;
    /**
     * Generate unknown type instead of any
     */
    unknownAny: boolean;
    /**
     * [$RefParser](https://github.com/BigstickCarpet/json-schema-ref-parser) Options, used when resolving `$ref`s
     */
    $refOptions: $RefOptions;
}
export declare const DEFAULT_OPTIONS: Options;
export declare function compileFromFile(filename: string, options?: Partial<Options>): Promise<string>;
export declare function compile(schema: JSONSchema4, name: string, options?: Partial<Options>): Promise<string>;
export declare class ValidationError extends Error {
}
