<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Page](./puppeteer.page.md) &gt; [evaluateOnNewDocument](./puppeteer.page.evaluateonnewdocument.md)

## Page.evaluateOnNewDocument() method

Adds a function which would be invoked in one of the following scenarios:

- whenever the page is navigated

- whenever the child frame is attached or navigated. In this case, the function is invoked in the context of the newly attached frame.

The function is invoked after the document was created but before any of its scripts were run. This is useful to amend the JavaScript environment, e.g. to seed `Math.random`.

<b>Signature:</b>

```typescript
evaluateOnNewDocument(pageFunction: Function | string, ...args: unknown[]): Promise<void>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  pageFunction | Function \| string | Function to be evaluated in browser context |
|  args | unknown\[\] | Arguments to pass to <code>pageFunction</code> |

<b>Returns:</b>

Promise&lt;void&gt;

## Example

An example of overriding the navigator.languages property before the page loads:

```js
// preload.js

// overwrite the `languages` property to use a custom getter
Object.defineProperty(navigator, 'languages', {
get: function () {
return ['en-US', 'en', 'bn'];
},
});

// In your puppeteer script, assuming the preload.js file is
in same folder of our script
const preloadFile = fs.readFileSync('./preload.js', 'utf8');
await page.evaluateOnNewDocument(preloadFile);

```

