<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [ElementHandle](./puppeteer.elementhandle.md) &gt; [$eval](./puppeteer.elementhandle._eval.md)

## ElementHandle.$eval() method

This method runs `document.querySelector` within the element and passes it as the first argument to `pageFunction`. If there's no element matching `selector`, the method throws an error.

If `pageFunction` returns a Promise, then `frame.$eval` would wait for the promise to resolve and return its value.

<b>Signature:</b>

```typescript
$eval<ReturnType>(selector: string, pageFunction: (element: Element, ...args: unknown[]) => ReturnType | Promise<ReturnType>, ...args: SerializableOrJSHandle[]): Promise<WrapElementHandle<ReturnType>>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  selector | string |  |
|  pageFunction | (element: Element, ...args: unknown\[\]) =&gt; ReturnType \| Promise&lt;ReturnType&gt; |  |
|  args | [SerializableOrJSHandle](./puppeteer.serializableorjshandle.md)\[\] |  |

<b>Returns:</b>

Promise&lt;[WrapElementHandle](./puppeteer.wrapelementhandle.md)&lt;ReturnType&gt;&gt;

## Example


```js
const tweetHandle = await page.$('.tweet');
expect(await tweetHandle.$eval('.like', node => node.innerText)).toBe('100');
expect(await tweetHandle.$eval('.retweets', node => node.innerText)).toBe('10');

```

