/*
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

import hasUTF16SurrogatePairAt = require( './index' );


// TESTS //

// The function returns a boolean...
{
	hasUTF16SurrogatePairAt( '🌷', 0 ); // $ExpectType boolean
	hasUTF16SurrogatePairAt( '🌷', 1 ); // $ExpectType boolean
}

// The function does not compile if provided incorrect arguments...
{
	hasUTF16SurrogatePairAt( false, 3 ); // $ExpectError
	hasUTF16SurrogatePairAt( {}, 3 ); // $ExpectError
	hasUTF16SurrogatePairAt( ( x: number ): number => x, 3 ); // $ExpectError

	hasUTF16SurrogatePairAt( 'string', true ); // $ExpectError
	hasUTF16SurrogatePairAt( 'string', false ); // $ExpectError
	hasUTF16SurrogatePairAt( 'string', {} ); // $ExpectError
	hasUTF16SurrogatePairAt( 'string', ( x: number ): number => x ); // $ExpectError
}

// The compiler throws an error if the function is provided an unsupported number of arguments...
{
	hasUTF16SurrogatePairAt(); // $ExpectError
}
