/*
* @license Apache-2.0
*
* Copyright (c) 2021 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

// TypeScript Version: 2.0

/// <reference types="@stdlib/types"/>

import { ArrayLike } from '@stdlib/types/array';

/**
* Returns a boolean indicating if an array is row-major based on a provided stride array.
*
* @param strides - integer stride array
* @returns boolean indicating if an array is row-major
*
* @example
* var bool = isRowMajor( [ 2, 1 ] );
* // returns true
*
* bool = isRowMajor( [ 1, 2 ] );
* // returns false
*/
declare function isRowMajor( strides: ArrayLike<number> ): boolean;


// EXPORTS //

export = isRowMajor;
