const {
  String: { type: String },
  Boolean: { type: Boolean },
  url: { type: url },
  Number: { type: Number },
  path: { type: path },
  Date: { type: Date },
  semver: { type: semver },
  Umask: { type: Umask },
} = require('../../lib/type-defs.js')

const { networkInterfaces } = require('os')
const getLocalAddresses = () => {
  try {
    return Object.values(networkInterfaces()).map(
      int => int.map(({ address }) => address)
    ).reduce((set, addrs) => set.concat(addrs), [undefined])
  } catch (e) {
    return [undefined]
  }
}

module.exports = {
  access: [null, 'restricted', 'public'],
  all: Boolean,
  'allow-same-version': Boolean,
  'always-auth': Boolean,
  also: [null, 'dev', 'development'],
  audit: Boolean,
  'audit-level': ['low', 'moderate', 'high', 'critical', 'none', null],
  'auth-type': ['legacy', 'sso', 'saml', 'oauth'],
  before: [null, Date],
  'bin-links': Boolean,
  browser: [null, Boolean, String],
  ca: [null, String, Array],
  cafile: path,
  cache: path,
  'cache-lock-stale': Number,
  'cache-lock-retries': Number,
  'cache-lock-wait': Number,
  'cache-max': Number,
  'cache-min': Number,
  cert: [null, String],
  cidr: [null, String, Array],
  color: ['always', Boolean],
  call: String,
  depth: Number,
  description: Boolean,
  dev: Boolean,
  'dry-run': Boolean,
  editor: String,
  'engine-strict': Boolean,
  force: Boolean,
  fund: Boolean,
  'format-package-lock': Boolean,
  'fetch-retries': Number,
  'fetch-retry-factor': Number,
  'fetch-retry-mintimeout': Number,
  'fetch-retry-maxtimeout': Number,
  git: String,
  'git-tag-version': Boolean,
  'commit-hooks': Boolean,
  global: Boolean,
  globalconfig: path,
  'global-style': Boolean,
  'https-proxy': [null, url],
  'user-agent': String,
  heading: String,
  'if-present': Boolean,
  include: [Array, 'prod', 'dev', 'optional', 'peer'],
  'include-staged': Boolean,
  'ignore-prepublish': Boolean,
  'ignore-scripts': Boolean,
  'init-module': path,
  'init-author-name': String,
  'init-author-email': String,
  'init-author-url': ['', url],
  'init-license': String,
  'init-version': semver,
  json: Boolean,
  key: [null, String],
  'legacy-bundling': Boolean,
  'legacy-peer-deps': Boolean,
  link: Boolean,
  'local-address': getLocalAddresses(),
  loglevel: ['silent', 'error', 'warn', 'notice', 'http', 'timing', 'info', 'verbose', 'silly'],
  'logs-max': Number,
  long: Boolean,
  'multiple-numbers': [Array, Number],
  maxsockets: Number,
  message: String,
  'metrics-registry': [null, String],
  'node-options': [null, String],
  'node-version': [null, semver],
  noproxy: [null, String, Array],
  offline: Boolean,
  omit: [Array, 'dev', 'optional', 'peer'],
  only: [null, 'dev', 'development', 'prod', 'production'],
  optional: Boolean,
  otp: [null, String],
  package: [String, Array],
  'package-lock': Boolean,
  'package-lock-only': Boolean,
  parseable: Boolean,
  'prefer-offline': Boolean,
  'prefer-online': Boolean,
  prefix: path,
  preid: String,
  production: Boolean,
  progress: Boolean,
  proxy: [null, false, url], // allow proxy to be disabled explicitly
  'read-only': Boolean,
  'rebuild-bundle': Boolean,
  registry: [null, url],
  rollback: Boolean,
  save: Boolean,
  'save-bundle': Boolean,
  'save-dev': Boolean,
  'save-exact': Boolean,
  'save-optional': Boolean,
  'save-prefix': String,
  'save-prod': Boolean,
  scope: String,
  'script-shell': [null, String],
  'scripts-prepend-node-path': [Boolean, 'auto', 'warn-only'],
  searchopts: String,
  searchexclude: [null, String],
  searchlimit: Number,
  searchstaleness: Number,
  'send-metrics': Boolean,
  shell: String,
  shrinkwrap: Boolean,
  'sign-git-commit': Boolean,
  'sign-git-tag': Boolean,
  'sso-poll-frequency': Number,
  'sso-type': [null, 'oauth', 'saml'],
  'strict-ssl': Boolean,
  tag: String,
  timing: Boolean,
  tmp: path,
  unicode: Boolean,
  'update-notifier': Boolean,
  usage: Boolean,
  userconfig: path,
  umask: Umask,
  version: Boolean,
  'tag-version-prefix': String,
  versions: Boolean,
  viewer: String,
  _exit: Boolean,
}
