/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.mimetype.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.turbine.services.mimetype.util.MimeType;
import org.apache.turbine.services.mimetype.util.MimeTypeMapper;

public class MimeTypeMap {
    public static final MimeType DEFAULT_MIMETYPE = MimeType.APPLICATION_OCTET_STREAM;
    public static final String DEFAULT_TYPE = DEFAULT_MIMETYPE.toString();
    public static final String MIMETYPE_RESOURCE = "mime.types";
    public static final String EXT_HTML = "html";
    public static final String EXT_HTM = "htm";
    public static final String EXT_WML = "wml";
    public static final String EXT_HDML = "hdml";
    public static final String EXT_HDM = "hdm";
    public static final String EXT_CHTML = "chtml";
    public static final String EXT_TEXT = "txt";
    public static final String EXT_GIF = "gif";
    public static final String EXT_JPEG = "jpeg";
    public static final String EXT_JPG = "jpg";
    public static final String EXT_WBMP = "wbmp";
    private static final int MAP_PROG = 0;
    private static final int MAP_HOME = 1;
    private static final int MAP_SYS = 2;
    private static final int MAP_JAR = 3;
    private static final int MAP_COM = 4;
    private static MimeTypeMapper commonMapper = new MimeTypeMapper();
    private MimeTypeMapper[] mappers = new MimeTypeMapper[5];
    private static /* synthetic */ Class class$Lorg$apache$turbine$services$mimetype$util$MimeTypeMap;

    protected static MimeTypeMapper loadPath(String path) throws IOException {
        return new MimeTypeMapper(path);
    }

    protected static MimeTypeMapper loadResource(String name) {
        InputStream input = (class$Lorg$apache$turbine$services$mimetype$util$MimeTypeMap != null ? class$Lorg$apache$turbine$services$mimetype$util$MimeTypeMap : (class$Lorg$apache$turbine$services$mimetype$util$MimeTypeMap = MimeTypeMap.class$("org.apache.turbine.services.mimetype.util.MimeTypeMap"))).getResourceAsStream(name);
        if (input != null) {
            try {
                return new MimeTypeMapper(input);
            }
            catch (IOException x) {
                return null;
            }
        }
        return null;
    }

    public synchronized void setContentType(String spec) {
        if (this.mappers[0] == null) {
            this.mappers[0] = new MimeTypeMapper();
        }
        this.mappers[0].setContentType(spec);
    }

    public String getContentType(File file) {
        return this.getContentType(file.getName());
    }

    public String getContentType(String name) {
        int i = name.lastIndexOf(46);
        if (i >= 0) {
            String ext = name.substring(i + 1);
            return ext.length() > 0 ? this.getContentType(ext, DEFAULT_TYPE) : DEFAULT_TYPE;
        }
        return DEFAULT_TYPE;
    }

    public String getContentType(String ext, String def) {
        int i = ext.lastIndexOf(46);
        if (i >= 0) {
            ext = ext.substring(i + 1);
        }
        i = 0;
        while (i < this.mappers.length) {
            String mime;
            MimeTypeMapper mapper = this.mappers[i];
            if (mapper != null && (mime = mapper.getContentType(ext)) != null) {
                return mime;
            }
            ++i;
        }
        return def;
    }

    public MimeType getMimeContentType(File file) {
        try {
            return new MimeType(this.getContentType(file));
        }
        catch (Exception x) {
            return DEFAULT_MIMETYPE;
        }
    }

    public MimeType getMimeContentType(String name) {
        try {
            return new MimeType(this.getContentType(name));
        }
        catch (Exception x) {
            return DEFAULT_MIMETYPE;
        }
    }

    public MimeType getMimeContentType(String ext, String def) {
        try {
            return new MimeType(this.getContentType(ext, def));
        }
        catch (Exception x) {
            return DEFAULT_MIMETYPE;
        }
    }

    public String getDefaultExtension(String type) {
        int i = type.indexOf(59);
        if (i >= 0) {
            type = type.substring(0, i);
        }
        type = type.trim();
        i = this.mappers.length - 1;
        while (i >= 0) {
            String ext;
            MimeTypeMapper mapper = this.mappers[i];
            if (mapper != null && (ext = mapper.getExtension(type)) != null) {
                return ext;
            }
            --i;
        }
        return null;
    }

    public String getDefaultExtension(MimeType mime) {
        return this.getDefaultExtension(mime.getTypes());
    }

    protected synchronized void setCommonContentType(String spec) {
        this.mappers[4].setContentType(spec);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public MimeTypeMap() {
        String path;
        try {
            path = System.getProperty("user.home");
            if (path != null) {
                path = path + File.separator + MIMETYPE_RESOURCE;
                this.mappers[1] = MimeTypeMap.loadPath(path);
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            path = System.getProperty("java.home") + File.separator + "lib" + File.separator + MIMETYPE_RESOURCE;
            this.mappers[2] = MimeTypeMap.loadPath(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mappers[3] = MimeTypeMap.loadResource("/META-INF/mime.types");
        this.mappers[4] = commonMapper;
    }

    public MimeTypeMap(InputStream input) throws IOException {
        this();
        this.mappers[0] = new MimeTypeMapper(input);
    }

    public MimeTypeMap(File file) throws IOException {
        this();
        this.mappers[0] = new MimeTypeMapper(file);
    }

    public MimeTypeMap(String path) throws IOException {
        this();
        this.mappers[0] = new MimeTypeMapper(path);
    }

    static {
        commonMapper.setContentType(MimeType.TEXT_HTML.toString() + " " + EXT_HTML + " " + EXT_HTM);
        commonMapper.setContentType(MimeType.TEXT_WML.toString() + " " + EXT_WML);
        commonMapper.setContentType(MimeType.TEXT_HDML.toString() + " " + EXT_HDML + " " + EXT_HDM);
        commonMapper.setContentType(MimeType.TEXT_CHTML.toString() + " " + EXT_CHTML);
        commonMapper.setContentType(MimeType.TEXT_PLAIN.toString() + " " + EXT_TEXT);
        commonMapper.setContentType(MimeType.IMAGE_GIF.toString() + " " + EXT_GIF);
        commonMapper.setContentType(MimeType.IMAGE_JPEG.toString() + " " + EXT_JPEG + " " + EXT_JPG);
        commonMapper.setContentType(MimeType.IMAGE_WBMP.toString() + " " + EXT_WBMP);
    }
}

