/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.search.test;

import com.sourceforge.knecs.dsm.search.QueryPredicate;
import com.sourceforge.knecs.dsm.search.Search;
import com.sourceforge.knecs.util.NSProperty;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class SinglePropSearchTest {
    private SinglePropSearchTest(String[] args) {
        if (args.length < 5) {
            System.err.println("Usage: SinglePropSearchTest url username password namespace:propName propValue");
            System.exit(-1);
        }
        String mHoststr = args[0];
        String username = args[1];
        String passwd = args[2];
        NSProperty propName = new NSProperty(args[3]);
        String propValue = args[4];
        Hashtable<NSProperty, QueryPredicate> query = new Hashtable<NSProperty, QueryPredicate>();
        QueryPredicate qp = new QueryPredicate(propName, propValue, "contains", false);
        query.put(propName, qp);
        HashSet<NSProperty> returnProperties = new HashSet<NSProperty>();
        returnProperties.add(propName);
        System.out.println("Query Terms: " + query.toString());
        System.out.println("\n");
        System.out.println("Properties to return: " + returnProperties.toString());
        System.out.println("\n");
        try {
            Search srch = new Search();
            long start = System.currentTimeMillis();
            Vector results = srch.run(mHoststr, username, passwd, returnProperties, query, Integer.MAX_VALUE);
            long end = System.currentTimeMillis();
            System.out.println("Got " + results.size() + " matches in " + (end - start) + " ms\n");
        }
        catch (Exception ex) {
            System.out.println("errmsg: " + ex.toString());
        }
    }

    public static void main(String[] args) {
        SinglePropSearchTest pst = new SinglePropSearchTest(args);
    }
}

