/*
 * Copyright (c) 1997 - 2016
 * Actelion Pharmaceuticals Ltd.
 * Gewerbestrasse 16
 * CH-4123 Allschwil, Switzerland
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the the copyright holder nor the
 *    names of its contributors may be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * @author Modest v. Korff
 */

package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.chem.Molecule3D;

public class MolDistHistVizFrag extends MolDistHistViz {

	
	private static final long serialVersionUID = 24112010;

	private int [] arrIndexParentNodes;
	
	public MolDistHistVizFrag() {
		// TODO Auto-generated constructor stub
	}

	public MolDistHistVizFrag(int length) {
		super(length);
		// TODO Auto-generated constructor stub
	}

	public MolDistHistVizFrag(int length, Molecule3D ff) {
		super(length, ff);
		// TODO Auto-generated constructor stub
	}

	public MolDistHistVizFrag(MolDistHistVizFrag mdhvf) {
		super(mdhvf);
		if(mdhvf.arrIndexParentNodes != null) {
			arrIndexParentNodes = new int [mdhvf.arrIndexParentNodes.length];
			System.arraycopy(mdhvf.arrIndexParentNodes, 0, arrIndexParentNodes, 0, mdhvf.arrIndexParentNodes.length);
		}
	}

	public MolDistHistVizFrag(MolDistHist mdh) {
		super(mdh);
		// TODO Auto-generated constructor stub
	}

	public int[] getArrIndexParentNodes() {
		return arrIndexParentNodes;
	}
	
	public MolDistHistVizFrag copy(){
		
		MolDistHistVizFrag mdhvf = new MolDistHistVizFrag(this);
		
		if(arrIndexParentNodes != null) {
			int [] arr = new int [arrIndexParentNodes.length];
			System.arraycopy(arrIndexParentNodes, 0, arr, 0, arrIndexParentNodes.length);
			mdhvf.setArrIndexParentNodes(arr);
		}
		
		return mdhvf;
	}

	public void setArrIndexParentNodes(int[] arrIndexParentNodes) {
		this.arrIndexParentNodes = arrIndexParentNodes;
	}

}
