<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

December 1, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Matthias Scharfenberg - Industrial Light & Magic
  * [X] Dennis Adams - Sony
  * [X] Thomas Mansencal - Weta Digital
  * [X] Christophe Brejon
  * [X] Mitch Prater - LAIKA
  * [X] Zach Lewis - Method
  * [X] Alessandra Tomassi - Industrial Light & Magic
  * [X] J Schulte - Industrial Light & Magic
  * [X] Nick Shaw - Antler Post

# **OCIO Configs Working Group Meeting Notes**

* Review spreadsheet, agree on reference config scope:
    - Spreadsheet: https://docs.google.com/spreadsheets/d/1SXPt-USy3HlV2G2qAvh9zit6ZCINDOlfKT07yXJdWLg/edit#gid=0
    - NOTE: Doug updating and adding discussion comments in spreadsheet.
    - Michael: Thanks to Zach for populating much of the spreadsheet! Of this 
      list, which transforms are accounted for currently in BuiltinTransform?
    - Doug: All of ACES CSC complete.
    - Mark: Do we need 10 and 12 bit ACESproxy?
    - Doug: Those are annoying. They are implemented differently, with bitshift 
      scaling.
    - Mark: Is it possible to correctly use those? Due to not supporting 10 and 
      12-bit integer inputs.
    - Doug: you can directly process integer pixels on input and output. Could 
      produce correct pixel with 10i or 12i values. Sort of like ADX10 or 
      ADX16. Not claiming they need to be encoded at that depth. They are just 
      different color spaces. I think they should be in reference config since 
      they are part of ACES.
    - Mark: Don't agree with putting it in config just because it's in CTL. 
      Muddying the waters by having them in here. If not possible to input 10 
      or 12-bit integer into OCIO, doesn't make sense to support the use case 
      where bit-shifting is needed.
    - Thomas: Might be requirement for logo program. For ACES official support.
    - Michael: Was initial meeting with ACES team to get OCIO in ACES logo 
      program.
    - Doug: ACES committee maintains product partners. Vendor would sign up as 
      partner. There is implied commitment to meet the requirements. Since 
      there is new CLF and AMF specs, probably will be more forceful about 
      adhering to the standards. They would like OCIO to be part of the 
      program.
    - Mark: Don't think they would deny the logo program based on agreed 
      exclusions.
    - Thomas: Should discuss with ACES.
    - Carol: Agree, don't think they would have a problem excluding something 
      if it can't be implemented correctly.
    - Doug: Can be implemented correctly. No technical reason it would not 
      work.
    - Mark: Still have to do conversion outside of OCIO.
    - Kevin: Sample application. What happens in Nuke were color processing is 
      independent of file processing. Relying on downstream tool to do correct 
      output. Ambiguous about who should do that.
    - Doug: OCIO does support 10 and 12-bit pixel formats, and it would produce 
      ready to use pixels. Not saying we have to support it, but it would work 
      in OCIO.
    - Mark: Should you have new color space for that? Or do you assume just by 
      choosing that you get the right output.
    - Doug: Complicated because of the scaling implementation. Would be nicer 
      if you could just select ACESproxy and let something else worry about 
      the scaling.
    - **TODO**: Michael will add another option to include columns in 
      spreadsheet.
      marking a transform as undecided or in discussion.
    - Kevin: We can't control implementations even if OCIO does the right 
      thing. If builtin into reader or writer, ok, but in color space 
      conversion node, all bets are off.
    - Thomas: Could come with caveat - documentation on how to use. Don't think 
      a lot of people will use it.
    - Mark: Should do ADX ones as well.
    - Doug: Don't think there's a question about including those. They are 
      vastly different color spaces. ADX10 not able to capture everything on 
      current negative films.
    - Kevin: We never get anything film scanned that's ADX10. Always different 
      density range than ADX can hold.
    - Doug: ACES team has identified ADX support as an area that they want to 
      upgrade.
    - J: Discussion outside this scope.
    - Michael: Next discussion id about ALEXA IDTs.
    - Doug: These aren't all of them. These are the EI 800 ones.
    - Thomas: Some of these will likely be removed. Need to discuss with 
      Joseph, Scott, and Alex.
    - Mark: Strong preference that they aren't included. Just include one.
    - Kevin: Might need to be two. These are from RAW. Still need wide gamut 
      as well.
    - Matthias: Should they be included at all? Haven't seen ALEXA RAW image 
      at all, except what I've made. Question the usefulness. Will need ALEXA 
      wide gamut.
    - J: Agree. Camera native is unlikely to show up in our workflows due to 
      sophistication of our pipelines. Support removing all of these others 
      bits of noise.
    - Carol: Think that's what ARRI will say as well. Moving forward there are 
      use cases for debugging, but not necessity to have all in a config.
    - Thomas: Goes back to ACES logo program. Should say to Academy what we're 
      not supporting and why.
    - Matthias: In last IDT meeting showed table of what qualified as logo 
      program. Needed two matrices in camera, or a common gamut where 
      white-point optimization is already done.
    - Doug: Making note about sensor RAW ALEXA, which are not commonly 
      received.
    - Kevin: If we go for logo program status, do we have to keep following 
      ACES when new IDTs are added?
    - Matthias: Don't see way out of it if new camera color space is made.
    - Michael: What about all the Sony spaces?
    - Mark: Need some of them.
    - Carol: Need venice.
    - Doug: Have CSC transforms for SGamut spaces, which are the newest 
      implementation.
    - Zach: Do we need to differentiate between 10 and 12 bit, or include 
      SLog1?
    - Doug: Other way to think about this is we could implement all of them, 
      but set them as inactive in the config. Proves OCIO has implemented the 
      full library, but wouldn't show up unless enabled.
    - All: Sounds reasonable.
    - Doug: Could start with essentials, and talk to ACES about doing more 
      later.
    - Matthias: Agree to focus on what's important.
    - Michael: Could put more builtin transforms in lib and not use them all in 
      config. The two don't have to align exactly.
    - Mark: Think we should put minimal collection in OCIO, rely on LUTs for 
      others.
    - Doug: Agree. For some would use LUTs.
    - Mark: For ACES, not sure IDTs should even be included.
    - Michael: If they can be implemented without builtin transforms (e.g. 
      LogCameraTransform), should they be?
    - Doug: Convenient to have builtin transform to promote standardization. 
      Builtin transform gives confidence - don't need to check matrix 
      coefficients, etc.
    - Michael: If we have rule about not including external files in reference 
      config, need to limit based on that as well.
    - Doug: LMTs could be named transforms. Blue light fix gets used. Far from 
      optimal fix, and hopefully migrate to gamut mapping in future.
    - Carol: Would be great to implement gamut compress.
    - Thomas: Blue light fix still gets used.
    - Kevin: Can give warning and deprecate in 1.3.
    - Mark: Since this is an LMT, and productions are expected to provide own 
      LMT, could LMT be slotted into this config like in ACES graph?
    - Kevin: Generally LMT is a cube or something else, rather than CDL.
    - Mark: Whole look section is not useful in terms of OCIO config. Can put 
      it in to have correct pathway, as a block in a view.
    - Carol: Might be space in studio config to write tools to enable that. 
      Reference config is what it is.
    - Mark: Yes, and NamedTransform makes sense in same way as gamut compress.
    - Zach: Any reason this LMT would be part of ACES logo program?
    - Doug: Might be. After we have our proposed list we should run this by 
      ACES committee to see what they feel strongly about. 
    - Thomas: We don't know what all their users are doing and don't have that 
      feedback.
    - Michael: Include all ODTs?
    - J: Another question for ACES team.
    - Mark: Would be nice to discourage use of D60 sim ODTs.
    - Doug: Why do people not like D60 sim?
    - Mark: Just get the right hardware.
    - Kevin: Or provide LMT that does the same.
    - Carol: That would be my preference too.
    - Nick: Could D60 sim be done as LMT?
    - Kevin: Haven't tried it, but think it could be done.
    - Thomas: With inversion capabilities of RRT itself.
    - **TODO**: Michael will share this spreadsheet with ACES for feedback. May 
      need to reformat it to be more concise. Could also invite them to join 
      next meeting to discuss.
    - Kevin: Some controversy about DCDM ODT.
    - Doug: For people needing to make DCDM, isn't this there best option?
    - Kevin: Rely on downstream conversion to make tiff files. Rarely done in 
      same application grading is done in.
    - Nick: Was ACES central discussion about this recently. Scott said 
      recommended approach was P3 master and make DCDM from that.
    - Doug: Recommended in the sense that you get what you saw if grading on 
      P3, but some people actually setup projectors in X'Y'Z'.
    - Kevin: And use native projector gamut as well. Just encoding XYZ and 
      don't go near ACES configs. Is there intersection of someone who does 
      this and who is using ACES as ACES?

* Talk about what we can do with the incorrectly named ACEStransformID as I 
  have the feeling we won’t get a resolution from the AMPAS soon:
    - Thomas: Didn't have a feeling there would be resolution to this issue. 
      What should we do?
    - Mark: Do you mean just fix the names that are wrong?
    - Thomas: Yes.
    - Mark: Thought we decided not to generate config directly.
    - Thomas: Are doing that now, and can continue to do so.
    - Mark: Had concerns about code base being complex. Good for graph layout, 
      querying, etc. But those things are ancillary to task of generating OCIO 
      config. When tried to go through it, found it difficult to get started. 
      Someone with little experience in ACES would have hard time.
    - Thomas: Made like that to be similar to what was done for previous 
      version of config. Trivial to update generator and re-generate.
    - Mark: Getting to point where maintaining exception list is as complex 
      as explicitly writing down combinations needed for final config.
    - Thomas: Maybe? Not too much work right now, but fair point.
    - Carol: Regardless, need to keep pushing on transform IDs getting fixed. 
      Have opportunity now to get those fixes in 1.3. If we can push on that, 
      it would help.
    - Mark: What was their hesitance to merge PR?
    - Carol: ACES release schedule. They don't do hot fixes. Would need to go 
      in new release.
    - Doug: There is a hotfix branch, but doesn't get merged into main branch 
      until there is a release. Also an issue for ACES metadata file since 
      those IDs are important there too. Could push from that end too.

* Items for next TSC meeting agenda:
    - Talk to ACES representative about spreadsheet questions. May be offline 
      discussion, but will make it public.
    - Conclude discussion about whether to generate config from graph code 
      currently in repo, or to have separate library which explicitly builds 
      config, using the graph lib to validate.
    - Talk about dev workflow, it is a bit painful atm:
      https://github.com/AcademySoftwareFoundation/OpenColorIO-Config-ACES/pull/9#issuecomment-735352837
    - Fully fledged display spaces, it was agreed here on Slack, but maybe we 
      can make it official.
        - Zach: Specifically, we were talking about having a set of 
          display-referred CIE_XYZ-D65_to_Display-xxxx BuiltinTransform styles 
          that we could use to define display color spaces, just like we can 
          with the current scene-referred xxxxx-to-ACES2065-1 csc styles and 
          normal color spaces. These would be useful for non-ACES configs as 
          well, of course.
