/******************************************************************************
 * Author:   Laurent Kneip                                                    *
 * Contact:  kneip.laurent@gmail.com                                          *
 * License:  Copyright (c) 2013 Laurent Kneip, ANU. All rights reserved.      *
 *                                                                            *
 * Redistribution and use in source and binary forms, with or without         *
 * modification, are permitted provided that the following conditions         *
 * are met:                                                                   *
 * * Redistributions of source code must retain the above copyright           *
 *   notice, this list of conditions and the following disclaimer.            *
 * * Redistributions in binary form must reproduce the above copyright        *
 *   notice, this list of conditions and the following disclaimer in the      *
 *   documentation and/or other materials provided with the distribution.     *
 * * Neither the name of ANU nor the names of its contributors may be         *
 *   used to endorse or promote products derived from this software without   *
 *   specific prior written permission.                                       *
 *                                                                            *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"*
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE  *
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE *
 * ARE DISCLAIMED. IN NO EVENT SHALL ANU OR THE CONTRIBUTORS BE LIABLE        *
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL *
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR *
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER *
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT         *
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY  *
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF     *
 * SUCH DAMAGE.                                                               *
 ******************************************************************************/


#include <opengv/relative_pose/modules/fivept_nister/modules.hpp>
#include <Eigen/NonLinearOptimization>
#include <Eigen/NumericalDiff>

#include <opengv/OptimizationFunctor.hpp>

void
opengv::relative_pose::modules::fivept_nister::composeA(
    const Eigen::Matrix<double,9,4> & EE,
    Eigen::Matrix<double,10,20> & A)
{
  double e00,e01,e02,e03,e04,e05,e06,e07,e08;
  double e10,e11,e12,e13,e14,e15,e16,e17,e18;
  double e20,e21,e22,e23,e24,e25,e26,e27,e28;
  double e30,e31,e32,e33,e34,e35,e36,e37,e38;

  double e002,e012,e022,e032,e042,e052,e062,e072,e082;
  double e102,e112,e122,e132,e142,e152,e162,e172,e182;
  double e202,e212,e222,e232,e242,e252,e262,e272,e282;
  double e302,e312,e322,e332,e342,e352,e362,e372,e382;

  double e003,e013,e023,e033,e043,e053,e063,e073,e083;
  double e103,e113,e123,e133,e143,e153,e163,e173,e183;
  double e203,e213,e223,e233,e243,e253,e263,e273,e283;
  double e303,e313,e323,e333,e343,e353,e363,e373,e383;

  e00 = EE(0,0);
  e10 = EE(0,1);
  e20 = EE(0,2);
  e30 = EE(0,3);
  e01 = EE(1,0);
  e11 = EE(1,1);
  e21 = EE(1,2);
  e31 = EE(1,3);
  e02 = EE(2,0);
  e12 = EE(2,1);
  e22 = EE(2,2);
  e32 = EE(2,3);
  e03 = EE(3,0);
  e13 = EE(3,1);
  e23 = EE(3,2);
  e33 = EE(3,3);
  e04 = EE(4,0);
  e14 = EE(4,1);
  e24 = EE(4,2);
  e34 = EE(4,3);
  e05 = EE(5,0);
  e15 = EE(5,1);
  e25 = EE(5,2);
  e35 = EE(5,3);
  e06 = EE(6,0);
  e16 = EE(6,1);
  e26 = EE(6,2);
  e36 = EE(6,3);
  e07 = EE(7,0);
  e17 = EE(7,1);
  e27 = EE(7,2);
  e37 = EE(7,3);
  e08 = EE(8,0);
  e18 = EE(8,1);
  e28 = EE(8,2);
  e38 = EE(8,3);

  e002 =e00*e00;
  e102 =e10*e10;
  e202 =e20*e20;
  e302 =e30*e30;
  e012 =e01*e01;
  e112 =e11*e11;
  e212 =e21*e21;
  e312 =e31*e31;
  e022 =e02*e02;
  e122 =e12*e12;
  e222 =e22*e22;
  e322 =e32*e32;
  e032 =e03*e03;
  e132 =e13*e13;
  e232 =e23*e23;
  e332 =e33*e33;
  e042 =e04*e04;
  e142 =e14*e14;
  e242 =e24*e24;
  e342 =e34*e34;
  e052 =e05*e05;
  e152 =e15*e15;
  e252 =e25*e25;
  e352 =e35*e35;
  e062 =e06*e06;
  e162 =e16*e16;
  e262 =e26*e26;
  e362 =e36*e36;
  e072 =e07*e07;
  e172 =e17*e17;
  e272 =e27*e27;
  e372 =e37*e37;
  e082 =e08*e08;
  e182 =e18*e18;
  e282 =e28*e28;
  e382 =e38*e38;

  e003 =e00*e00*e00;
  e103 =e10*e10*e10;
  e203 =e20*e20*e20;
  e303 =e30*e30*e30;
  e013 =e01*e01*e01;
  e113 =e11*e11*e11;
  e213 =e21*e21*e21;
  e313 =e31*e31*e31;
  e023 =e02*e02*e02;
  e123 =e12*e12*e12;
  e223 =e22*e22*e22;
  e323 =e32*e32*e32;
  e033 =e03*e03*e03;
  e133 =e13*e13*e13;
  e233 =e23*e23*e23;
  e333 =e33*e33*e33;
  e043 =e04*e04*e04;
  e143 =e14*e14*e14;
  e243 =e24*e24*e24;
  e343 =e34*e34*e34;
  e053 =e05*e05*e05;
  e153 =e15*e15*e15;
  e253 =e25*e25*e25;
  e353 =e35*e35*e35;
  e063 =e06*e06*e06;
  e163 =e16*e16*e16;
  e263 =e26*e26*e26;
  e363 =e36*e36*e36;
  e073 =e07*e07*e07;
  e173 =e17*e17*e17;
  e273 =e27*e27*e27;
  e373 =e37*e37*e37;
  e083 =e08*e08*e08;
  e183 =e18*e18*e18;
  e283 =e28*e28*e28;
  e383 =e38*e38*e38;

  A(0,0)=e00*e04*e08-e00*e05*e07-e01*e03*e08+e01*e05*e06+e02*e03*e07-e02*e04*e06;
  A(0,1)=e10*e14*e18-e10*e15*e17-e11*e13*e18+e11*e15*e16+e12*e13*e17-e12*e14*e16;
  A(0,2)=e00*e04*e18-e00*e05*e17-e00*e07*e15+e00*e08*e14-e01*e03*e18+e01*e05*e16+e01*e06*e15-e01*e08*e13+e02*e03*e17-e02*e04*e16-e02*e06*e14+e02*e07*e13+e03*e07*e12-e03*e08*e11-e04*e06*e12+e04*e08*e10+e05*e06*e11-e05*e07*e10;
  A(0,3)=e00*e14*e18-e00*e15*e17-e01*e13*e18+e01*e15*e16+e02*e13*e17-e02*e14*e16-e03*e11*e18+e03*e12*e17+e04*e10*e18-e04*e12*e16-e05*e10*e17+e05*e11*e16+e06*e11*e15-e06*e12*e14-e07*e10*e15+e07*e12*e13+e08*e10*e14-e08*e11*e13;
  A(0,4)=e00*e04*e28-e00*e05*e27-e00*e07*e25+e00*e08*e24-e01*e03*e28+e01*e05*e26+e01*e06*e25-e01*e08*e23+e02*e03*e27-e02*e04*e26-e02*e06*e24+e02*e07*e23+e03*e07*e22-e03*e08*e21-e04*e06*e22+e04*e08*e20+e05*e06*e21-e05*e07*e20;
  A(0,5)=e00*e04*e38-e00*e05*e37-e00*e07*e35+e00*e08*e34-e01*e03*e38+e01*e05*e36+e01*e06*e35-e01*e08*e33+e02*e03*e37-e02*e04*e36-e02*e06*e34+e02*e07*e33+e03*e07*e32-e03*e08*e31-e04*e06*e32+e04*e08*e30+e05*e06*e31-e05*e07*e30;
  A(0,6)=e10*e14*e28-e10*e15*e27-e10*e17*e25+e10*e18*e24-e11*e13*e28+e11*e15*e26+e11*e16*e25-e11*e18*e23+e12*e13*e27-e12*e14*e26-e12*e16*e24+e12*e17*e23+e13*e17*e22-e13*e18*e21-e14*e16*e22+e14*e18*e20+e15*e16*e21-e15*e17*e20;
  A(0,7)=e10*e14*e38-e10*e15*e37-e10*e17*e35+e10*e18*e34-e11*e13*e38+e11*e15*e36+e11*e16*e35-e11*e18*e33+e12*e13*e37-e12*e14*e36-e12*e16*e34+e12*e17*e33+e13*e17*e32-e13*e18*e31-e14*e16*e32+e14*e18*e30+e15*e16*e31-e15*e17*e30;
  A(0,8)=e00*e14*e28-e00*e15*e27-e00*e17*e25+e00*e18*e24-e01*e13*e28+e01*e15*e26+e01*e16*e25-e01*e18*e23+e02*e13*e27-e02*e14*e26-e02*e16*e24+e02*e17*e23-e03*e11*e28+e03*e12*e27+e03*e17*e22-e03*e18*e21+e04*e10*e28-e04*e12*e26-e04*e16*e22+e04*e18*e20-e05*e10*e27+e05*e11*e26+e05*e16*e21-e05*e17*e20+e06*e11*e25-e06*e12*e24-e06*e14*e22+e06*e15*e21-e07*e10*e25+e07*e12*e23+e07*e13*e22-e07*e15*e20+e08*e10*e24-e08*e11*e23-e08*e13*e21+e08*e14*e20;
  A(0,9)=e00*e14*e38-e00*e15*e37-e00*e17*e35+e00*e18*e34-e01*e13*e38+e01*e15*e36+e01*e16*e35-e01*e18*e33+e02*e13*e37-e02*e14*e36-e02*e16*e34+e02*e17*e33-e03*e11*e38+e03*e12*e37+e03*e17*e32-e03*e18*e31+e04*e10*e38-e04*e12*e36-e04*e16*e32+e04*e18*e30-e05*e10*e37+e05*e11*e36+e05*e16*e31-e05*e17*e30+e06*e11*e35-e06*e12*e34-e06*e14*e32+e06*e15*e31-e07*e10*e35+e07*e12*e33+e07*e13*e32-e07*e15*e30+e08*e10*e34-e08*e11*e33-e08*e13*e31+e08*e14*e30;
  A(0,10)=e00*e24*e28-e00*e25*e27-e01*e23*e28+e01*e25*e26+e02*e23*e27-e02*e24*e26-e03*e21*e28+e03*e22*e27+e04*e20*e28-e04*e22*e26-e05*e20*e27+e05*e21*e26+e06*e21*e25-e06*e22*e24-e07*e20*e25+e07*e22*e23+e08*e20*e24-e08*e21*e23;
  A(0,11)=e00*e24*e38-e00*e25*e37-e00*e27*e35+e00*e28*e34-e01*e23*e38+e01*e25*e36+e01*e26*e35-e01*e28*e33+e02*e23*e37-e02*e24*e36-e02*e26*e34+e02*e27*e33-e03*e21*e38+e03*e22*e37+e03*e27*e32-e03*e28*e31+e04*e20*e38-e04*e22*e36-e04*e26*e32+e04*e28*e30-e05*e20*e37+e05*e21*e36+e05*e26*e31-e05*e27*e30+e06*e21*e35-e06*e22*e34-e06*e24*e32+e06*e25*e31-e07*e20*e35+e07*e22*e33+e07*e23*e32-e07*e25*e30+e08*e20*e34-e08*e21*e33-e08*e23*e31+e08*e24*e30;
  A(0,12)=e00*e34*e38-e00*e35*e37-e01*e33*e38+e01*e35*e36+e02*e33*e37-e02*e34*e36-e03*e31*e38+e03*e32*e37+e04*e30*e38-e04*e32*e36-e05*e30*e37+e05*e31*e36+e06*e31*e35-e06*e32*e34-e07*e30*e35+e07*e32*e33+e08*e30*e34-e08*e31*e33;
  A(0,13)=e10*e24*e28-e10*e25*e27-e11*e23*e28+e11*e25*e26+e12*e23*e27-e12*e24*e26-e13*e21*e28+e13*e22*e27+e14*e20*e28-e14*e22*e26-e15*e20*e27+e15*e21*e26+e16*e21*e25-e16*e22*e24-e17*e20*e25+e17*e22*e23+e18*e20*e24-e18*e21*e23;
  A(0,14)=e10*e24*e38-e10*e25*e37-e10*e27*e35+e10*e28*e34-e11*e23*e38+e11*e25*e36+e11*e26*e35-e11*e28*e33+e12*e23*e37-e12*e24*e36-e12*e26*e34+e12*e27*e33-e13*e21*e38+e13*e22*e37+e13*e27*e32-e13*e28*e31+e14*e20*e38-e14*e22*e36-e14*e26*e32+e14*e28*e30-e15*e20*e37+e15*e21*e36+e15*e26*e31-e15*e27*e30+e16*e21*e35-e16*e22*e34-e16*e24*e32+e16*e25*e31-e17*e20*e35+e17*e22*e33+e17*e23*e32-e17*e25*e30+e18*e20*e34-e18*e21*e33-e18*e23*e31+e18*e24*e30;
  A(0,15)=e10*e34*e38-e10*e35*e37-e11*e33*e38+e11*e35*e36+e12*e33*e37-e12*e34*e36-e13*e31*e38+e13*e32*e37+e14*e30*e38-e14*e32*e36-e15*e30*e37+e15*e31*e36+e16*e31*e35-e16*e32*e34-e17*e30*e35+e17*e32*e33+e18*e30*e34-e18*e31*e33;
  A(0,16)=e20*e24*e28-e20*e25*e27-e21*e23*e28+e21*e25*e26+e22*e23*e27-e22*e24*e26;
  A(0,17)=e20*e24*e38-e20*e25*e37-e20*e27*e35+e20*e28*e34-e21*e23*e38+e21*e25*e36+e21*e26*e35-e21*e28*e33+e22*e23*e37-e22*e24*e36-e22*e26*e34+e22*e27*e33+e23*e27*e32-e23*e28*e31-e24*e26*e32+e24*e28*e30+e25*e26*e31-e25*e27*e30;
  A(0,18)=e20*e34*e38-e20*e35*e37-e21*e33*e38+e21*e35*e36+e22*e33*e37-e22*e34*e36-e23*e31*e38+e23*e32*e37+e24*e30*e38-e24*e32*e36-e25*e30*e37+e25*e31*e36+e26*e31*e35-e26*e32*e34-e27*e30*e35+e27*e32*e33+e28*e30*e34-e28*e31*e33;
  A(0,19)=e30*e34*e38-e30*e35*e37-e31*e33*e38+e31*e35*e36+e32*e33*e37-e32*e34*e36;
  A(1,0)=e003+e00*e012+e00*e022+e00*e032-e00*e042-e00*e052+e00*e062-e00*e072-e00*e082+2*e01*e03*e04+2*e01*e06*e07+2*e02*e03*e05+2*e02*e06*e08;
  A(1,1)=e103+e10*e112+e10*e122+e10*e132-e10*e142-e10*e152+e10*e162-e10*e172-e10*e182+2*e11*e13*e14+2*e11*e16*e17+2*e12*e13*e15+2*e12*e16*e18;
  A(1,2)=3*e002*e10+2*e00*e01*e11+2*e00*e02*e12+2*e00*e03*e13-2*e00*e04*e14-2*e00*e05*e15+2*e00*e06*e16-2*e00*e07*e17-2*e00*e08*e18+e012*e10+2*e01*e03*e14+2*e01*e04*e13+2*e01*e06*e17+2*e01*e07*e16+e022*e10+2*e02*e03*e15+2*e02*e05*e13+2*e02*e06*e18+2*e02*e08*e16+e032*e10+2*e03*e04*e11+2*e03*e05*e12-e042*e10-e052*e10+e062*e10+2*e06*e07*e11+2*e06*e08*e12-e072*e10-e082*e10;
  A(1,3)=3*e00*e102+e00*e112+e00*e122+e00*e132-e00*e142-e00*e152+e00*e162-e00*e172-e00*e182+2*e01*e10*e11+2*e01*e13*e14+2*e01*e16*e17+2*e02*e10*e12+2*e02*e13*e15+2*e02*e16*e18+2*e03*e10*e13+2*e03*e11*e14+2*e03*e12*e15-2*e04*e10*e14+2*e04*e11*e13-2*e05*e10*e15+2*e05*e12*e13+2*e06*e10*e16+2*e06*e11*e17+2*e06*e12*e18-2*e07*e10*e17+2*e07*e11*e16-2*e08*e10*e18+2*e08*e12*e16;
  A(1,4)=3*e002*e20+2*e00*e01*e21+2*e00*e02*e22+2*e00*e03*e23-2*e00*e04*e24-2*e00*e05*e25+2*e00*e06*e26-2*e00*e07*e27-2*e00*e08*e28+e012*e20+2*e01*e03*e24+2*e01*e04*e23+2*e01*e06*e27+2*e01*e07*e26+e022*e20+2*e02*e03*e25+2*e02*e05*e23+2*e02*e06*e28+2*e02*e08*e26+e032*e20+2*e03*e04*e21+2*e03*e05*e22-e042*e20-e052*e20+e062*e20+2*e06*e07*e21+2*e06*e08*e22-e072*e20-e082*e20;
  A(1,5)=3*e002*e30+2*e00*e01*e31+2*e00*e02*e32+2*e00*e03*e33-2*e00*e04*e34-2*e00*e05*e35+2*e00*e06*e36-2*e00*e07*e37-2*e00*e08*e38+e012*e30+2*e01*e03*e34+2*e01*e04*e33+2*e01*e06*e37+2*e01*e07*e36+e022*e30+2*e02*e03*e35+2*e02*e05*e33+2*e02*e06*e38+2*e02*e08*e36+e032*e30+2*e03*e04*e31+2*e03*e05*e32-e042*e30-e052*e30+e062*e30+2*e06*e07*e31+2*e06*e08*e32-e072*e30-e082*e30;
  A(1,6)=3*e102*e20+2*e10*e11*e21+2*e10*e12*e22+2*e10*e13*e23-2*e10*e14*e24-2*e10*e15*e25+2*e10*e16*e26-2*e10*e17*e27-2*e10*e18*e28+e112*e20+2*e11*e13*e24+2*e11*e14*e23+2*e11*e16*e27+2*e11*e17*e26+e122*e20+2*e12*e13*e25+2*e12*e15*e23+2*e12*e16*e28+2*e12*e18*e26+e132*e20+2*e13*e14*e21+2*e13*e15*e22-e142*e20-e152*e20+e162*e20+2*e16*e17*e21+2*e16*e18*e22-e172*e20-e182*e20;
  A(1,7)=3*e102*e30+2*e10*e11*e31+2*e10*e12*e32+2*e10*e13*e33-2*e10*e14*e34-2*e10*e15*e35+2*e10*e16*e36-2*e10*e17*e37-2*e10*e18*e38+e112*e30+2*e11*e13*e34+2*e11*e14*e33+2*e11*e16*e37+2*e11*e17*e36+e122*e30+2*e12*e13*e35+2*e12*e15*e33+2*e12*e16*e38+2*e12*e18*e36+e132*e30+2*e13*e14*e31+2*e13*e15*e32-e142*e30-e152*e30+e162*e30+2*e16*e17*e31+2*e16*e18*e32-e172*e30-e182*e30;
  A(1,8)=6*e00*e10*e20+2*e00*e11*e21+2*e00*e12*e22+2*e00*e13*e23-2*e00*e14*e24-2*e00*e15*e25+2*e00*e16*e26-2*e00*e17*e27-2*e00*e18*e28+2*e01*e10*e21+2*e01*e11*e20+2*e01*e13*e24+2*e01*e14*e23+2*e01*e16*e27+2*e01*e17*e26+2*e02*e10*e22+2*e02*e12*e20+2*e02*e13*e25+2*e02*e15*e23+2*e02*e16*e28+2*e02*e18*e26+2*e03*e10*e23+2*e03*e11*e24+2*e03*e12*e25+2*e03*e13*e20+2*e03*e14*e21+2*e03*e15*e22-2*e04*e10*e24+2*e04*e11*e23+2*e04*e13*e21-2*e04*e14*e20-2*e05*e10*e25+2*e05*e12*e23+2*e05*e13*e22-2*e05*e15*e20+2*e06*e10*e26+2*e06*e11*e27+2*e06*e12*e28+2*e06*e16*e20+2*e06*e17*e21+2*e06*e18*e22-2*e07*e10*e27+2*e07*e11*e26+2*e07*e16*e21-2*e07*e17*e20-2*e08*e10*e28+2*e08*e12*e26+2*e08*e16*e22-2*e08*e18*e20;
  A(1,9)=6*e00*e10*e30+2*e00*e11*e31+2*e00*e12*e32+2*e00*e13*e33-2*e00*e14*e34-2*e00*e15*e35+2*e00*e16*e36-2*e00*e17*e37-2*e00*e18*e38+2*e01*e10*e31+2*e01*e11*e30+2*e01*e13*e34+2*e01*e14*e33+2*e01*e16*e37+2*e01*e17*e36+2*e02*e10*e32+2*e02*e12*e30+2*e02*e13*e35+2*e02*e15*e33+2*e02*e16*e38+2*e02*e18*e36+2*e03*e10*e33+2*e03*e11*e34+2*e03*e12*e35+2*e03*e13*e30+2*e03*e14*e31+2*e03*e15*e32-2*e04*e10*e34+2*e04*e11*e33+2*e04*e13*e31-2*e04*e14*e30-2*e05*e10*e35+2*e05*e12*e33+2*e05*e13*e32-2*e05*e15*e30+2*e06*e10*e36+2*e06*e11*e37+2*e06*e12*e38+2*e06*e16*e30+2*e06*e17*e31+2*e06*e18*e32-2*e07*e10*e37+2*e07*e11*e36+2*e07*e16*e31-2*e07*e17*e30-2*e08*e10*e38+2*e08*e12*e36+2*e08*e16*e32-2*e08*e18*e30;
  A(1,10)=3*e00*e202+e00*e212+e00*e222+e00*e232-e00*e242-e00*e252+e00*e262-e00*e272-e00*e282+2*e01*e20*e21+2*e01*e23*e24+2*e01*e26*e27+2*e02*e20*e22+2*e02*e23*e25+2*e02*e26*e28+2*e03*e20*e23+2*e03*e21*e24+2*e03*e22*e25-2*e04*e20*e24+2*e04*e21*e23-2*e05*e20*e25+2*e05*e22*e23+2*e06*e20*e26+2*e06*e21*e27+2*e06*e22*e28-2*e07*e20*e27+2*e07*e21*e26-2*e08*e20*e28+2*e08*e22*e26;
  A(1,11)=6*e00*e20*e30+2*e00*e21*e31+2*e00*e22*e32+2*e00*e23*e33-2*e00*e24*e34-2*e00*e25*e35+2*e00*e26*e36-2*e00*e27*e37-2*e00*e28*e38+2*e01*e20*e31+2*e01*e21*e30+2*e01*e23*e34+2*e01*e24*e33+2*e01*e26*e37+2*e01*e27*e36+2*e02*e20*e32+2*e02*e22*e30+2*e02*e23*e35+2*e02*e25*e33+2*e02*e26*e38+2*e02*e28*e36+2*e03*e20*e33+2*e03*e21*e34+2*e03*e22*e35+2*e03*e23*e30+2*e03*e24*e31+2*e03*e25*e32-2*e04*e20*e34+2*e04*e21*e33+2*e04*e23*e31-2*e04*e24*e30-2*e05*e20*e35+2*e05*e22*e33+2*e05*e23*e32-2*e05*e25*e30+2*e06*e20*e36+2*e06*e21*e37+2*e06*e22*e38+2*e06*e26*e30+2*e06*e27*e31+2*e06*e28*e32-2*e07*e20*e37+2*e07*e21*e36+2*e07*e26*e31-2*e07*e27*e30-2*e08*e20*e38+2*e08*e22*e36+2*e08*e26*e32-2*e08*e28*e30;
  A(1,12)=3*e00*e302+e00*e312+e00*e322+e00*e332-e00*e342-e00*e352+e00*e362-e00*e372-e00*e382+2*e01*e30*e31+2*e01*e33*e34+2*e01*e36*e37+2*e02*e30*e32+2*e02*e33*e35+2*e02*e36*e38+2*e03*e30*e33+2*e03*e31*e34+2*e03*e32*e35-2*e04*e30*e34+2*e04*e31*e33-2*e05*e30*e35+2*e05*e32*e33+2*e06*e30*e36+2*e06*e31*e37+2*e06*e32*e38-2*e07*e30*e37+2*e07*e31*e36-2*e08*e30*e38+2*e08*e32*e36;
  A(1,13)=3*e10*e202+e10*e212+e10*e222+e10*e232-e10*e242-e10*e252+e10*e262-e10*e272-e10*e282+2*e11*e20*e21+2*e11*e23*e24+2*e11*e26*e27+2*e12*e20*e22+2*e12*e23*e25+2*e12*e26*e28+2*e13*e20*e23+2*e13*e21*e24+2*e13*e22*e25-2*e14*e20*e24+2*e14*e21*e23-2*e15*e20*e25+2*e15*e22*e23+2*e16*e20*e26+2*e16*e21*e27+2*e16*e22*e28-2*e17*e20*e27+2*e17*e21*e26-2*e18*e20*e28+2*e18*e22*e26;
  A(1,14)=6*e10*e20*e30+2*e10*e21*e31+2*e10*e22*e32+2*e10*e23*e33-2*e10*e24*e34-2*e10*e25*e35+2*e10*e26*e36-2*e10*e27*e37-2*e10*e28*e38+2*e11*e20*e31+2*e11*e21*e30+2*e11*e23*e34+2*e11*e24*e33+2*e11*e26*e37+2*e11*e27*e36+2*e12*e20*e32+2*e12*e22*e30+2*e12*e23*e35+2*e12*e25*e33+2*e12*e26*e38+2*e12*e28*e36+2*e13*e20*e33+2*e13*e21*e34+2*e13*e22*e35+2*e13*e23*e30+2*e13*e24*e31+2*e13*e25*e32-2*e14*e20*e34+2*e14*e21*e33+2*e14*e23*e31-2*e14*e24*e30-2*e15*e20*e35+2*e15*e22*e33+2*e15*e23*e32-2*e15*e25*e30+2*e16*e20*e36+2*e16*e21*e37+2*e16*e22*e38+2*e16*e26*e30+2*e16*e27*e31+2*e16*e28*e32-2*e17*e20*e37+2*e17*e21*e36+2*e17*e26*e31-2*e17*e27*e30-2*e18*e20*e38+2*e18*e22*e36+2*e18*e26*e32-2*e18*e28*e30;
  A(1,15)=3*e10*e302+e10*e312+e10*e322+e10*e332-e10*e342-e10*e352+e10*e362-e10*e372-e10*e382+2*e11*e30*e31+2*e11*e33*e34+2*e11*e36*e37+2*e12*e30*e32+2*e12*e33*e35+2*e12*e36*e38+2*e13*e30*e33+2*e13*e31*e34+2*e13*e32*e35-2*e14*e30*e34+2*e14*e31*e33-2*e15*e30*e35+2*e15*e32*e33+2*e16*e30*e36+2*e16*e31*e37+2*e16*e32*e38-2*e17*e30*e37+2*e17*e31*e36-2*e18*e30*e38+2*e18*e32*e36;
  A(1,16)=e203+e20*e212+e20*e222+e20*e232-e20*e242-e20*e252+e20*e262-e20*e272-e20*e282+2*e21*e23*e24+2*e21*e26*e27+2*e22*e23*e25+2*e22*e26*e28;
  A(1,17)=3*e202*e30+2*e20*e21*e31+2*e20*e22*e32+2*e20*e23*e33-2*e20*e24*e34-2*e20*e25*e35+2*e20*e26*e36-2*e20*e27*e37-2*e20*e28*e38+e212*e30+2*e21*e23*e34+2*e21*e24*e33+2*e21*e26*e37+2*e21*e27*e36+e222*e30+2*e22*e23*e35+2*e22*e25*e33+2*e22*e26*e38+2*e22*e28*e36+e232*e30+2*e23*e24*e31+2*e23*e25*e32-e242*e30-e252*e30+e262*e30+2*e26*e27*e31+2*e26*e28*e32-e272*e30-e282*e30;
  A(1,18)=3*e20*e302+e20*e312+e20*e322+e20*e332-e20*e342-e20*e352+e20*e362-e20*e372-e20*e382+2*e21*e30*e31+2*e21*e33*e34+2*e21*e36*e37+2*e22*e30*e32+2*e22*e33*e35+2*e22*e36*e38+2*e23*e30*e33+2*e23*e31*e34+2*e23*e32*e35-2*e24*e30*e34+2*e24*e31*e33-2*e25*e30*e35+2*e25*e32*e33+2*e26*e30*e36+2*e26*e31*e37+2*e26*e32*e38-2*e27*e30*e37+2*e27*e31*e36-2*e28*e30*e38+2*e28*e32*e36;
  A(1,19)=e303+e30*e312+e30*e322+e30*e332-e30*e342-e30*e352+e30*e362-e30*e372-e30*e382+2*e31*e33*e34+2*e31*e36*e37+2*e32*e33*e35+2*e32*e36*e38;
  A(2,0)=e002*e03+2*e00*e01*e04+2*e00*e02*e05-e012*e03-e022*e03+e033+e03*e042+e03*e052+e03*e062-e03*e072-e03*e082+2*e04*e06*e07+2*e05*e06*e08;
  A(2,1)=e102*e13+2*e10*e11*e14+2*e10*e12*e15-e112*e13-e122*e13+e133+e13*e142+e13*e152+e13*e162-e13*e172-e13*e182+2*e14*e16*e17+2*e15*e16*e18;
  A(2,2)=e002*e13+2*e00*e01*e14+2*e00*e02*e15+2*e00*e03*e10+2*e00*e04*e11+2*e00*e05*e12-e012*e13-2*e01*e03*e11+2*e01*e04*e10-e022*e13-2*e02*e03*e12+2*e02*e05*e10+3*e032*e13+2*e03*e04*e14+2*e03*e05*e15+2*e03*e06*e16-2*e03*e07*e17-2*e03*e08*e18+e042*e13+2*e04*e06*e17+2*e04*e07*e16+e052*e13+2*e05*e06*e18+2*e05*e08*e16+e062*e13+2*e06*e07*e14+2*e06*e08*e15-e072*e13-e082*e13;
  A(2,3)=2*e00*e10*e13+2*e00*e11*e14+2*e00*e12*e15+2*e01*e10*e14-2*e01*e11*e13+2*e02*e10*e15-2*e02*e12*e13+e03*e102-e03*e112-e03*e122+3*e03*e132+e03*e142+e03*e152+e03*e162-e03*e172-e03*e182+2*e04*e10*e11+2*e04*e13*e14+2*e04*e16*e17+2*e05*e10*e12+2*e05*e13*e15+2*e05*e16*e18+2*e06*e13*e16+2*e06*e14*e17+2*e06*e15*e18-2*e07*e13*e17+2*e07*e14*e16-2*e08*e13*e18+2*e08*e15*e16;
  A(2,4)=e002*e23+2*e00*e01*e24+2*e00*e02*e25+2*e00*e03*e20+2*e00*e04*e21+2*e00*e05*e22-e012*e23-2*e01*e03*e21+2*e01*e04*e20-e022*e23-2*e02*e03*e22+2*e02*e05*e20+3*e032*e23+2*e03*e04*e24+2*e03*e05*e25+2*e03*e06*e26-2*e03*e07*e27-2*e03*e08*e28+e042*e23+2*e04*e06*e27+2*e04*e07*e26+e052*e23+2*e05*e06*e28+2*e05*e08*e26+e062*e23+2*e06*e07*e24+2*e06*e08*e25-e072*e23-e082*e23;
  A(2,5)=e002*e33+2*e00*e01*e34+2*e00*e02*e35+2*e00*e03*e30+2*e00*e04*e31+2*e00*e05*e32-e012*e33-2*e01*e03*e31+2*e01*e04*e30-e022*e33-2*e02*e03*e32+2*e02*e05*e30+3*e032*e33+2*e03*e04*e34+2*e03*e05*e35+2*e03*e06*e36-2*e03*e07*e37-2*e03*e08*e38+e042*e33+2*e04*e06*e37+2*e04*e07*e36+e052*e33+2*e05*e06*e38+2*e05*e08*e36+e062*e33+2*e06*e07*e34+2*e06*e08*e35-e072*e33-e082*e33;
  A(2,6)=e102*e23+2*e10*e11*e24+2*e10*e12*e25+2*e10*e13*e20+2*e10*e14*e21+2*e10*e15*e22-e112*e23-2*e11*e13*e21+2*e11*e14*e20-e122*e23-2*e12*e13*e22+2*e12*e15*e20+3*e132*e23+2*e13*e14*e24+2*e13*e15*e25+2*e13*e16*e26-2*e13*e17*e27-2*e13*e18*e28+e142*e23+2*e14*e16*e27+2*e14*e17*e26+e152*e23+2*e15*e16*e28+2*e15*e18*e26+e162*e23+2*e16*e17*e24+2*e16*e18*e25-e172*e23-e182*e23;
  A(2,7)=e102*e33+2*e10*e11*e34+2*e10*e12*e35+2*e10*e13*e30+2*e10*e14*e31+2*e10*e15*e32-e112*e33-2*e11*e13*e31+2*e11*e14*e30-e122*e33-2*e12*e13*e32+2*e12*e15*e30+3*e132*e33+2*e13*e14*e34+2*e13*e15*e35+2*e13*e16*e36-2*e13*e17*e37-2*e13*e18*e38+e142*e33+2*e14*e16*e37+2*e14*e17*e36+e152*e33+2*e15*e16*e38+2*e15*e18*e36+e162*e33+2*e16*e17*e34+2*e16*e18*e35-e172*e33-e182*e33;
  A(2,8)=2*e00*e10*e23+2*e00*e11*e24+2*e00*e12*e25+2*e00*e13*e20+2*e00*e14*e21+2*e00*e15*e22+2*e01*e10*e24-2*e01*e11*e23-2*e01*e13*e21+2*e01*e14*e20+2*e02*e10*e25-2*e02*e12*e23-2*e02*e13*e22+2*e02*e15*e20+2*e03*e10*e20-2*e03*e11*e21-2*e03*e12*e22+6*e03*e13*e23+2*e03*e14*e24+2*e03*e15*e25+2*e03*e16*e26-2*e03*e17*e27-2*e03*e18*e28+2*e04*e10*e21+2*e04*e11*e20+2*e04*e13*e24+2*e04*e14*e23+2*e04*e16*e27+2*e04*e17*e26+2*e05*e10*e22+2*e05*e12*e20+2*e05*e13*e25+2*e05*e15*e23+2*e05*e16*e28+2*e05*e18*e26+2*e06*e13*e26+2*e06*e14*e27+2*e06*e15*e28+2*e06*e16*e23+2*e06*e17*e24+2*e06*e18*e25-2*e07*e13*e27+2*e07*e14*e26+2*e07*e16*e24-2*e07*e17*e23-2*e08*e13*e28+2*e08*e15*e26+2*e08*e16*e25-2*e08*e18*e23;
  A(2,9)=2*e00*e10*e33+2*e00*e11*e34+2*e00*e12*e35+2*e00*e13*e30+2*e00*e14*e31+2*e00*e15*e32+2*e01*e10*e34-2*e01*e11*e33-2*e01*e13*e31+2*e01*e14*e30+2*e02*e10*e35-2*e02*e12*e33-2*e02*e13*e32+2*e02*e15*e30+2*e03*e10*e30-2*e03*e11*e31-2*e03*e12*e32+6*e03*e13*e33+2*e03*e14*e34+2*e03*e15*e35+2*e03*e16*e36-2*e03*e17*e37-2*e03*e18*e38+2*e04*e10*e31+2*e04*e11*e30+2*e04*e13*e34+2*e04*e14*e33+2*e04*e16*e37+2*e04*e17*e36+2*e05*e10*e32+2*e05*e12*e30+2*e05*e13*e35+2*e05*e15*e33+2*e05*e16*e38+2*e05*e18*e36+2*e06*e13*e36+2*e06*e14*e37+2*e06*e15*e38+2*e06*e16*e33+2*e06*e17*e34+2*e06*e18*e35-2*e07*e13*e37+2*e07*e14*e36+2*e07*e16*e34-2*e07*e17*e33-2*e08*e13*e38+2*e08*e15*e36+2*e08*e16*e35-2*e08*e18*e33;
  A(2,10)=2*e00*e20*e23+2*e00*e21*e24+2*e00*e22*e25+2*e01*e20*e24-2*e01*e21*e23+2*e02*e20*e25-2*e02*e22*e23+e03*e202-e03*e212-e03*e222+3*e03*e232+e03*e242+e03*e252+e03*e262-e03*e272-e03*e282+2*e04*e20*e21+2*e04*e23*e24+2*e04*e26*e27+2*e05*e20*e22+2*e05*e23*e25+2*e05*e26*e28+2*e06*e23*e26+2*e06*e24*e27+2*e06*e25*e28-2*e07*e23*e27+2*e07*e24*e26-2*e08*e23*e28+2*e08*e25*e26;
  A(2,11)=2*e00*e20*e33+2*e00*e21*e34+2*e00*e22*e35+2*e00*e23*e30+2*e00*e24*e31+2*e00*e25*e32+2*e01*e20*e34-2*e01*e21*e33-2*e01*e23*e31+2*e01*e24*e30+2*e02*e20*e35-2*e02*e22*e33-2*e02*e23*e32+2*e02*e25*e30+2*e03*e20*e30-2*e03*e21*e31-2*e03*e22*e32+6*e03*e23*e33+2*e03*e24*e34+2*e03*e25*e35+2*e03*e26*e36-2*e03*e27*e37-2*e03*e28*e38+2*e04*e20*e31+2*e04*e21*e30+2*e04*e23*e34+2*e04*e24*e33+2*e04*e26*e37+2*e04*e27*e36+2*e05*e20*e32+2*e05*e22*e30+2*e05*e23*e35+2*e05*e25*e33+2*e05*e26*e38+2*e05*e28*e36+2*e06*e23*e36+2*e06*e24*e37+2*e06*e25*e38+2*e06*e26*e33+2*e06*e27*e34+2*e06*e28*e35-2*e07*e23*e37+2*e07*e24*e36+2*e07*e26*e34-2*e07*e27*e33-2*e08*e23*e38+2*e08*e25*e36+2*e08*e26*e35-2*e08*e28*e33;
  A(2,12)=2*e00*e30*e33+2*e00*e31*e34+2*e00*e32*e35+2*e01*e30*e34-2*e01*e31*e33+2*e02*e30*e35-2*e02*e32*e33+e03*e302-e03*e312-e03*e322+3*e03*e332+e03*e342+e03*e352+e03*e362-e03*e372-e03*e382+2*e04*e30*e31+2*e04*e33*e34+2*e04*e36*e37+2*e05*e30*e32+2*e05*e33*e35+2*e05*e36*e38+2*e06*e33*e36+2*e06*e34*e37+2*e06*e35*e38-2*e07*e33*e37+2*e07*e34*e36-2*e08*e33*e38+2*e08*e35*e36;
  A(2,13)=2*e10*e20*e23+2*e10*e21*e24+2*e10*e22*e25+2*e11*e20*e24-2*e11*e21*e23+2*e12*e20*e25-2*e12*e22*e23+e13*e202-e13*e212-e13*e222+3*e13*e232+e13*e242+e13*e252+e13*e262-e13*e272-e13*e282+2*e14*e20*e21+2*e14*e23*e24+2*e14*e26*e27+2*e15*e20*e22+2*e15*e23*e25+2*e15*e26*e28+2*e16*e23*e26+2*e16*e24*e27+2*e16*e25*e28-2*e17*e23*e27+2*e17*e24*e26-2*e18*e23*e28+2*e18*e25*e26;
  A(2,14)=2*e10*e20*e33+2*e10*e21*e34+2*e10*e22*e35+2*e10*e23*e30+2*e10*e24*e31+2*e10*e25*e32+2*e11*e20*e34-2*e11*e21*e33-2*e11*e23*e31+2*e11*e24*e30+2*e12*e20*e35-2*e12*e22*e33-2*e12*e23*e32+2*e12*e25*e30+2*e13*e20*e30-2*e13*e21*e31-2*e13*e22*e32+6*e13*e23*e33+2*e13*e24*e34+2*e13*e25*e35+2*e13*e26*e36-2*e13*e27*e37-2*e13*e28*e38+2*e14*e20*e31+2*e14*e21*e30+2*e14*e23*e34+2*e14*e24*e33+2*e14*e26*e37+2*e14*e27*e36+2*e15*e20*e32+2*e15*e22*e30+2*e15*e23*e35+2*e15*e25*e33+2*e15*e26*e38+2*e15*e28*e36+2*e16*e23*e36+2*e16*e24*e37+2*e16*e25*e38+2*e16*e26*e33+2*e16*e27*e34+2*e16*e28*e35-2*e17*e23*e37+2*e17*e24*e36+2*e17*e26*e34-2*e17*e27*e33-2*e18*e23*e38+2*e18*e25*e36+2*e18*e26*e35-2*e18*e28*e33;
  A(2,15)=2*e10*e30*e33+2*e10*e31*e34+2*e10*e32*e35+2*e11*e30*e34-2*e11*e31*e33+2*e12*e30*e35-2*e12*e32*e33+e13*e302-e13*e312-e13*e322+3*e13*e332+e13*e342+e13*e352+e13*e362-e13*e372-e13*e382+2*e14*e30*e31+2*e14*e33*e34+2*e14*e36*e37+2*e15*e30*e32+2*e15*e33*e35+2*e15*e36*e38+2*e16*e33*e36+2*e16*e34*e37+2*e16*e35*e38-2*e17*e33*e37+2*e17*e34*e36-2*e18*e33*e38+2*e18*e35*e36;
  A(2,16)=e202*e23+2*e20*e21*e24+2*e20*e22*e25-e212*e23-e222*e23+e233+e23*e242+e23*e252+e23*e262-e23*e272-e23*e282+2*e24*e26*e27+2*e25*e26*e28;
  A(2,17)=e202*e33+2*e20*e21*e34+2*e20*e22*e35+2*e20*e23*e30+2*e20*e24*e31+2*e20*e25*e32-e212*e33-2*e21*e23*e31+2*e21*e24*e30-e222*e33-2*e22*e23*e32+2*e22*e25*e30+3*e232*e33+2*e23*e24*e34+2*e23*e25*e35+2*e23*e26*e36-2*e23*e27*e37-2*e23*e28*e38+e242*e33+2*e24*e26*e37+2*e24*e27*e36+e252*e33+2*e25*e26*e38+2*e25*e28*e36+e262*e33+2*e26*e27*e34+2*e26*e28*e35-e272*e33-e282*e33;
  A(2,18)=2*e20*e30*e33+2*e20*e31*e34+2*e20*e32*e35+2*e21*e30*e34-2*e21*e31*e33+2*e22*e30*e35-2*e22*e32*e33+e23*e302-e23*e312-e23*e322+3*e23*e332+e23*e342+e23*e352+e23*e362-e23*e372-e23*e382+2*e24*e30*e31+2*e24*e33*e34+2*e24*e36*e37+2*e25*e30*e32+2*e25*e33*e35+2*e25*e36*e38+2*e26*e33*e36+2*e26*e34*e37+2*e26*e35*e38-2*e27*e33*e37+2*e27*e34*e36-2*e28*e33*e38+2*e28*e35*e36;
  A(2,19)=e302*e33+2*e30*e31*e34+2*e30*e32*e35-e312*e33-e322*e33+e333+e33*e342+e33*e352+e33*e362-e33*e372-e33*e382+2*e34*e36*e37+2*e35*e36*e38;
  A(3,0)=e002*e06+2*e00*e01*e07+2*e00*e02*e08-e012*e06-e022*e06+e032*e06+2*e03*e04*e07+2*e03*e05*e08-e042*e06-e052*e06+e063+e06*e072+e06*e082;
  A(3,1)=e102*e16+2*e10*e11*e17+2*e10*e12*e18-e112*e16-e122*e16+e132*e16+2*e13*e14*e17+2*e13*e15*e18-e142*e16-e152*e16+e163+e16*e172+e16*e182;
  A(3,2)=e002*e16+2*e00*e01*e17+2*e00*e02*e18+2*e00*e06*e10+2*e00*e07*e11+2*e00*e08*e12-e012*e16-2*e01*e06*e11+2*e01*e07*e10-e022*e16-2*e02*e06*e12+2*e02*e08*e10+e032*e16+2*e03*e04*e17+2*e03*e05*e18+2*e03*e06*e13+2*e03*e07*e14+2*e03*e08*e15-e042*e16-2*e04*e06*e14+2*e04*e07*e13-e052*e16-2*e05*e06*e15+2*e05*e08*e13+3*e062*e16+2*e06*e07*e17+2*e06*e08*e18+e072*e16+e082*e16;
  A(3,3)=2*e00*e10*e16+2*e00*e11*e17+2*e00*e12*e18+2*e01*e10*e17-2*e01*e11*e16+2*e02*e10*e18-2*e02*e12*e16+2*e03*e13*e16+2*e03*e14*e17+2*e03*e15*e18+2*e04*e13*e17-2*e04*e14*e16+2*e05*e13*e18-2*e05*e15*e16+e06*e102-e06*e112-e06*e122+e06*e132-e06*e142-e06*e152+3*e06*e162+e06*e172+e06*e182+2*e07*e10*e11+2*e07*e13*e14+2*e07*e16*e17+2*e08*e10*e12+2*e08*e13*e15+2*e08*e16*e18;
  A(3,4)=e002*e26+2*e00*e01*e27+2*e00*e02*e28+2*e00*e06*e20+2*e00*e07*e21+2*e00*e08*e22-e012*e26-2*e01*e06*e21+2*e01*e07*e20-e022*e26-2*e02*e06*e22+2*e02*e08*e20+e032*e26+2*e03*e04*e27+2*e03*e05*e28+2*e03*e06*e23+2*e03*e07*e24+2*e03*e08*e25-e042*e26-2*e04*e06*e24+2*e04*e07*e23-e052*e26-2*e05*e06*e25+2*e05*e08*e23+3*e062*e26+2*e06*e07*e27+2*e06*e08*e28+e072*e26+e082*e26;
  A(3,5)=e002*e36+2*e00*e01*e37+2*e00*e02*e38+2*e00*e06*e30+2*e00*e07*e31+2*e00*e08*e32-e012*e36-2*e01*e06*e31+2*e01*e07*e30-e022*e36-2*e02*e06*e32+2*e02*e08*e30+e032*e36+2*e03*e04*e37+2*e03*e05*e38+2*e03*e06*e33+2*e03*e07*e34+2*e03*e08*e35-e042*e36-2*e04*e06*e34+2*e04*e07*e33-e052*e36-2*e05*e06*e35+2*e05*e08*e33+3*e062*e36+2*e06*e07*e37+2*e06*e08*e38+e072*e36+e082*e36;
  A(3,6)=e102*e26+2*e10*e11*e27+2*e10*e12*e28+2*e10*e16*e20+2*e10*e17*e21+2*e10*e18*e22-e112*e26-2*e11*e16*e21+2*e11*e17*e20-e122*e26-2*e12*e16*e22+2*e12*e18*e20+e132*e26+2*e13*e14*e27+2*e13*e15*e28+2*e13*e16*e23+2*e13*e17*e24+2*e13*e18*e25-e142*e26-2*e14*e16*e24+2*e14*e17*e23-e152*e26-2*e15*e16*e25+2*e15*e18*e23+3*e162*e26+2*e16*e17*e27+2*e16*e18*e28+e172*e26+e182*e26;
  A(3,7)=e102*e36+2*e10*e11*e37+2*e10*e12*e38+2*e10*e16*e30+2*e10*e17*e31+2*e10*e18*e32-e112*e36-2*e11*e16*e31+2*e11*e17*e30-e122*e36-2*e12*e16*e32+2*e12*e18*e30+e132*e36+2*e13*e14*e37+2*e13*e15*e38+2*e13*e16*e33+2*e13*e17*e34+2*e13*e18*e35-e142*e36-2*e14*e16*e34+2*e14*e17*e33-e152*e36-2*e15*e16*e35+2*e15*e18*e33+3*e162*e36+2*e16*e17*e37+2*e16*e18*e38+e172*e36+e182*e36;
  A(3,8)=2*e00*e10*e26+2*e00*e11*e27+2*e00*e12*e28+2*e00*e16*e20+2*e00*e17*e21+2*e00*e18*e22+2*e01*e10*e27-2*e01*e11*e26-2*e01*e16*e21+2*e01*e17*e20+2*e02*e10*e28-2*e02*e12*e26-2*e02*e16*e22+2*e02*e18*e20+2*e03*e13*e26+2*e03*e14*e27+2*e03*e15*e28+2*e03*e16*e23+2*e03*e17*e24+2*e03*e18*e25+2*e04*e13*e27-2*e04*e14*e26-2*e04*e16*e24+2*e04*e17*e23+2*e05*e13*e28-2*e05*e15*e26-2*e05*e16*e25+2*e05*e18*e23+2*e06*e10*e20-2*e06*e11*e21-2*e06*e12*e22+2*e06*e13*e23-2*e06*e14*e24-2*e06*e15*e25+6*e06*e16*e26+2*e06*e17*e27+2*e06*e18*e28+2*e07*e10*e21+2*e07*e11*e20+2*e07*e13*e24+2*e07*e14*e23+2*e07*e16*e27+2*e07*e17*e26+2*e08*e10*e22+2*e08*e12*e20+2*e08*e13*e25+2*e08*e15*e23+2*e08*e16*e28+2*e08*e18*e26;
  A(3,9)=2*e00*e10*e36+2*e00*e11*e37+2*e00*e12*e38+2*e00*e16*e30+2*e00*e17*e31+2*e00*e18*e32+2*e01*e10*e37-2*e01*e11*e36-2*e01*e16*e31+2*e01*e17*e30+2*e02*e10*e38-2*e02*e12*e36-2*e02*e16*e32+2*e02*e18*e30+2*e03*e13*e36+2*e03*e14*e37+2*e03*e15*e38+2*e03*e16*e33+2*e03*e17*e34+2*e03*e18*e35+2*e04*e13*e37-2*e04*e14*e36-2*e04*e16*e34+2*e04*e17*e33+2*e05*e13*e38-2*e05*e15*e36-2*e05*e16*e35+2*e05*e18*e33+2*e06*e10*e30-2*e06*e11*e31-2*e06*e12*e32+2*e06*e13*e33-2*e06*e14*e34-2*e06*e15*e35+6*e06*e16*e36+2*e06*e17*e37+2*e06*e18*e38+2*e07*e10*e31+2*e07*e11*e30+2*e07*e13*e34+2*e07*e14*e33+2*e07*e16*e37+2*e07*e17*e36+2*e08*e10*e32+2*e08*e12*e30+2*e08*e13*e35+2*e08*e15*e33+2*e08*e16*e38+2*e08*e18*e36;
  A(3,10)=2*e00*e20*e26+2*e00*e21*e27+2*e00*e22*e28+2*e01*e20*e27-2*e01*e21*e26+2*e02*e20*e28-2*e02*e22*e26+2*e03*e23*e26+2*e03*e24*e27+2*e03*e25*e28+2*e04*e23*e27-2*e04*e24*e26+2*e05*e23*e28-2*e05*e25*e26+e06*e202-e06*e212-e06*e222+e06*e232-e06*e242-e06*e252+3*e06*e262+e06*e272+e06*e282+2*e07*e20*e21+2*e07*e23*e24+2*e07*e26*e27+2*e08*e20*e22+2*e08*e23*e25+2*e08*e26*e28;
  A(3,11)=2*e00*e20*e36+2*e00*e21*e37+2*e00*e22*e38+2*e00*e26*e30+2*e00*e27*e31+2*e00*e28*e32+2*e01*e20*e37-2*e01*e21*e36-2*e01*e26*e31+2*e01*e27*e30+2*e02*e20*e38-2*e02*e22*e36-2*e02*e26*e32+2*e02*e28*e30+2*e03*e23*e36+2*e03*e24*e37+2*e03*e25*e38+2*e03*e26*e33+2*e03*e27*e34+2*e03*e28*e35+2*e04*e23*e37-2*e04*e24*e36-2*e04*e26*e34+2*e04*e27*e33+2*e05*e23*e38-2*e05*e25*e36-2*e05*e26*e35+2*e05*e28*e33+2*e06*e20*e30-2*e06*e21*e31-2*e06*e22*e32+2*e06*e23*e33-2*e06*e24*e34-2*e06*e25*e35+6*e06*e26*e36+2*e06*e27*e37+2*e06*e28*e38+2*e07*e20*e31+2*e07*e21*e30+2*e07*e23*e34+2*e07*e24*e33+2*e07*e26*e37+2*e07*e27*e36+2*e08*e20*e32+2*e08*e22*e30+2*e08*e23*e35+2*e08*e25*e33+2*e08*e26*e38+2*e08*e28*e36;
  A(3,12)=2*e00*e30*e36+2*e00*e31*e37+2*e00*e32*e38+2*e01*e30*e37-2*e01*e31*e36+2*e02*e30*e38-2*e02*e32*e36+2*e03*e33*e36+2*e03*e34*e37+2*e03*e35*e38+2*e04*e33*e37-2*e04*e34*e36+2*e05*e33*e38-2*e05*e35*e36+e06*e302-e06*e312-e06*e322+e06*e332-e06*e342-e06*e352+3*e06*e362+e06*e372+e06*e382+2*e07*e30*e31+2*e07*e33*e34+2*e07*e36*e37+2*e08*e30*e32+2*e08*e33*e35+2*e08*e36*e38;
  A(3,13)=2*e10*e20*e26+2*e10*e21*e27+2*e10*e22*e28+2*e11*e20*e27-2*e11*e21*e26+2*e12*e20*e28-2*e12*e22*e26+2*e13*e23*e26+2*e13*e24*e27+2*e13*e25*e28+2*e14*e23*e27-2*e14*e24*e26+2*e15*e23*e28-2*e15*e25*e26+e16*e202-e16*e212-e16*e222+e16*e232-e16*e242-e16*e252+3*e16*e262+e16*e272+e16*e282+2*e17*e20*e21+2*e17*e23*e24+2*e17*e26*e27+2*e18*e20*e22+2*e18*e23*e25+2*e18*e26*e28;
  A(3,14)=2*e10*e20*e36+2*e10*e21*e37+2*e10*e22*e38+2*e10*e26*e30+2*e10*e27*e31+2*e10*e28*e32+2*e11*e20*e37-2*e11*e21*e36-2*e11*e26*e31+2*e11*e27*e30+2*e12*e20*e38-2*e12*e22*e36-2*e12*e26*e32+2*e12*e28*e30+2*e13*e23*e36+2*e13*e24*e37+2*e13*e25*e38+2*e13*e26*e33+2*e13*e27*e34+2*e13*e28*e35+2*e14*e23*e37-2*e14*e24*e36-2*e14*e26*e34+2*e14*e27*e33+2*e15*e23*e38-2*e15*e25*e36-2*e15*e26*e35+2*e15*e28*e33+2*e16*e20*e30-2*e16*e21*e31-2*e16*e22*e32+2*e16*e23*e33-2*e16*e24*e34-2*e16*e25*e35+6*e16*e26*e36+2*e16*e27*e37+2*e16*e28*e38+2*e17*e20*e31+2*e17*e21*e30+2*e17*e23*e34+2*e17*e24*e33+2*e17*e26*e37+2*e17*e27*e36+2*e18*e20*e32+2*e18*e22*e30+2*e18*e23*e35+2*e18*e25*e33+2*e18*e26*e38+2*e18*e28*e36;
  A(3,15)=2*e10*e30*e36+2*e10*e31*e37+2*e10*e32*e38+2*e11*e30*e37-2*e11*e31*e36+2*e12*e30*e38-2*e12*e32*e36+2*e13*e33*e36+2*e13*e34*e37+2*e13*e35*e38+2*e14*e33*e37-2*e14*e34*e36+2*e15*e33*e38-2*e15*e35*e36+e16*e302-e16*e312-e16*e322+e16*e332-e16*e342-e16*e352+3*e16*e362+e16*e372+e16*e382+2*e17*e30*e31+2*e17*e33*e34+2*e17*e36*e37+2*e18*e30*e32+2*e18*e33*e35+2*e18*e36*e38;
  A(3,16)=e202*e26+2*e20*e21*e27+2*e20*e22*e28-e212*e26-e222*e26+e232*e26+2*e23*e24*e27+2*e23*e25*e28-e242*e26-e252*e26+e263+e26*e272+e26*e282;
  A(3,17)=e202*e36+2*e20*e21*e37+2*e20*e22*e38+2*e20*e26*e30+2*e20*e27*e31+2*e20*e28*e32-e212*e36-2*e21*e26*e31+2*e21*e27*e30-e222*e36-2*e22*e26*e32+2*e22*e28*e30+e232*e36+2*e23*e24*e37+2*e23*e25*e38+2*e23*e26*e33+2*e23*e27*e34+2*e23*e28*e35-e242*e36-2*e24*e26*e34+2*e24*e27*e33-e252*e36-2*e25*e26*e35+2*e25*e28*e33+3*e262*e36+2*e26*e27*e37+2*e26*e28*e38+e272*e36+e282*e36;
  A(3,18)=2*e20*e30*e36+2*e20*e31*e37+2*e20*e32*e38+2*e21*e30*e37-2*e21*e31*e36+2*e22*e30*e38-2*e22*e32*e36+2*e23*e33*e36+2*e23*e34*e37+2*e23*e35*e38+2*e24*e33*e37-2*e24*e34*e36+2*e25*e33*e38-2*e25*e35*e36+e26*e302-e26*e312-e26*e322+e26*e332-e26*e342-e26*e352+3*e26*e362+e26*e372+e26*e382+2*e27*e30*e31+2*e27*e33*e34+2*e27*e36*e37+2*e28*e30*e32+2*e28*e33*e35+2*e28*e36*e38;
  A(3,19)=e302*e36+2*e30*e31*e37+2*e30*e32*e38-e312*e36-e322*e36+e332*e36+2*e33*e34*e37+2*e33*e35*e38-e342*e36-e352*e36+e363+e36*e372+e36*e382;
  A(4,0)=e002*e01+2*e00*e03*e04+2*e00*e06*e07+e013+e01*e022-e01*e032+e01*e042-e01*e052-e01*e062+e01*e072-e01*e082+2*e02*e04*e05+2*e02*e07*e08;
  A(4,1)=e102*e11+2*e10*e13*e14+2*e10*e16*e17+e113+e11*e122-e11*e132+e11*e142-e11*e152-e11*e162+e11*e172-e11*e182+2*e12*e14*e15+2*e12*e17*e18;
  A(4,2)=e002*e11+2*e00*e01*e10+2*e00*e03*e14+2*e00*e04*e13+2*e00*e06*e17+2*e00*e07*e16+3*e012*e11+2*e01*e02*e12-2*e01*e03*e13+2*e01*e04*e14-2*e01*e05*e15-2*e01*e06*e16+2*e01*e07*e17-2*e01*e08*e18+e022*e11+2*e02*e04*e15+2*e02*e05*e14+2*e02*e07*e18+2*e02*e08*e17-e032*e11+2*e03*e04*e10+e042*e11+2*e04*e05*e12-e052*e11-e062*e11+2*e06*e07*e10+e072*e11+2*e07*e08*e12-e082*e11;
  A(4,3)=2*e00*e10*e11+2*e00*e13*e14+2*e00*e16*e17+e01*e102+3*e01*e112+e01*e122-e01*e132+e01*e142-e01*e152-e01*e162+e01*e172-e01*e182+2*e02*e11*e12+2*e02*e14*e15+2*e02*e17*e18+2*e03*e10*e14-2*e03*e11*e13+2*e04*e10*e13+2*e04*e11*e14+2*e04*e12*e15-2*e05*e11*e15+2*e05*e12*e14+2*e06*e10*e17-2*e06*e11*e16+2*e07*e10*e16+2*e07*e11*e17+2*e07*e12*e18-2*e08*e11*e18+2*e08*e12*e17;
  A(4,4)=e002*e21+2*e00*e01*e20+2*e00*e03*e24+2*e00*e04*e23+2*e00*e06*e27+2*e00*e07*e26+3*e012*e21+2*e01*e02*e22-2*e01*e03*e23+2*e01*e04*e24-2*e01*e05*e25-2*e01*e06*e26+2*e01*e07*e27-2*e01*e08*e28+e022*e21+2*e02*e04*e25+2*e02*e05*e24+2*e02*e07*e28+2*e02*e08*e27-e032*e21+2*e03*e04*e20+e042*e21+2*e04*e05*e22-e052*e21-e062*e21+2*e06*e07*e20+e072*e21+2*e07*e08*e22-e082*e21;
  A(4,5)=e002*e31+2*e00*e01*e30+2*e00*e03*e34+2*e00*e04*e33+2*e00*e06*e37+2*e00*e07*e36+3*e012*e31+2*e01*e02*e32-2*e01*e03*e33+2*e01*e04*e34-2*e01*e05*e35-2*e01*e06*e36+2*e01*e07*e37-2*e01*e08*e38+e022*e31+2*e02*e04*e35+2*e02*e05*e34+2*e02*e07*e38+2*e02*e08*e37-e032*e31+2*e03*e04*e30+e042*e31+2*e04*e05*e32-e052*e31-e062*e31+2*e06*e07*e30+e072*e31+2*e07*e08*e32-e082*e31;
  A(4,6)=e102*e21+2*e10*e11*e20+2*e10*e13*e24+2*e10*e14*e23+2*e10*e16*e27+2*e10*e17*e26+3*e112*e21+2*e11*e12*e22-2*e11*e13*e23+2*e11*e14*e24-2*e11*e15*e25-2*e11*e16*e26+2*e11*e17*e27-2*e11*e18*e28+e122*e21+2*e12*e14*e25+2*e12*e15*e24+2*e12*e17*e28+2*e12*e18*e27-e132*e21+2*e13*e14*e20+e142*e21+2*e14*e15*e22-e152*e21-e162*e21+2*e16*e17*e20+e172*e21+2*e17*e18*e22-e182*e21;
  A(4,7)=e102*e31+2*e10*e11*e30+2*e10*e13*e34+2*e10*e14*e33+2*e10*e16*e37+2*e10*e17*e36+3*e112*e31+2*e11*e12*e32-2*e11*e13*e33+2*e11*e14*e34-2*e11*e15*e35-2*e11*e16*e36+2*e11*e17*e37-2*e11*e18*e38+e122*e31+2*e12*e14*e35+2*e12*e15*e34+2*e12*e17*e38+2*e12*e18*e37-e132*e31+2*e13*e14*e30+e142*e31+2*e14*e15*e32-e152*e31-e162*e31+2*e16*e17*e30+e172*e31+2*e17*e18*e32-e182*e31;
  A(4,8)=2*e00*e10*e21+2*e00*e11*e20+2*e00*e13*e24+2*e00*e14*e23+2*e00*e16*e27+2*e00*e17*e26+2*e01*e10*e20+6*e01*e11*e21+2*e01*e12*e22-2*e01*e13*e23+2*e01*e14*e24-2*e01*e15*e25-2*e01*e16*e26+2*e01*e17*e27-2*e01*e18*e28+2*e02*e11*e22+2*e02*e12*e21+2*e02*e14*e25+2*e02*e15*e24+2*e02*e17*e28+2*e02*e18*e27+2*e03*e10*e24-2*e03*e11*e23-2*e03*e13*e21+2*e03*e14*e20+2*e04*e10*e23+2*e04*e11*e24+2*e04*e12*e25+2*e04*e13*e20+2*e04*e14*e21+2*e04*e15*e22-2*e05*e11*e25+2*e05*e12*e24+2*e05*e14*e22-2*e05*e15*e21+2*e06*e10*e27-2*e06*e11*e26-2*e06*e16*e21+2*e06*e17*e20+2*e07*e10*e26+2*e07*e11*e27+2*e07*e12*e28+2*e07*e16*e20+2*e07*e17*e21+2*e07*e18*e22-2*e08*e11*e28+2*e08*e12*e27+2*e08*e17*e22-2*e08*e18*e21;
  A(4,9)=2*e00*e10*e31+2*e00*e11*e30+2*e00*e13*e34+2*e00*e14*e33+2*e00*e16*e37+2*e00*e17*e36+2*e01*e10*e30+6*e01*e11*e31+2*e01*e12*e32-2*e01*e13*e33+2*e01*e14*e34-2*e01*e15*e35-2*e01*e16*e36+2*e01*e17*e37-2*e01*e18*e38+2*e02*e11*e32+2*e02*e12*e31+2*e02*e14*e35+2*e02*e15*e34+2*e02*e17*e38+2*e02*e18*e37+2*e03*e10*e34-2*e03*e11*e33-2*e03*e13*e31+2*e03*e14*e30+2*e04*e10*e33+2*e04*e11*e34+2*e04*e12*e35+2*e04*e13*e30+2*e04*e14*e31+2*e04*e15*e32-2*e05*e11*e35+2*e05*e12*e34+2*e05*e14*e32-2*e05*e15*e31+2*e06*e10*e37-2*e06*e11*e36-2*e06*e16*e31+2*e06*e17*e30+2*e07*e10*e36+2*e07*e11*e37+2*e07*e12*e38+2*e07*e16*e30+2*e07*e17*e31+2*e07*e18*e32-2*e08*e11*e38+2*e08*e12*e37+2*e08*e17*e32-2*e08*e18*e31;
  A(4,10)=2*e00*e20*e21+2*e00*e23*e24+2*e00*e26*e27+e01*e202+3*e01*e212+e01*e222-e01*e232+e01*e242-e01*e252-e01*e262+e01*e272-e01*e282+2*e02*e21*e22+2*e02*e24*e25+2*e02*e27*e28+2*e03*e20*e24-2*e03*e21*e23+2*e04*e20*e23+2*e04*e21*e24+2*e04*e22*e25-2*e05*e21*e25+2*e05*e22*e24+2*e06*e20*e27-2*e06*e21*e26+2*e07*e20*e26+2*e07*e21*e27+2*e07*e22*e28-2*e08*e21*e28+2*e08*e22*e27;
  A(4,11)=2*e00*e20*e31+2*e00*e21*e30+2*e00*e23*e34+2*e00*e24*e33+2*e00*e26*e37+2*e00*e27*e36+2*e01*e20*e30+6*e01*e21*e31+2*e01*e22*e32-2*e01*e23*e33+2*e01*e24*e34-2*e01*e25*e35-2*e01*e26*e36+2*e01*e27*e37-2*e01*e28*e38+2*e02*e21*e32+2*e02*e22*e31+2*e02*e24*e35+2*e02*e25*e34+2*e02*e27*e38+2*e02*e28*e37+2*e03*e20*e34-2*e03*e21*e33-2*e03*e23*e31+2*e03*e24*e30+2*e04*e20*e33+2*e04*e21*e34+2*e04*e22*e35+2*e04*e23*e30+2*e04*e24*e31+2*e04*e25*e32-2*e05*e21*e35+2*e05*e22*e34+2*e05*e24*e32-2*e05*e25*e31+2*e06*e20*e37-2*e06*e21*e36-2*e06*e26*e31+2*e06*e27*e30+2*e07*e20*e36+2*e07*e21*e37+2*e07*e22*e38+2*e07*e26*e30+2*e07*e27*e31+2*e07*e28*e32-2*e08*e21*e38+2*e08*e22*e37+2*e08*e27*e32-2*e08*e28*e31;
  A(4,12)=2*e00*e30*e31+2*e00*e33*e34+2*e00*e36*e37+e01*e302+3*e01*e312+e01*e322-e01*e332+e01*e342-e01*e352-e01*e362+e01*e372-e01*e382+2*e02*e31*e32+2*e02*e34*e35+2*e02*e37*e38+2*e03*e30*e34-2*e03*e31*e33+2*e04*e30*e33+2*e04*e31*e34+2*e04*e32*e35-2*e05*e31*e35+2*e05*e32*e34+2*e06*e30*e37-2*e06*e31*e36+2*e07*e30*e36+2*e07*e31*e37+2*e07*e32*e38-2*e08*e31*e38+2*e08*e32*e37;
  A(4,13)=2*e10*e20*e21+2*e10*e23*e24+2*e10*e26*e27+e11*e202+3*e11*e212+e11*e222-e11*e232+e11*e242-e11*e252-e11*e262+e11*e272-e11*e282+2*e12*e21*e22+2*e12*e24*e25+2*e12*e27*e28+2*e13*e20*e24-2*e13*e21*e23+2*e14*e20*e23+2*e14*e21*e24+2*e14*e22*e25-2*e15*e21*e25+2*e15*e22*e24+2*e16*e20*e27-2*e16*e21*e26+2*e17*e20*e26+2*e17*e21*e27+2*e17*e22*e28-2*e18*e21*e28+2*e18*e22*e27;
  A(4,14)=2*e10*e20*e31+2*e10*e21*e30+2*e10*e23*e34+2*e10*e24*e33+2*e10*e26*e37+2*e10*e27*e36+2*e11*e20*e30+6*e11*e21*e31+2*e11*e22*e32-2*e11*e23*e33+2*e11*e24*e34-2*e11*e25*e35-2*e11*e26*e36+2*e11*e27*e37-2*e11*e28*e38+2*e12*e21*e32+2*e12*e22*e31+2*e12*e24*e35+2*e12*e25*e34+2*e12*e27*e38+2*e12*e28*e37+2*e13*e20*e34-2*e13*e21*e33-2*e13*e23*e31+2*e13*e24*e30+2*e14*e20*e33+2*e14*e21*e34+2*e14*e22*e35+2*e14*e23*e30+2*e14*e24*e31+2*e14*e25*e32-2*e15*e21*e35+2*e15*e22*e34+2*e15*e24*e32-2*e15*e25*e31+2*e16*e20*e37-2*e16*e21*e36-2*e16*e26*e31+2*e16*e27*e30+2*e17*e20*e36+2*e17*e21*e37+2*e17*e22*e38+2*e17*e26*e30+2*e17*e27*e31+2*e17*e28*e32-2*e18*e21*e38+2*e18*e22*e37+2*e18*e27*e32-2*e18*e28*e31;
  A(4,15)=2*e10*e30*e31+2*e10*e33*e34+2*e10*e36*e37+e11*e302+3*e11*e312+e11*e322-e11*e332+e11*e342-e11*e352-e11*e362+e11*e372-e11*e382+2*e12*e31*e32+2*e12*e34*e35+2*e12*e37*e38+2*e13*e30*e34-2*e13*e31*e33+2*e14*e30*e33+2*e14*e31*e34+2*e14*e32*e35-2*e15*e31*e35+2*e15*e32*e34+2*e16*e30*e37-2*e16*e31*e36+2*e17*e30*e36+2*e17*e31*e37+2*e17*e32*e38-2*e18*e31*e38+2*e18*e32*e37;
  A(4,16)=e202*e21+2*e20*e23*e24+2*e20*e26*e27+e213+e21*e222-e21*e232+e21*e242-e21*e252-e21*e262+e21*e272-e21*e282+2*e22*e24*e25+2*e22*e27*e28;
  A(4,17)=e202*e31+2*e20*e21*e30+2*e20*e23*e34+2*e20*e24*e33+2*e20*e26*e37+2*e20*e27*e36+3*e212*e31+2*e21*e22*e32-2*e21*e23*e33+2*e21*e24*e34-2*e21*e25*e35-2*e21*e26*e36+2*e21*e27*e37-2*e21*e28*e38+e222*e31+2*e22*e24*e35+2*e22*e25*e34+2*e22*e27*e38+2*e22*e28*e37-e232*e31+2*e23*e24*e30+e242*e31+2*e24*e25*e32-e252*e31-e262*e31+2*e26*e27*e30+e272*e31+2*e27*e28*e32-e282*e31;
  A(4,18)=2*e20*e30*e31+2*e20*e33*e34+2*e20*e36*e37+e21*e302+3*e21*e312+e21*e322-e21*e332+e21*e342-e21*e352-e21*e362+e21*e372-e21*e382+2*e22*e31*e32+2*e22*e34*e35+2*e22*e37*e38+2*e23*e30*e34-2*e23*e31*e33+2*e24*e30*e33+2*e24*e31*e34+2*e24*e32*e35-2*e25*e31*e35+2*e25*e32*e34+2*e26*e30*e37-2*e26*e31*e36+2*e27*e30*e36+2*e27*e31*e37+2*e27*e32*e38-2*e28*e31*e38+2*e28*e32*e37;
  A(4,19)=e302*e31+2*e30*e33*e34+2*e30*e36*e37+e313+e31*e322-e31*e332+e31*e342-e31*e352-e31*e362+e31*e372-e31*e382+2*e32*e34*e35+2*e32*e37*e38;
  A(5,0)=-e002*e04+2*e00*e01*e03+e012*e04+2*e01*e02*e05-e022*e04+e032*e04+2*e03*e06*e07+e043+e04*e052-e04*e062+e04*e072-e04*e082+2*e05*e07*e08;
  A(5,1)=-e102*e14+2*e10*e11*e13+e112*e14+2*e11*e12*e15-e122*e14+e132*e14+2*e13*e16*e17+e143+e14*e152-e14*e162+e14*e172-e14*e182+2*e15*e17*e18;
  A(5,2)=-e002*e14+2*e00*e01*e13+2*e00*e03*e11-2*e00*e04*e10+e012*e14+2*e01*e02*e15+2*e01*e03*e10+2*e01*e04*e11+2*e01*e05*e12-e022*e14-2*e02*e04*e12+2*e02*e05*e11+e032*e14+2*e03*e04*e13+2*e03*e06*e17+2*e03*e07*e16+3*e042*e14+2*e04*e05*e15-2*e04*e06*e16+2*e04*e07*e17-2*e04*e08*e18+e052*e14+2*e05*e07*e18+2*e05*e08*e17-e062*e14+2*e06*e07*e13+e072*e14+2*e07*e08*e15-e082*e14;
  A(5,3)=-2*e00*e10*e14+2*e00*e11*e13+2*e01*e10*e13+2*e01*e11*e14+2*e01*e12*e15+2*e02*e11*e15-2*e02*e12*e14+2*e03*e10*e11+2*e03*e13*e14+2*e03*e16*e17-e04*e102+e04*e112-e04*e122+e04*e132+3*e04*e142+e04*e152-e04*e162+e04*e172-e04*e182+2*e05*e11*e12+2*e05*e14*e15+2*e05*e17*e18+2*e06*e13*e17-2*e06*e14*e16+2*e07*e13*e16+2*e07*e14*e17+2*e07*e15*e18-2*e08*e14*e18+2*e08*e15*e17;
  A(5,4)=-e002*e24+2*e00*e01*e23+2*e00*e03*e21-2*e00*e04*e20+e012*e24+2*e01*e02*e25+2*e01*e03*e20+2*e01*e04*e21+2*e01*e05*e22-e022*e24-2*e02*e04*e22+2*e02*e05*e21+e032*e24+2*e03*e04*e23+2*e03*e06*e27+2*e03*e07*e26+3*e042*e24+2*e04*e05*e25-2*e04*e06*e26+2*e04*e07*e27-2*e04*e08*e28+e052*e24+2*e05*e07*e28+2*e05*e08*e27-e062*e24+2*e06*e07*e23+e072*e24+2*e07*e08*e25-e082*e24;
  A(5,5)=-e002*e34+2*e00*e01*e33+2*e00*e03*e31-2*e00*e04*e30+e012*e34+2*e01*e02*e35+2*e01*e03*e30+2*e01*e04*e31+2*e01*e05*e32-e022*e34-2*e02*e04*e32+2*e02*e05*e31+e032*e34+2*e03*e04*e33+2*e03*e06*e37+2*e03*e07*e36+3*e042*e34+2*e04*e05*e35-2*e04*e06*e36+2*e04*e07*e37-2*e04*e08*e38+e052*e34+2*e05*e07*e38+2*e05*e08*e37-e062*e34+2*e06*e07*e33+e072*e34+2*e07*e08*e35-e082*e34;
  A(5,6)=-e102*e24+2*e10*e11*e23+2*e10*e13*e21-2*e10*e14*e20+e112*e24+2*e11*e12*e25+2*e11*e13*e20+2*e11*e14*e21+2*e11*e15*e22-e122*e24-2*e12*e14*e22+2*e12*e15*e21+e132*e24+2*e13*e14*e23+2*e13*e16*e27+2*e13*e17*e26+3*e142*e24+2*e14*e15*e25-2*e14*e16*e26+2*e14*e17*e27-2*e14*e18*e28+e152*e24+2*e15*e17*e28+2*e15*e18*e27-e162*e24+2*e16*e17*e23+e172*e24+2*e17*e18*e25-e182*e24;
  A(5,7)=-e102*e34+2*e10*e11*e33+2*e10*e13*e31-2*e10*e14*e30+e112*e34+2*e11*e12*e35+2*e11*e13*e30+2*e11*e14*e31+2*e11*e15*e32-e122*e34-2*e12*e14*e32+2*e12*e15*e31+e132*e34+2*e13*e14*e33+2*e13*e16*e37+2*e13*e17*e36+3*e142*e34+2*e14*e15*e35-2*e14*e16*e36+2*e14*e17*e37-2*e14*e18*e38+e152*e34+2*e15*e17*e38+2*e15*e18*e37-e162*e34+2*e16*e17*e33+e172*e34+2*e17*e18*e35-e182*e34;
  A(5,8)=-2*e00*e10*e24+2*e00*e11*e23+2*e00*e13*e21-2*e00*e14*e20+2*e01*e10*e23+2*e01*e11*e24+2*e01*e12*e25+2*e01*e13*e20+2*e01*e14*e21+2*e01*e15*e22+2*e02*e11*e25-2*e02*e12*e24-2*e02*e14*e22+2*e02*e15*e21+2*e03*e10*e21+2*e03*e11*e20+2*e03*e13*e24+2*e03*e14*e23+2*e03*e16*e27+2*e03*e17*e26-2*e04*e10*e20+2*e04*e11*e21-2*e04*e12*e22+2*e04*e13*e23+6*e04*e14*e24+2*e04*e15*e25-2*e04*e16*e26+2*e04*e17*e27-2*e04*e18*e28+2*e05*e11*e22+2*e05*e12*e21+2*e05*e14*e25+2*e05*e15*e24+2*e05*e17*e28+2*e05*e18*e27+2*e06*e13*e27-2*e06*e14*e26-2*e06*e16*e24+2*e06*e17*e23+2*e07*e13*e26+2*e07*e14*e27+2*e07*e15*e28+2*e07*e16*e23+2*e07*e17*e24+2*e07*e18*e25-2*e08*e14*e28+2*e08*e15*e27+2*e08*e17*e25-2*e08*e18*e24;
  A(5,9)=-2*e00*e10*e34+2*e00*e11*e33+2*e00*e13*e31-2*e00*e14*e30+2*e01*e10*e33+2*e01*e11*e34+2*e01*e12*e35+2*e01*e13*e30+2*e01*e14*e31+2*e01*e15*e32+2*e02*e11*e35-2*e02*e12*e34-2*e02*e14*e32+2*e02*e15*e31+2*e03*e10*e31+2*e03*e11*e30+2*e03*e13*e34+2*e03*e14*e33+2*e03*e16*e37+2*e03*e17*e36-2*e04*e10*e30+2*e04*e11*e31-2*e04*e12*e32+2*e04*e13*e33+6*e04*e14*e34+2*e04*e15*e35-2*e04*e16*e36+2*e04*e17*e37-2*e04*e18*e38+2*e05*e11*e32+2*e05*e12*e31+2*e05*e14*e35+2*e05*e15*e34+2*e05*e17*e38+2*e05*e18*e37+2*e06*e13*e37-2*e06*e14*e36-2*e06*e16*e34+2*e06*e17*e33+2*e07*e13*e36+2*e07*e14*e37+2*e07*e15*e38+2*e07*e16*e33+2*e07*e17*e34+2*e07*e18*e35-2*e08*e14*e38+2*e08*e15*e37+2*e08*e17*e35-2*e08*e18*e34;
  A(5,10)=-2*e00*e20*e24+2*e00*e21*e23+2*e01*e20*e23+2*e01*e21*e24+2*e01*e22*e25+2*e02*e21*e25-2*e02*e22*e24+2*e03*e20*e21+2*e03*e23*e24+2*e03*e26*e27-e04*e202+e04*e212-e04*e222+e04*e232+3*e04*e242+e04*e252-e04*e262+e04*e272-e04*e282+2*e05*e21*e22+2*e05*e24*e25+2*e05*e27*e28+2*e06*e23*e27-2*e06*e24*e26+2*e07*e23*e26+2*e07*e24*e27+2*e07*e25*e28-2*e08*e24*e28+2*e08*e25*e27;
  A(5,11)=-2*e00*e20*e34+2*e00*e21*e33+2*e00*e23*e31-2*e00*e24*e30+2*e01*e20*e33+2*e01*e21*e34+2*e01*e22*e35+2*e01*e23*e30+2*e01*e24*e31+2*e01*e25*e32+2*e02*e21*e35-2*e02*e22*e34-2*e02*e24*e32+2*e02*e25*e31+2*e03*e20*e31+2*e03*e21*e30+2*e03*e23*e34+2*e03*e24*e33+2*e03*e26*e37+2*e03*e27*e36-2*e04*e20*e30+2*e04*e21*e31-2*e04*e22*e32+2*e04*e23*e33+6*e04*e24*e34+2*e04*e25*e35-2*e04*e26*e36+2*e04*e27*e37-2*e04*e28*e38+2*e05*e21*e32+2*e05*e22*e31+2*e05*e24*e35+2*e05*e25*e34+2*e05*e27*e38+2*e05*e28*e37+2*e06*e23*e37-2*e06*e24*e36-2*e06*e26*e34+2*e06*e27*e33+2*e07*e23*e36+2*e07*e24*e37+2*e07*e25*e38+2*e07*e26*e33+2*e07*e27*e34+2*e07*e28*e35-2*e08*e24*e38+2*e08*e25*e37+2*e08*e27*e35-2*e08*e28*e34;
  A(5,12)=-2*e00*e30*e34+2*e00*e31*e33+2*e01*e30*e33+2*e01*e31*e34+2*e01*e32*e35+2*e02*e31*e35-2*e02*e32*e34+2*e03*e30*e31+2*e03*e33*e34+2*e03*e36*e37-e04*e302+e04*e312-e04*e322+e04*e332+3*e04*e342+e04*e352-e04*e362+e04*e372-e04*e382+2*e05*e31*e32+2*e05*e34*e35+2*e05*e37*e38+2*e06*e33*e37-2*e06*e34*e36+2*e07*e33*e36+2*e07*e34*e37+2*e07*e35*e38-2*e08*e34*e38+2*e08*e35*e37;
  A(5,13)=-2*e10*e20*e24+2*e10*e21*e23+2*e11*e20*e23+2*e11*e21*e24+2*e11*e22*e25+2*e12*e21*e25-2*e12*e22*e24+2*e13*e20*e21+2*e13*e23*e24+2*e13*e26*e27-e14*e202+e14*e212-e14*e222+e14*e232+3*e14*e242+e14*e252-e14*e262+e14*e272-e14*e282+2*e15*e21*e22+2*e15*e24*e25+2*e15*e27*e28+2*e16*e23*e27-2*e16*e24*e26+2*e17*e23*e26+2*e17*e24*e27+2*e17*e25*e28-2*e18*e24*e28+2*e18*e25*e27;
  A(5,14)=-2*e10*e20*e34+2*e10*e21*e33+2*e10*e23*e31-2*e10*e24*e30+2*e11*e20*e33+2*e11*e21*e34+2*e11*e22*e35+2*e11*e23*e30+2*e11*e24*e31+2*e11*e25*e32+2*e12*e21*e35-2*e12*e22*e34-2*e12*e24*e32+2*e12*e25*e31+2*e13*e20*e31+2*e13*e21*e30+2*e13*e23*e34+2*e13*e24*e33+2*e13*e26*e37+2*e13*e27*e36-2*e14*e20*e30+2*e14*e21*e31-2*e14*e22*e32+2*e14*e23*e33+6*e14*e24*e34+2*e14*e25*e35-2*e14*e26*e36+2*e14*e27*e37-2*e14*e28*e38+2*e15*e21*e32+2*e15*e22*e31+2*e15*e24*e35+2*e15*e25*e34+2*e15*e27*e38+2*e15*e28*e37+2*e16*e23*e37-2*e16*e24*e36-2*e16*e26*e34+2*e16*e27*e33+2*e17*e23*e36+2*e17*e24*e37+2*e17*e25*e38+2*e17*e26*e33+2*e17*e27*e34+2*e17*e28*e35-2*e18*e24*e38+2*e18*e25*e37+2*e18*e27*e35-2*e18*e28*e34;
  A(5,15)=-2*e10*e30*e34+2*e10*e31*e33+2*e11*e30*e33+2*e11*e31*e34+2*e11*e32*e35+2*e12*e31*e35-2*e12*e32*e34+2*e13*e30*e31+2*e13*e33*e34+2*e13*e36*e37-e14*e302+e14*e312-e14*e322+e14*e332+3*e14*e342+e14*e352-e14*e362+e14*e372-e14*e382+2*e15*e31*e32+2*e15*e34*e35+2*e15*e37*e38+2*e16*e33*e37-2*e16*e34*e36+2*e17*e33*e36+2*e17*e34*e37+2*e17*e35*e38-2*e18*e34*e38+2*e18*e35*e37;
  A(5,16)=-e202*e24+2*e20*e21*e23+e212*e24+2*e21*e22*e25-e222*e24+e232*e24+2*e23*e26*e27+e243+e24*e252-e24*e262+e24*e272-e24*e282+2*e25*e27*e28;
  A(5,17)=-e202*e34+2*e20*e21*e33+2*e20*e23*e31-2*e20*e24*e30+e212*e34+2*e21*e22*e35+2*e21*e23*e30+2*e21*e24*e31+2*e21*e25*e32-e222*e34-2*e22*e24*e32+2*e22*e25*e31+e232*e34+2*e23*e24*e33+2*e23*e26*e37+2*e23*e27*e36+3*e242*e34+2*e24*e25*e35-2*e24*e26*e36+2*e24*e27*e37-2*e24*e28*e38+e252*e34+2*e25*e27*e38+2*e25*e28*e37-e262*e34+2*e26*e27*e33+e272*e34+2*e27*e28*e35-e282*e34;
  A(5,18)=-2*e20*e30*e34+2*e20*e31*e33+2*e21*e30*e33+2*e21*e31*e34+2*e21*e32*e35+2*e22*e31*e35-2*e22*e32*e34+2*e23*e30*e31+2*e23*e33*e34+2*e23*e36*e37-e24*e302+e24*e312-e24*e322+e24*e332+3*e24*e342+e24*e352-e24*e362+e24*e372-e24*e382+2*e25*e31*e32+2*e25*e34*e35+2*e25*e37*e38+2*e26*e33*e37-2*e26*e34*e36+2*e27*e33*e36+2*e27*e34*e37+2*e27*e35*e38-2*e28*e34*e38+2*e28*e35*e37;
  A(5,19)=-e302*e34+2*e30*e31*e33+e312*e34+2*e31*e32*e35-e322*e34+e332*e34+2*e33*e36*e37+e343+e34*e352-e34*e362+e34*e372-e34*e382+2*e35*e37*e38;
  A(6,0)=-e002*e07+2*e00*e01*e06+e012*e07+2*e01*e02*e08-e022*e07-e032*e07+2*e03*e04*e06+e042*e07+2*e04*e05*e08-e052*e07+e062*e07+e073+e07*e082;
  A(6,1)=-e102*e17+2*e10*e11*e16+e112*e17+2*e11*e12*e18-e122*e17-e132*e17+2*e13*e14*e16+e142*e17+2*e14*e15*e18-e152*e17+e162*e17+e173+e17*e182;
  A(6,2)=-e002*e17+2*e00*e01*e16+2*e00*e06*e11-2*e00*e07*e10+e012*e17+2*e01*e02*e18+2*e01*e06*e10+2*e01*e07*e11+2*e01*e08*e12-e022*e17-2*e02*e07*e12+2*e02*e08*e11-e032*e17+2*e03*e04*e16+2*e03*e06*e14-2*e03*e07*e13+e042*e17+2*e04*e05*e18+2*e04*e06*e13+2*e04*e07*e14+2*e04*e08*e15-e052*e17-2*e05*e07*e15+2*e05*e08*e14+e062*e17+2*e06*e07*e16+3*e072*e17+2*e07*e08*e18+e082*e17;
  A(6,3)=-2*e00*e10*e17+2*e00*e11*e16+2*e01*e10*e16+2*e01*e11*e17+2*e01*e12*e18+2*e02*e11*e18-2*e02*e12*e17-2*e03*e13*e17+2*e03*e14*e16+2*e04*e13*e16+2*e04*e14*e17+2*e04*e15*e18+2*e05*e14*e18-2*e05*e15*e17+2*e06*e10*e11+2*e06*e13*e14+2*e06*e16*e17-e07*e102+e07*e112-e07*e122-e07*e132+e07*e142-e07*e152+e07*e162+3*e07*e172+e07*e182+2*e08*e11*e12+2*e08*e14*e15+2*e08*e17*e18;
  A(6,4)=-e002*e27+2*e00*e01*e26+2*e00*e06*e21-2*e00*e07*e20+e012*e27+2*e01*e02*e28+2*e01*e06*e20+2*e01*e07*e21+2*e01*e08*e22-e022*e27-2*e02*e07*e22+2*e02*e08*e21-e032*e27+2*e03*e04*e26+2*e03*e06*e24-2*e03*e07*e23+e042*e27+2*e04*e05*e28+2*e04*e06*e23+2*e04*e07*e24+2*e04*e08*e25-e052*e27-2*e05*e07*e25+2*e05*e08*e24+e062*e27+2*e06*e07*e26+3*e072*e27+2*e07*e08*e28+e082*e27;
  A(6,5)=-e002*e37+2*e00*e01*e36+2*e00*e06*e31-2*e00*e07*e30+e012*e37+2*e01*e02*e38+2*e01*e06*e30+2*e01*e07*e31+2*e01*e08*e32-e022*e37-2*e02*e07*e32+2*e02*e08*e31-e032*e37+2*e03*e04*e36+2*e03*e06*e34-2*e03*e07*e33+e042*e37+2*e04*e05*e38+2*e04*e06*e33+2*e04*e07*e34+2*e04*e08*e35-e052*e37-2*e05*e07*e35+2*e05*e08*e34+e062*e37+2*e06*e07*e36+3*e072*e37+2*e07*e08*e38+e082*e37;
  A(6,6)=-e102*e27+2*e10*e11*e26+2*e10*e16*e21-2*e10*e17*e20+e112*e27+2*e11*e12*e28+2*e11*e16*e20+2*e11*e17*e21+2*e11*e18*e22-e122*e27-2*e12*e17*e22+2*e12*e18*e21-e132*e27+2*e13*e14*e26+2*e13*e16*e24-2*e13*e17*e23+e142*e27+2*e14*e15*e28+2*e14*e16*e23+2*e14*e17*e24+2*e14*e18*e25-e152*e27-2*e15*e17*e25+2*e15*e18*e24+e162*e27+2*e16*e17*e26+3*e172*e27+2*e17*e18*e28+e182*e27;
  A(6,7)=-e102*e37+2*e10*e11*e36+2*e10*e16*e31-2*e10*e17*e30+e112*e37+2*e11*e12*e38+2*e11*e16*e30+2*e11*e17*e31+2*e11*e18*e32-e122*e37-2*e12*e17*e32+2*e12*e18*e31-e132*e37+2*e13*e14*e36+2*e13*e16*e34-2*e13*e17*e33+e142*e37+2*e14*e15*e38+2*e14*e16*e33+2*e14*e17*e34+2*e14*e18*e35-e152*e37-2*e15*e17*e35+2*e15*e18*e34+e162*e37+2*e16*e17*e36+3*e172*e37+2*e17*e18*e38+e182*e37;
  A(6,8)=-2*e00*e10*e27+2*e00*e11*e26+2*e00*e16*e21-2*e00*e17*e20+2*e01*e10*e26+2*e01*e11*e27+2*e01*e12*e28+2*e01*e16*e20+2*e01*e17*e21+2*e01*e18*e22+2*e02*e11*e28-2*e02*e12*e27-2*e02*e17*e22+2*e02*e18*e21-2*e03*e13*e27+2*e03*e14*e26+2*e03*e16*e24-2*e03*e17*e23+2*e04*e13*e26+2*e04*e14*e27+2*e04*e15*e28+2*e04*e16*e23+2*e04*e17*e24+2*e04*e18*e25+2*e05*e14*e28-2*e05*e15*e27-2*e05*e17*e25+2*e05*e18*e24+2*e06*e10*e21+2*e06*e11*e20+2*e06*e13*e24+2*e06*e14*e23+2*e06*e16*e27+2*e06*e17*e26-2*e07*e10*e20+2*e07*e11*e21-2*e07*e12*e22-2*e07*e13*e23+2*e07*e14*e24-2*e07*e15*e25+2*e07*e16*e26+6*e07*e17*e27+2*e07*e18*e28+2*e08*e11*e22+2*e08*e12*e21+2*e08*e14*e25+2*e08*e15*e24+2*e08*e17*e28+2*e08*e18*e27;
  A(6,9)=-2*e00*e10*e37+2*e00*e11*e36+2*e00*e16*e31-2*e00*e17*e30+2*e01*e10*e36+2*e01*e11*e37+2*e01*e12*e38+2*e01*e16*e30+2*e01*e17*e31+2*e01*e18*e32+2*e02*e11*e38-2*e02*e12*e37-2*e02*e17*e32+2*e02*e18*e31-2*e03*e13*e37+2*e03*e14*e36+2*e03*e16*e34-2*e03*e17*e33+2*e04*e13*e36+2*e04*e14*e37+2*e04*e15*e38+2*e04*e16*e33+2*e04*e17*e34+2*e04*e18*e35+2*e05*e14*e38-2*e05*e15*e37-2*e05*e17*e35+2*e05*e18*e34+2*e06*e10*e31+2*e06*e11*e30+2*e06*e13*e34+2*e06*e14*e33+2*e06*e16*e37+2*e06*e17*e36-2*e07*e10*e30+2*e07*e11*e31-2*e07*e12*e32-2*e07*e13*e33+2*e07*e14*e34-2*e07*e15*e35+2*e07*e16*e36+6*e07*e17*e37+2*e07*e18*e38+2*e08*e11*e32+2*e08*e12*e31+2*e08*e14*e35+2*e08*e15*e34+2*e08*e17*e38+2*e08*e18*e37;
  A(6,10)=-2*e00*e20*e27+2*e00*e21*e26+2*e01*e20*e26+2*e01*e21*e27+2*e01*e22*e28+2*e02*e21*e28-2*e02*e22*e27-2*e03*e23*e27+2*e03*e24*e26+2*e04*e23*e26+2*e04*e24*e27+2*e04*e25*e28+2*e05*e24*e28-2*e05*e25*e27+2*e06*e20*e21+2*e06*e23*e24+2*e06*e26*e27-e07*e202+e07*e212-e07*e222-e07*e232+e07*e242-e07*e252+e07*e262+3*e07*e272+e07*e282+2*e08*e21*e22+2*e08*e24*e25+2*e08*e27*e28;
  A(6,11)=-2*e00*e20*e37+2*e00*e21*e36+2*e00*e26*e31-2*e00*e27*e30+2*e01*e20*e36+2*e01*e21*e37+2*e01*e22*e38+2*e01*e26*e30+2*e01*e27*e31+2*e01*e28*e32+2*e02*e21*e38-2*e02*e22*e37-2*e02*e27*e32+2*e02*e28*e31-2*e03*e23*e37+2*e03*e24*e36+2*e03*e26*e34-2*e03*e27*e33+2*e04*e23*e36+2*e04*e24*e37+2*e04*e25*e38+2*e04*e26*e33+2*e04*e27*e34+2*e04*e28*e35+2*e05*e24*e38-2*e05*e25*e37-2*e05*e27*e35+2*e05*e28*e34+2*e06*e20*e31+2*e06*e21*e30+2*e06*e23*e34+2*e06*e24*e33+2*e06*e26*e37+2*e06*e27*e36-2*e07*e20*e30+2*e07*e21*e31-2*e07*e22*e32-2*e07*e23*e33+2*e07*e24*e34-2*e07*e25*e35+2*e07*e26*e36+6*e07*e27*e37+2*e07*e28*e38+2*e08*e21*e32+2*e08*e22*e31+2*e08*e24*e35+2*e08*e25*e34+2*e08*e27*e38+2*e08*e28*e37;
  A(6,12)=-2*e00*e30*e37+2*e00*e31*e36+2*e01*e30*e36+2*e01*e31*e37+2*e01*e32*e38+2*e02*e31*e38-2*e02*e32*e37-2*e03*e33*e37+2*e03*e34*e36+2*e04*e33*e36+2*e04*e34*e37+2*e04*e35*e38+2*e05*e34*e38-2*e05*e35*e37+2*e06*e30*e31+2*e06*e33*e34+2*e06*e36*e37-e07*e302+e07*e312-e07*e322-e07*e332+e07*e342-e07*e352+e07*e362+3*e07*e372+e07*e382+2*e08*e31*e32+2*e08*e34*e35+2*e08*e37*e38;
  A(6,13)=-2*e10*e20*e27+2*e10*e21*e26+2*e11*e20*e26+2*e11*e21*e27+2*e11*e22*e28+2*e12*e21*e28-2*e12*e22*e27-2*e13*e23*e27+2*e13*e24*e26+2*e14*e23*e26+2*e14*e24*e27+2*e14*e25*e28+2*e15*e24*e28-2*e15*e25*e27+2*e16*e20*e21+2*e16*e23*e24+2*e16*e26*e27-e17*e202+e17*e212-e17*e222-e17*e232+e17*e242-e17*e252+e17*e262+3*e17*e272+e17*e282+2*e18*e21*e22+2*e18*e24*e25+2*e18*e27*e28;
  A(6,14)=-2*e10*e20*e37+2*e10*e21*e36+2*e10*e26*e31-2*e10*e27*e30+2*e11*e20*e36+2*e11*e21*e37+2*e11*e22*e38+2*e11*e26*e30+2*e11*e27*e31+2*e11*e28*e32+2*e12*e21*e38-2*e12*e22*e37-2*e12*e27*e32+2*e12*e28*e31-2*e13*e23*e37+2*e13*e24*e36+2*e13*e26*e34-2*e13*e27*e33+2*e14*e23*e36+2*e14*e24*e37+2*e14*e25*e38+2*e14*e26*e33+2*e14*e27*e34+2*e14*e28*e35+2*e15*e24*e38-2*e15*e25*e37-2*e15*e27*e35+2*e15*e28*e34+2*e16*e20*e31+2*e16*e21*e30+2*e16*e23*e34+2*e16*e24*e33+2*e16*e26*e37+2*e16*e27*e36-2*e17*e20*e30+2*e17*e21*e31-2*e17*e22*e32-2*e17*e23*e33+2*e17*e24*e34-2*e17*e25*e35+2*e17*e26*e36+6*e17*e27*e37+2*e17*e28*e38+2*e18*e21*e32+2*e18*e22*e31+2*e18*e24*e35+2*e18*e25*e34+2*e18*e27*e38+2*e18*e28*e37;
  A(6,15)=-2*e10*e30*e37+2*e10*e31*e36+2*e11*e30*e36+2*e11*e31*e37+2*e11*e32*e38+2*e12*e31*e38-2*e12*e32*e37-2*e13*e33*e37+2*e13*e34*e36+2*e14*e33*e36+2*e14*e34*e37+2*e14*e35*e38+2*e15*e34*e38-2*e15*e35*e37+2*e16*e30*e31+2*e16*e33*e34+2*e16*e36*e37-e17*e302+e17*e312-e17*e322-e17*e332+e17*e342-e17*e352+e17*e362+3*e17*e372+e17*e382+2*e18*e31*e32+2*e18*e34*e35+2*e18*e37*e38;
  A(6,16)=-e202*e27+2*e20*e21*e26+e212*e27+2*e21*e22*e28-e222*e27-e232*e27+2*e23*e24*e26+e242*e27+2*e24*e25*e28-e252*e27+e262*e27+e273+e27*e282;
  A(6,17)=-e202*e37+2*e20*e21*e36+2*e20*e26*e31-2*e20*e27*e30+e212*e37+2*e21*e22*e38+2*e21*e26*e30+2*e21*e27*e31+2*e21*e28*e32-e222*e37-2*e22*e27*e32+2*e22*e28*e31-e232*e37+2*e23*e24*e36+2*e23*e26*e34-2*e23*e27*e33+e242*e37+2*e24*e25*e38+2*e24*e26*e33+2*e24*e27*e34+2*e24*e28*e35-e252*e37-2*e25*e27*e35+2*e25*e28*e34+e262*e37+2*e26*e27*e36+3*e272*e37+2*e27*e28*e38+e282*e37;
  A(6,18)=-2*e20*e30*e37+2*e20*e31*e36+2*e21*e30*e36+2*e21*e31*e37+2*e21*e32*e38+2*e22*e31*e38-2*e22*e32*e37-2*e23*e33*e37+2*e23*e34*e36+2*e24*e33*e36+2*e24*e34*e37+2*e24*e35*e38+2*e25*e34*e38-2*e25*e35*e37+2*e26*e30*e31+2*e26*e33*e34+2*e26*e36*e37-e27*e302+e27*e312-e27*e322-e27*e332+e27*e342-e27*e352+e27*e362+3*e27*e372+e27*e382+2*e28*e31*e32+2*e28*e34*e35+2*e28*e37*e38;
  A(6,19)=-e302*e37+2*e30*e31*e36+e312*e37+2*e31*e32*e38-e322*e37-e332*e37+2*e33*e34*e36+e342*e37+2*e34*e35*e38-e352*e37+e362*e37+e373+e37*e382;
  A(7,0)=e002*e02+2*e00*e03*e05+2*e00*e06*e08+e012*e02+2*e01*e04*e05+2*e01*e07*e08+e023-e02*e032-e02*e042+e02*e052-e02*e062-e02*e072+e02*e082;
  A(7,1)=e102*e12+2*e10*e13*e15+2*e10*e16*e18+e112*e12+2*e11*e14*e15+2*e11*e17*e18+e123-e12*e132-e12*e142+e12*e152-e12*e162-e12*e172+e12*e182;
  A(7,2)=e002*e12+2*e00*e02*e10+2*e00*e03*e15+2*e00*e05*e13+2*e00*e06*e18+2*e00*e08*e16+e012*e12+2*e01*e02*e11+2*e01*e04*e15+2*e01*e05*e14+2*e01*e07*e18+2*e01*e08*e17+3*e022*e12-2*e02*e03*e13-2*e02*e04*e14+2*e02*e05*e15-2*e02*e06*e16-2*e02*e07*e17+2*e02*e08*e18-e032*e12+2*e03*e05*e10-e042*e12+2*e04*e05*e11+e052*e12-e062*e12+2*e06*e08*e10-e072*e12+2*e07*e08*e11+e082*e12;
  A(7,3)=2*e00*e10*e12+2*e00*e13*e15+2*e00*e16*e18+2*e01*e11*e12+2*e01*e14*e15+2*e01*e17*e18+e02*e102+e02*e112+3*e02*e122-e02*e132-e02*e142+e02*e152-e02*e162-e02*e172+e02*e182+2*e03*e10*e15-2*e03*e12*e13+2*e04*e11*e15-2*e04*e12*e14+2*e05*e10*e13+2*e05*e11*e14+2*e05*e12*e15+2*e06*e10*e18-2*e06*e12*e16+2*e07*e11*e18-2*e07*e12*e17+2*e08*e10*e16+2*e08*e11*e17+2*e08*e12*e18;
  A(7,4)=e002*e22+2*e00*e02*e20+2*e00*e03*e25+2*e00*e05*e23+2*e00*e06*e28+2*e00*e08*e26+e012*e22+2*e01*e02*e21+2*e01*e04*e25+2*e01*e05*e24+2*e01*e07*e28+2*e01*e08*e27+3*e022*e22-2*e02*e03*e23-2*e02*e04*e24+2*e02*e05*e25-2*e02*e06*e26-2*e02*e07*e27+2*e02*e08*e28-e032*e22+2*e03*e05*e20-e042*e22+2*e04*e05*e21+e052*e22-e062*e22+2*e06*e08*e20-e072*e22+2*e07*e08*e21+e082*e22;
  A(7,5)=e002*e32+2*e00*e02*e30+2*e00*e03*e35+2*e00*e05*e33+2*e00*e06*e38+2*e00*e08*e36+e012*e32+2*e01*e02*e31+2*e01*e04*e35+2*e01*e05*e34+2*e01*e07*e38+2*e01*e08*e37+3*e022*e32-2*e02*e03*e33-2*e02*e04*e34+2*e02*e05*e35-2*e02*e06*e36-2*e02*e07*e37+2*e02*e08*e38-e032*e32+2*e03*e05*e30-e042*e32+2*e04*e05*e31+e052*e32-e062*e32+2*e06*e08*e30-e072*e32+2*e07*e08*e31+e082*e32;
  A(7,6)=e102*e22+2*e10*e12*e20+2*e10*e13*e25+2*e10*e15*e23+2*e10*e16*e28+2*e10*e18*e26+e112*e22+2*e11*e12*e21+2*e11*e14*e25+2*e11*e15*e24+2*e11*e17*e28+2*e11*e18*e27+3*e122*e22-2*e12*e13*e23-2*e12*e14*e24+2*e12*e15*e25-2*e12*e16*e26-2*e12*e17*e27+2*e12*e18*e28-e132*e22+2*e13*e15*e20-e142*e22+2*e14*e15*e21+e152*e22-e162*e22+2*e16*e18*e20-e172*e22+2*e17*e18*e21+e182*e22;
  A(7,7)=e102*e32+2*e10*e12*e30+2*e10*e13*e35+2*e10*e15*e33+2*e10*e16*e38+2*e10*e18*e36+e112*e32+2*e11*e12*e31+2*e11*e14*e35+2*e11*e15*e34+2*e11*e17*e38+2*e11*e18*e37+3*e122*e32-2*e12*e13*e33-2*e12*e14*e34+2*e12*e15*e35-2*e12*e16*e36-2*e12*e17*e37+2*e12*e18*e38-e132*e32+2*e13*e15*e30-e142*e32+2*e14*e15*e31+e152*e32-e162*e32+2*e16*e18*e30-e172*e32+2*e17*e18*e31+e182*e32;
  A(7,8)=2*e00*e10*e22+2*e00*e12*e20+2*e00*e13*e25+2*e00*e15*e23+2*e00*e16*e28+2*e00*e18*e26+2*e01*e11*e22+2*e01*e12*e21+2*e01*e14*e25+2*e01*e15*e24+2*e01*e17*e28+2*e01*e18*e27+2*e02*e10*e20+2*e02*e11*e21+6*e02*e12*e22-2*e02*e13*e23-2*e02*e14*e24+2*e02*e15*e25-2*e02*e16*e26-2*e02*e17*e27+2*e02*e18*e28+2*e03*e10*e25-2*e03*e12*e23-2*e03*e13*e22+2*e03*e15*e20+2*e04*e11*e25-2*e04*e12*e24-2*e04*e14*e22+2*e04*e15*e21+2*e05*e10*e23+2*e05*e11*e24+2*e05*e12*e25+2*e05*e13*e20+2*e05*e14*e21+2*e05*e15*e22+2*e06*e10*e28-2*e06*e12*e26-2*e06*e16*e22+2*e06*e18*e20+2*e07*e11*e28-2*e07*e12*e27-2*e07*e17*e22+2*e07*e18*e21+2*e08*e10*e26+2*e08*e11*e27+2*e08*e12*e28+2*e08*e16*e20+2*e08*e17*e21+2*e08*e18*e22;
  A(7,9)=2*e00*e10*e32+2*e00*e12*e30+2*e00*e13*e35+2*e00*e15*e33+2*e00*e16*e38+2*e00*e18*e36+2*e01*e11*e32+2*e01*e12*e31+2*e01*e14*e35+2*e01*e15*e34+2*e01*e17*e38+2*e01*e18*e37+2*e02*e10*e30+2*e02*e11*e31+6*e02*e12*e32-2*e02*e13*e33-2*e02*e14*e34+2*e02*e15*e35-2*e02*e16*e36-2*e02*e17*e37+2*e02*e18*e38+2*e03*e10*e35-2*e03*e12*e33-2*e03*e13*e32+2*e03*e15*e30+2*e04*e11*e35-2*e04*e12*e34-2*e04*e14*e32+2*e04*e15*e31+2*e05*e10*e33+2*e05*e11*e34+2*e05*e12*e35+2*e05*e13*e30+2*e05*e14*e31+2*e05*e15*e32+2*e06*e10*e38-2*e06*e12*e36-2*e06*e16*e32+2*e06*e18*e30+2*e07*e11*e38-2*e07*e12*e37-2*e07*e17*e32+2*e07*e18*e31+2*e08*e10*e36+2*e08*e11*e37+2*e08*e12*e38+2*e08*e16*e30+2*e08*e17*e31+2*e08*e18*e32;
  A(7,10)=2*e00*e20*e22+2*e00*e23*e25+2*e00*e26*e28+2*e01*e21*e22+2*e01*e24*e25+2*e01*e27*e28+e02*e202+e02*e212+3*e02*e222-e02*e232-e02*e242+e02*e252-e02*e262-e02*e272+e02*e282+2*e03*e20*e25-2*e03*e22*e23+2*e04*e21*e25-2*e04*e22*e24+2*e05*e20*e23+2*e05*e21*e24+2*e05*e22*e25+2*e06*e20*e28-2*e06*e22*e26+2*e07*e21*e28-2*e07*e22*e27+2*e08*e20*e26+2*e08*e21*e27+2*e08*e22*e28;
  A(7,11)=2*e00*e20*e32+2*e00*e22*e30+2*e00*e23*e35+2*e00*e25*e33+2*e00*e26*e38+2*e00*e28*e36+2*e01*e21*e32+2*e01*e22*e31+2*e01*e24*e35+2*e01*e25*e34+2*e01*e27*e38+2*e01*e28*e37+2*e02*e20*e30+2*e02*e21*e31+6*e02*e22*e32-2*e02*e23*e33-2*e02*e24*e34+2*e02*e25*e35-2*e02*e26*e36-2*e02*e27*e37+2*e02*e28*e38+2*e03*e20*e35-2*e03*e22*e33-2*e03*e23*e32+2*e03*e25*e30+2*e04*e21*e35-2*e04*e22*e34-2*e04*e24*e32+2*e04*e25*e31+2*e05*e20*e33+2*e05*e21*e34+2*e05*e22*e35+2*e05*e23*e30+2*e05*e24*e31+2*e05*e25*e32+2*e06*e20*e38-2*e06*e22*e36-2*e06*e26*e32+2*e06*e28*e30+2*e07*e21*e38-2*e07*e22*e37-2*e07*e27*e32+2*e07*e28*e31+2*e08*e20*e36+2*e08*e21*e37+2*e08*e22*e38+2*e08*e26*e30+2*e08*e27*e31+2*e08*e28*e32;
  A(7,12)=2*e00*e30*e32+2*e00*e33*e35+2*e00*e36*e38+2*e01*e31*e32+2*e01*e34*e35+2*e01*e37*e38+e02*e302+e02*e312+3*e02*e322-e02*e332-e02*e342+e02*e352-e02*e362-e02*e372+e02*e382+2*e03*e30*e35-2*e03*e32*e33+2*e04*e31*e35-2*e04*e32*e34+2*e05*e30*e33+2*e05*e31*e34+2*e05*e32*e35+2*e06*e30*e38-2*e06*e32*e36+2*e07*e31*e38-2*e07*e32*e37+2*e08*e30*e36+2*e08*e31*e37+2*e08*e32*e38;
  A(7,13)=2*e10*e20*e22+2*e10*e23*e25+2*e10*e26*e28+2*e11*e21*e22+2*e11*e24*e25+2*e11*e27*e28+e12*e202+e12*e212+3*e12*e222-e12*e232-e12*e242+e12*e252-e12*e262-e12*e272+e12*e282+2*e13*e20*e25-2*e13*e22*e23+2*e14*e21*e25-2*e14*e22*e24+2*e15*e20*e23+2*e15*e21*e24+2*e15*e22*e25+2*e16*e20*e28-2*e16*e22*e26+2*e17*e21*e28-2*e17*e22*e27+2*e18*e20*e26+2*e18*e21*e27+2*e18*e22*e28;
  A(7,14)=2*e10*e20*e32+2*e10*e22*e30+2*e10*e23*e35+2*e10*e25*e33+2*e10*e26*e38+2*e10*e28*e36+2*e11*e21*e32+2*e11*e22*e31+2*e11*e24*e35+2*e11*e25*e34+2*e11*e27*e38+2*e11*e28*e37+2*e12*e20*e30+2*e12*e21*e31+6*e12*e22*e32-2*e12*e23*e33-2*e12*e24*e34+2*e12*e25*e35-2*e12*e26*e36-2*e12*e27*e37+2*e12*e28*e38+2*e13*e20*e35-2*e13*e22*e33-2*e13*e23*e32+2*e13*e25*e30+2*e14*e21*e35-2*e14*e22*e34-2*e14*e24*e32+2*e14*e25*e31+2*e15*e20*e33+2*e15*e21*e34+2*e15*e22*e35+2*e15*e23*e30+2*e15*e24*e31+2*e15*e25*e32+2*e16*e20*e38-2*e16*e22*e36-2*e16*e26*e32+2*e16*e28*e30+2*e17*e21*e38-2*e17*e22*e37-2*e17*e27*e32+2*e17*e28*e31+2*e18*e20*e36+2*e18*e21*e37+2*e18*e22*e38+2*e18*e26*e30+2*e18*e27*e31+2*e18*e28*e32;
  A(7,15)=2*e10*e30*e32+2*e10*e33*e35+2*e10*e36*e38+2*e11*e31*e32+2*e11*e34*e35+2*e11*e37*e38+e12*e302+e12*e312+3*e12*e322-e12*e332-e12*e342+e12*e352-e12*e362-e12*e372+e12*e382+2*e13*e30*e35-2*e13*e32*e33+2*e14*e31*e35-2*e14*e32*e34+2*e15*e30*e33+2*e15*e31*e34+2*e15*e32*e35+2*e16*e30*e38-2*e16*e32*e36+2*e17*e31*e38-2*e17*e32*e37+2*e18*e30*e36+2*e18*e31*e37+2*e18*e32*e38;
  A(7,16)=e202*e22+2*e20*e23*e25+2*e20*e26*e28+e212*e22+2*e21*e24*e25+2*e21*e27*e28+e223-e22*e232-e22*e242+e22*e252-e22*e262-e22*e272+e22*e282;
  A(7,17)=e202*e32+2*e20*e22*e30+2*e20*e23*e35+2*e20*e25*e33+2*e20*e26*e38+2*e20*e28*e36+e212*e32+2*e21*e22*e31+2*e21*e24*e35+2*e21*e25*e34+2*e21*e27*e38+2*e21*e28*e37+3*e222*e32-2*e22*e23*e33-2*e22*e24*e34+2*e22*e25*e35-2*e22*e26*e36-2*e22*e27*e37+2*e22*e28*e38-e232*e32+2*e23*e25*e30-e242*e32+2*e24*e25*e31+e252*e32-e262*e32+2*e26*e28*e30-e272*e32+2*e27*e28*e31+e282*e32;
  A(7,18)=2*e20*e30*e32+2*e20*e33*e35+2*e20*e36*e38+2*e21*e31*e32+2*e21*e34*e35+2*e21*e37*e38+e22*e302+e22*e312+3*e22*e322-e22*e332-e22*e342+e22*e352-e22*e362-e22*e372+e22*e382+2*e23*e30*e35-2*e23*e32*e33+2*e24*e31*e35-2*e24*e32*e34+2*e25*e30*e33+2*e25*e31*e34+2*e25*e32*e35+2*e26*e30*e38-2*e26*e32*e36+2*e27*e31*e38-2*e27*e32*e37+2*e28*e30*e36+2*e28*e31*e37+2*e28*e32*e38;
  A(7,19)=e302*e32+2*e30*e33*e35+2*e30*e36*e38+e312*e32+2*e31*e34*e35+2*e31*e37*e38+e323-e32*e332-e32*e342+e32*e352-e32*e362-e32*e372+e32*e382;
  A(8,0)=-e002*e05+2*e00*e02*e03-e012*e05+2*e01*e02*e04+e022*e05+e032*e05+2*e03*e06*e08+e042*e05+2*e04*e07*e08+e053-e05*e062-e05*e072+e05*e082;
  A(8,1)=-e102*e15+2*e10*e12*e13-e112*e15+2*e11*e12*e14+e122*e15+e132*e15+2*e13*e16*e18+e142*e15+2*e14*e17*e18+e153-e15*e162-e15*e172+e15*e182;
  A(8,2)=-e002*e15+2*e00*e02*e13+2*e00*e03*e12-2*e00*e05*e10-e012*e15+2*e01*e02*e14+2*e01*e04*e12-2*e01*e05*e11+e022*e15+2*e02*e03*e10+2*e02*e04*e11+2*e02*e05*e12+e032*e15+2*e03*e05*e13+2*e03*e06*e18+2*e03*e08*e16+e042*e15+2*e04*e05*e14+2*e04*e07*e18+2*e04*e08*e17+3*e052*e15-2*e05*e06*e16-2*e05*e07*e17+2*e05*e08*e18-e062*e15+2*e06*e08*e13-e072*e15+2*e07*e08*e14+e082*e15;
  A(8,3)=-2*e00*e10*e15+2*e00*e12*e13-2*e01*e11*e15+2*e01*e12*e14+2*e02*e10*e13+2*e02*e11*e14+2*e02*e12*e15+2*e03*e10*e12+2*e03*e13*e15+2*e03*e16*e18+2*e04*e11*e12+2*e04*e14*e15+2*e04*e17*e18-e05*e102-e05*e112+e05*e122+e05*e132+e05*e142+3*e05*e152-e05*e162-e05*e172+e05*e182+2*e06*e13*e18-2*e06*e15*e16+2*e07*e14*e18-2*e07*e15*e17+2*e08*e13*e16+2*e08*e14*e17+2*e08*e15*e18;
  A(8,4)=-e002*e25+2*e00*e02*e23+2*e00*e03*e22-2*e00*e05*e20-e012*e25+2*e01*e02*e24+2*e01*e04*e22-2*e01*e05*e21+e022*e25+2*e02*e03*e20+2*e02*e04*e21+2*e02*e05*e22+e032*e25+2*e03*e05*e23+2*e03*e06*e28+2*e03*e08*e26+e042*e25+2*e04*e05*e24+2*e04*e07*e28+2*e04*e08*e27+3*e052*e25-2*e05*e06*e26-2*e05*e07*e27+2*e05*e08*e28-e062*e25+2*e06*e08*e23-e072*e25+2*e07*e08*e24+e082*e25;
  A(8,5)=-e002*e35+2*e00*e02*e33+2*e00*e03*e32-2*e00*e05*e30-e012*e35+2*e01*e02*e34+2*e01*e04*e32-2*e01*e05*e31+e022*e35+2*e02*e03*e30+2*e02*e04*e31+2*e02*e05*e32+e032*e35+2*e03*e05*e33+2*e03*e06*e38+2*e03*e08*e36+e042*e35+2*e04*e05*e34+2*e04*e07*e38+2*e04*e08*e37+3*e052*e35-2*e05*e06*e36-2*e05*e07*e37+2*e05*e08*e38-e062*e35+2*e06*e08*e33-e072*e35+2*e07*e08*e34+e082*e35;
  A(8,6)=-e102*e25+2*e10*e12*e23+2*e10*e13*e22-2*e10*e15*e20-e112*e25+2*e11*e12*e24+2*e11*e14*e22-2*e11*e15*e21+e122*e25+2*e12*e13*e20+2*e12*e14*e21+2*e12*e15*e22+e132*e25+2*e13*e15*e23+2*e13*e16*e28+2*e13*e18*e26+e142*e25+2*e14*e15*e24+2*e14*e17*e28+2*e14*e18*e27+3*e152*e25-2*e15*e16*e26-2*e15*e17*e27+2*e15*e18*e28-e162*e25+2*e16*e18*e23-e172*e25+2*e17*e18*e24+e182*e25;
  A(8,7)=-e102*e35+2*e10*e12*e33+2*e10*e13*e32-2*e10*e15*e30-e112*e35+2*e11*e12*e34+2*e11*e14*e32-2*e11*e15*e31+e122*e35+2*e12*e13*e30+2*e12*e14*e31+2*e12*e15*e32+e132*e35+2*e13*e15*e33+2*e13*e16*e38+2*e13*e18*e36+e142*e35+2*e14*e15*e34+2*e14*e17*e38+2*e14*e18*e37+3*e152*e35-2*e15*e16*e36-2*e15*e17*e37+2*e15*e18*e38-e162*e35+2*e16*e18*e33-e172*e35+2*e17*e18*e34+e182*e35;
  A(8,8)=-2*e00*e10*e25+2*e00*e12*e23+2*e00*e13*e22-2*e00*e15*e20-2*e01*e11*e25+2*e01*e12*e24+2*e01*e14*e22-2*e01*e15*e21+2*e02*e10*e23+2*e02*e11*e24+2*e02*e12*e25+2*e02*e13*e20+2*e02*e14*e21+2*e02*e15*e22+2*e03*e10*e22+2*e03*e12*e20+2*e03*e13*e25+2*e03*e15*e23+2*e03*e16*e28+2*e03*e18*e26+2*e04*e11*e22+2*e04*e12*e21+2*e04*e14*e25+2*e04*e15*e24+2*e04*e17*e28+2*e04*e18*e27-2*e05*e10*e20-2*e05*e11*e21+2*e05*e12*e22+2*e05*e13*e23+2*e05*e14*e24+6*e05*e15*e25-2*e05*e16*e26-2*e05*e17*e27+2*e05*e18*e28+2*e06*e13*e28-2*e06*e15*e26-2*e06*e16*e25+2*e06*e18*e23+2*e07*e14*e28-2*e07*e15*e27-2*e07*e17*e25+2*e07*e18*e24+2*e08*e13*e26+2*e08*e14*e27+2*e08*e15*e28+2*e08*e16*e23+2*e08*e17*e24+2*e08*e18*e25;
  A(8,9)=-2*e00*e10*e35+2*e00*e12*e33+2*e00*e13*e32-2*e00*e15*e30-2*e01*e11*e35+2*e01*e12*e34+2*e01*e14*e32-2*e01*e15*e31+2*e02*e10*e33+2*e02*e11*e34+2*e02*e12*e35+2*e02*e13*e30+2*e02*e14*e31+2*e02*e15*e32+2*e03*e10*e32+2*e03*e12*e30+2*e03*e13*e35+2*e03*e15*e33+2*e03*e16*e38+2*e03*e18*e36+2*e04*e11*e32+2*e04*e12*e31+2*e04*e14*e35+2*e04*e15*e34+2*e04*e17*e38+2*e04*e18*e37-2*e05*e10*e30-2*e05*e11*e31+2*e05*e12*e32+2*e05*e13*e33+2*e05*e14*e34+6*e05*e15*e35-2*e05*e16*e36-2*e05*e17*e37+2*e05*e18*e38+2*e06*e13*e38-2*e06*e15*e36-2*e06*e16*e35+2*e06*e18*e33+2*e07*e14*e38-2*e07*e15*e37-2*e07*e17*e35+2*e07*e18*e34+2*e08*e13*e36+2*e08*e14*e37+2*e08*e15*e38+2*e08*e16*e33+2*e08*e17*e34+2*e08*e18*e35;
  A(8,10)=-2*e00*e20*e25+2*e00*e22*e23-2*e01*e21*e25+2*e01*e22*e24+2*e02*e20*e23+2*e02*e21*e24+2*e02*e22*e25+2*e03*e20*e22+2*e03*e23*e25+2*e03*e26*e28+2*e04*e21*e22+2*e04*e24*e25+2*e04*e27*e28-e05*e202-e05*e212+e05*e222+e05*e232+e05*e242+3*e05*e252-e05*e262-e05*e272+e05*e282+2*e06*e23*e28-2*e06*e25*e26+2*e07*e24*e28-2*e07*e25*e27+2*e08*e23*e26+2*e08*e24*e27+2*e08*e25*e28;
  A(8,11)=-2*e00*e20*e35+2*e00*e22*e33+2*e00*e23*e32-2*e00*e25*e30-2*e01*e21*e35+2*e01*e22*e34+2*e01*e24*e32-2*e01*e25*e31+2*e02*e20*e33+2*e02*e21*e34+2*e02*e22*e35+2*e02*e23*e30+2*e02*e24*e31+2*e02*e25*e32+2*e03*e20*e32+2*e03*e22*e30+2*e03*e23*e35+2*e03*e25*e33+2*e03*e26*e38+2*e03*e28*e36+2*e04*e21*e32+2*e04*e22*e31+2*e04*e24*e35+2*e04*e25*e34+2*e04*e27*e38+2*e04*e28*e37-2*e05*e20*e30-2*e05*e21*e31+2*e05*e22*e32+2*e05*e23*e33+2*e05*e24*e34+6*e05*e25*e35-2*e05*e26*e36-2*e05*e27*e37+2*e05*e28*e38+2*e06*e23*e38-2*e06*e25*e36-2*e06*e26*e35+2*e06*e28*e33+2*e07*e24*e38-2*e07*e25*e37-2*e07*e27*e35+2*e07*e28*e34+2*e08*e23*e36+2*e08*e24*e37+2*e08*e25*e38+2*e08*e26*e33+2*e08*e27*e34+2*e08*e28*e35;
  A(8,12)=-2*e00*e30*e35+2*e00*e32*e33-2*e01*e31*e35+2*e01*e32*e34+2*e02*e30*e33+2*e02*e31*e34+2*e02*e32*e35+2*e03*e30*e32+2*e03*e33*e35+2*e03*e36*e38+2*e04*e31*e32+2*e04*e34*e35+2*e04*e37*e38-e05*e302-e05*e312+e05*e322+e05*e332+e05*e342+3*e05*e352-e05*e362-e05*e372+e05*e382+2*e06*e33*e38-2*e06*e35*e36+2*e07*e34*e38-2*e07*e35*e37+2*e08*e33*e36+2*e08*e34*e37+2*e08*e35*e38;
  A(8,13)=-2*e10*e20*e25+2*e10*e22*e23-2*e11*e21*e25+2*e11*e22*e24+2*e12*e20*e23+2*e12*e21*e24+2*e12*e22*e25+2*e13*e20*e22+2*e13*e23*e25+2*e13*e26*e28+2*e14*e21*e22+2*e14*e24*e25+2*e14*e27*e28-e15*e202-e15*e212+e15*e222+e15*e232+e15*e242+3*e15*e252-e15*e262-e15*e272+e15*e282+2*e16*e23*e28-2*e16*e25*e26+2*e17*e24*e28-2*e17*e25*e27+2*e18*e23*e26+2*e18*e24*e27+2*e18*e25*e28;
  A(8,14)=-2*e10*e20*e35+2*e10*e22*e33+2*e10*e23*e32-2*e10*e25*e30-2*e11*e21*e35+2*e11*e22*e34+2*e11*e24*e32-2*e11*e25*e31+2*e12*e20*e33+2*e12*e21*e34+2*e12*e22*e35+2*e12*e23*e30+2*e12*e24*e31+2*e12*e25*e32+2*e13*e20*e32+2*e13*e22*e30+2*e13*e23*e35+2*e13*e25*e33+2*e13*e26*e38+2*e13*e28*e36+2*e14*e21*e32+2*e14*e22*e31+2*e14*e24*e35+2*e14*e25*e34+2*e14*e27*e38+2*e14*e28*e37-2*e15*e20*e30-2*e15*e21*e31+2*e15*e22*e32+2*e15*e23*e33+2*e15*e24*e34+6*e15*e25*e35-2*e15*e26*e36-2*e15*e27*e37+2*e15*e28*e38+2*e16*e23*e38-2*e16*e25*e36-2*e16*e26*e35+2*e16*e28*e33+2*e17*e24*e38-2*e17*e25*e37-2*e17*e27*e35+2*e17*e28*e34+2*e18*e23*e36+2*e18*e24*e37+2*e18*e25*e38+2*e18*e26*e33+2*e18*e27*e34+2*e18*e28*e35;
  A(8,15)=-2*e10*e30*e35+2*e10*e32*e33-2*e11*e31*e35+2*e11*e32*e34+2*e12*e30*e33+2*e12*e31*e34+2*e12*e32*e35+2*e13*e30*e32+2*e13*e33*e35+2*e13*e36*e38+2*e14*e31*e32+2*e14*e34*e35+2*e14*e37*e38-e15*e302-e15*e312+e15*e322+e15*e332+e15*e342+3*e15*e352-e15*e362-e15*e372+e15*e382+2*e16*e33*e38-2*e16*e35*e36+2*e17*e34*e38-2*e17*e35*e37+2*e18*e33*e36+2*e18*e34*e37+2*e18*e35*e38;
  A(8,16)=-e202*e25+2*e20*e22*e23-e212*e25+2*e21*e22*e24+e222*e25+e232*e25+2*e23*e26*e28+e242*e25+2*e24*e27*e28+e253-e25*e262-e25*e272+e25*e282;
  A(8,17)=-e202*e35+2*e20*e22*e33+2*e20*e23*e32-2*e20*e25*e30-e212*e35+2*e21*e22*e34+2*e21*e24*e32-2*e21*e25*e31+e222*e35+2*e22*e23*e30+2*e22*e24*e31+2*e22*e25*e32+e232*e35+2*e23*e25*e33+2*e23*e26*e38+2*e23*e28*e36+e242*e35+2*e24*e25*e34+2*e24*e27*e38+2*e24*e28*e37+3*e252*e35-2*e25*e26*e36-2*e25*e27*e37+2*e25*e28*e38-e262*e35+2*e26*e28*e33-e272*e35+2*e27*e28*e34+e282*e35;
  A(8,18)=-2*e20*e30*e35+2*e20*e32*e33-2*e21*e31*e35+2*e21*e32*e34+2*e22*e30*e33+2*e22*e31*e34+2*e22*e32*e35+2*e23*e30*e32+2*e23*e33*e35+2*e23*e36*e38+2*e24*e31*e32+2*e24*e34*e35+2*e24*e37*e38-e25*e302-e25*e312+e25*e322+e25*e332+e25*e342+3*e25*e352-e25*e362-e25*e372+e25*e382+2*e26*e33*e38-2*e26*e35*e36+2*e27*e34*e38-2*e27*e35*e37+2*e28*e33*e36+2*e28*e34*e37+2*e28*e35*e38;
  A(8,19)=-e302*e35+2*e30*e32*e33-e312*e35+2*e31*e32*e34+e322*e35+e332*e35+2*e33*e36*e38+e342*e35+2*e34*e37*e38+e353-e35*e362-e35*e372+e35*e382;
  A(9,0)=-e002*e08+2*e00*e02*e06-e012*e08+2*e01*e02*e07+e022*e08-e032*e08+2*e03*e05*e06-e042*e08+2*e04*e05*e07+e052*e08+e062*e08+e072*e08+e083;
  A(9,1)=-e102*e18+2*e10*e12*e16-e112*e18+2*e11*e12*e17+e122*e18-e132*e18+2*e13*e15*e16-e142*e18+2*e14*e15*e17+e152*e18+e162*e18+e172*e18+e183;
  A(9,2)=-e002*e18+2*e00*e02*e16+2*e00*e06*e12-2*e00*e08*e10-e012*e18+2*e01*e02*e17+2*e01*e07*e12-2*e01*e08*e11+e022*e18+2*e02*e06*e10+2*e02*e07*e11+2*e02*e08*e12-e032*e18+2*e03*e05*e16+2*e03*e06*e15-2*e03*e08*e13-e042*e18+2*e04*e05*e17+2*e04*e07*e15-2*e04*e08*e14+e052*e18+2*e05*e06*e13+2*e05*e07*e14+2*e05*e08*e15+e062*e18+2*e06*e08*e16+e072*e18+2*e07*e08*e17+3*e082*e18;
  A(9,3)=-2*e00*e10*e18+2*e00*e12*e16-2*e01*e11*e18+2*e01*e12*e17+2*e02*e10*e16+2*e02*e11*e17+2*e02*e12*e18-2*e03*e13*e18+2*e03*e15*e16-2*e04*e14*e18+2*e04*e15*e17+2*e05*e13*e16+2*e05*e14*e17+2*e05*e15*e18+2*e06*e10*e12+2*e06*e13*e15+2*e06*e16*e18+2*e07*e11*e12+2*e07*e14*e15+2*e07*e17*e18-e08*e102-e08*e112+e08*e122-e08*e132-e08*e142+e08*e152+e08*e162+e08*e172+3*e08*e182;
  A(9,4)=-e002*e28+2*e00*e02*e26+2*e00*e06*e22-2*e00*e08*e20-e012*e28+2*e01*e02*e27+2*e01*e07*e22-2*e01*e08*e21+e022*e28+2*e02*e06*e20+2*e02*e07*e21+2*e02*e08*e22-e032*e28+2*e03*e05*e26+2*e03*e06*e25-2*e03*e08*e23-e042*e28+2*e04*e05*e27+2*e04*e07*e25-2*e04*e08*e24+e052*e28+2*e05*e06*e23+2*e05*e07*e24+2*e05*e08*e25+e062*e28+2*e06*e08*e26+e072*e28+2*e07*e08*e27+3*e082*e28;
  A(9,5)=-e002*e38+2*e00*e02*e36+2*e00*e06*e32-2*e00*e08*e30-e012*e38+2*e01*e02*e37+2*e01*e07*e32-2*e01*e08*e31+e022*e38+2*e02*e06*e30+2*e02*e07*e31+2*e02*e08*e32-e032*e38+2*e03*e05*e36+2*e03*e06*e35-2*e03*e08*e33-e042*e38+2*e04*e05*e37+2*e04*e07*e35-2*e04*e08*e34+e052*e38+2*e05*e06*e33+2*e05*e07*e34+2*e05*e08*e35+e062*e38+2*e06*e08*e36+e072*e38+2*e07*e08*e37+3*e082*e38;
  A(9,6)=-e102*e28+2*e10*e12*e26+2*e10*e16*e22-2*e10*e18*e20-e112*e28+2*e11*e12*e27+2*e11*e17*e22-2*e11*e18*e21+e122*e28+2*e12*e16*e20+2*e12*e17*e21+2*e12*e18*e22-e132*e28+2*e13*e15*e26+2*e13*e16*e25-2*e13*e18*e23-e142*e28+2*e14*e15*e27+2*e14*e17*e25-2*e14*e18*e24+e152*e28+2*e15*e16*e23+2*e15*e17*e24+2*e15*e18*e25+e162*e28+2*e16*e18*e26+e172*e28+2*e17*e18*e27+3*e182*e28;
  A(9,7)=-e102*e38+2*e10*e12*e36+2*e10*e16*e32-2*e10*e18*e30-e112*e38+2*e11*e12*e37+2*e11*e17*e32-2*e11*e18*e31+e122*e38+2*e12*e16*e30+2*e12*e17*e31+2*e12*e18*e32-e132*e38+2*e13*e15*e36+2*e13*e16*e35-2*e13*e18*e33-e142*e38+2*e14*e15*e37+2*e14*e17*e35-2*e14*e18*e34+e152*e38+2*e15*e16*e33+2*e15*e17*e34+2*e15*e18*e35+e162*e38+2*e16*e18*e36+e172*e38+2*e17*e18*e37+3*e182*e38;
  A(9,8)=-2*e00*e10*e28+2*e00*e12*e26+2*e00*e16*e22-2*e00*e18*e20-2*e01*e11*e28+2*e01*e12*e27+2*e01*e17*e22-2*e01*e18*e21+2*e02*e10*e26+2*e02*e11*e27+2*e02*e12*e28+2*e02*e16*e20+2*e02*e17*e21+2*e02*e18*e22-2*e03*e13*e28+2*e03*e15*e26+2*e03*e16*e25-2*e03*e18*e23-2*e04*e14*e28+2*e04*e15*e27+2*e04*e17*e25-2*e04*e18*e24+2*e05*e13*e26+2*e05*e14*e27+2*e05*e15*e28+2*e05*e16*e23+2*e05*e17*e24+2*e05*e18*e25+2*e06*e10*e22+2*e06*e12*e20+2*e06*e13*e25+2*e06*e15*e23+2*e06*e16*e28+2*e06*e18*e26+2*e07*e11*e22+2*e07*e12*e21+2*e07*e14*e25+2*e07*e15*e24+2*e07*e17*e28+2*e07*e18*e27-2*e08*e10*e20-2*e08*e11*e21+2*e08*e12*e22-2*e08*e13*e23-2*e08*e14*e24+2*e08*e15*e25+2*e08*e16*e26+2*e08*e17*e27+6*e08*e18*e28;
  A(9,9)=-2*e00*e10*e38+2*e00*e12*e36+2*e00*e16*e32-2*e00*e18*e30-2*e01*e11*e38+2*e01*e12*e37+2*e01*e17*e32-2*e01*e18*e31+2*e02*e10*e36+2*e02*e11*e37+2*e02*e12*e38+2*e02*e16*e30+2*e02*e17*e31+2*e02*e18*e32-2*e03*e13*e38+2*e03*e15*e36+2*e03*e16*e35-2*e03*e18*e33-2*e04*e14*e38+2*e04*e15*e37+2*e04*e17*e35-2*e04*e18*e34+2*e05*e13*e36+2*e05*e14*e37+2*e05*e15*e38+2*e05*e16*e33+2*e05*e17*e34+2*e05*e18*e35+2*e06*e10*e32+2*e06*e12*e30+2*e06*e13*e35+2*e06*e15*e33+2*e06*e16*e38+2*e06*e18*e36+2*e07*e11*e32+2*e07*e12*e31+2*e07*e14*e35+2*e07*e15*e34+2*e07*e17*e38+2*e07*e18*e37-2*e08*e10*e30-2*e08*e11*e31+2*e08*e12*e32-2*e08*e13*e33-2*e08*e14*e34+2*e08*e15*e35+2*e08*e16*e36+2*e08*e17*e37+6*e08*e18*e38;
  A(9,10)=-2*e00*e20*e28+2*e00*e22*e26-2*e01*e21*e28+2*e01*e22*e27+2*e02*e20*e26+2*e02*e21*e27+2*e02*e22*e28-2*e03*e23*e28+2*e03*e25*e26-2*e04*e24*e28+2*e04*e25*e27+2*e05*e23*e26+2*e05*e24*e27+2*e05*e25*e28+2*e06*e20*e22+2*e06*e23*e25+2*e06*e26*e28+2*e07*e21*e22+2*e07*e24*e25+2*e07*e27*e28-e08*e202-e08*e212+e08*e222-e08*e232-e08*e242+e08*e252+e08*e262+e08*e272+3*e08*e282;
  A(9,11)=-2*e00*e20*e38+2*e00*e22*e36+2*e00*e26*e32-2*e00*e28*e30-2*e01*e21*e38+2*e01*e22*e37+2*e01*e27*e32-2*e01*e28*e31+2*e02*e20*e36+2*e02*e21*e37+2*e02*e22*e38+2*e02*e26*e30+2*e02*e27*e31+2*e02*e28*e32-2*e03*e23*e38+2*e03*e25*e36+2*e03*e26*e35-2*e03*e28*e33-2*e04*e24*e38+2*e04*e25*e37+2*e04*e27*e35-2*e04*e28*e34+2*e05*e23*e36+2*e05*e24*e37+2*e05*e25*e38+2*e05*e26*e33+2*e05*e27*e34+2*e05*e28*e35+2*e06*e20*e32+2*e06*e22*e30+2*e06*e23*e35+2*e06*e25*e33+2*e06*e26*e38+2*e06*e28*e36+2*e07*e21*e32+2*e07*e22*e31+2*e07*e24*e35+2*e07*e25*e34+2*e07*e27*e38+2*e07*e28*e37-2*e08*e20*e30-2*e08*e21*e31+2*e08*e22*e32-2*e08*e23*e33-2*e08*e24*e34+2*e08*e25*e35+2*e08*e26*e36+2*e08*e27*e37+6*e08*e28*e38;
  A(9,12)=-2*e00*e30*e38+2*e00*e32*e36-2*e01*e31*e38+2*e01*e32*e37+2*e02*e30*e36+2*e02*e31*e37+2*e02*e32*e38-2*e03*e33*e38+2*e03*e35*e36-2*e04*e34*e38+2*e04*e35*e37+2*e05*e33*e36+2*e05*e34*e37+2*e05*e35*e38+2*e06*e30*e32+2*e06*e33*e35+2*e06*e36*e38+2*e07*e31*e32+2*e07*e34*e35+2*e07*e37*e38-e08*e302-e08*e312+e08*e322-e08*e332-e08*e342+e08*e352+e08*e362+e08*e372+3*e08*e382;
  A(9,13)=-2*e10*e20*e28+2*e10*e22*e26-2*e11*e21*e28+2*e11*e22*e27+2*e12*e20*e26+2*e12*e21*e27+2*e12*e22*e28-2*e13*e23*e28+2*e13*e25*e26-2*e14*e24*e28+2*e14*e25*e27+2*e15*e23*e26+2*e15*e24*e27+2*e15*e25*e28+2*e16*e20*e22+2*e16*e23*e25+2*e16*e26*e28+2*e17*e21*e22+2*e17*e24*e25+2*e17*e27*e28-e18*e202-e18*e212+e18*e222-e18*e232-e18*e242+e18*e252+e18*e262+e18*e272+3*e18*e282;
  A(9,14)=-2*e10*e20*e38+2*e10*e22*e36+2*e10*e26*e32-2*e10*e28*e30-2*e11*e21*e38+2*e11*e22*e37+2*e11*e27*e32-2*e11*e28*e31+2*e12*e20*e36+2*e12*e21*e37+2*e12*e22*e38+2*e12*e26*e30+2*e12*e27*e31+2*e12*e28*e32-2*e13*e23*e38+2*e13*e25*e36+2*e13*e26*e35-2*e13*e28*e33-2*e14*e24*e38+2*e14*e25*e37+2*e14*e27*e35-2*e14*e28*e34+2*e15*e23*e36+2*e15*e24*e37+2*e15*e25*e38+2*e15*e26*e33+2*e15*e27*e34+2*e15*e28*e35+2*e16*e20*e32+2*e16*e22*e30+2*e16*e23*e35+2*e16*e25*e33+2*e16*e26*e38+2*e16*e28*e36+2*e17*e21*e32+2*e17*e22*e31+2*e17*e24*e35+2*e17*e25*e34+2*e17*e27*e38+2*e17*e28*e37-2*e18*e20*e30-2*e18*e21*e31+2*e18*e22*e32-2*e18*e23*e33-2*e18*e24*e34+2*e18*e25*e35+2*e18*e26*e36+2*e18*e27*e37+6*e18*e28*e38;
  A(9,15)=-2*e10*e30*e38+2*e10*e32*e36-2*e11*e31*e38+2*e11*e32*e37+2*e12*e30*e36+2*e12*e31*e37+2*e12*e32*e38-2*e13*e33*e38+2*e13*e35*e36-2*e14*e34*e38+2*e14*e35*e37+2*e15*e33*e36+2*e15*e34*e37+2*e15*e35*e38+2*e16*e30*e32+2*e16*e33*e35+2*e16*e36*e38+2*e17*e31*e32+2*e17*e34*e35+2*e17*e37*e38-e18*e302-e18*e312+e18*e322-e18*e332-e18*e342+e18*e352+e18*e362+e18*e372+3*e18*e382;
  A(9,16)=-e202*e28+2*e20*e22*e26-e212*e28+2*e21*e22*e27+e222*e28-e232*e28+2*e23*e25*e26-e242*e28+2*e24*e25*e27+e252*e28+e262*e28+e272*e28+e283;
  A(9,17)=-e202*e38+2*e20*e22*e36+2*e20*e26*e32-2*e20*e28*e30-e212*e38+2*e21*e22*e37+2*e21*e27*e32-2*e21*e28*e31+e222*e38+2*e22*e26*e30+2*e22*e27*e31+2*e22*e28*e32-e232*e38+2*e23*e25*e36+2*e23*e26*e35-2*e23*e28*e33-e242*e38+2*e24*e25*e37+2*e24*e27*e35-2*e24*e28*e34+e252*e38+2*e25*e26*e33+2*e25*e27*e34+2*e25*e28*e35+e262*e38+2*e26*e28*e36+e272*e38+2*e27*e28*e37+3*e282*e38;
  A(9,18)=-2*e20*e30*e38+2*e20*e32*e36-2*e21*e31*e38+2*e21*e32*e37+2*e22*e30*e36+2*e22*e31*e37+2*e22*e32*e38-2*e23*e33*e38+2*e23*e35*e36-2*e24*e34*e38+2*e24*e35*e37+2*e25*e33*e36+2*e25*e34*e37+2*e25*e35*e38+2*e26*e30*e32+2*e26*e33*e35+2*e26*e36*e38+2*e27*e31*e32+2*e27*e34*e35+2*e27*e37*e38-e28*e302-e28*e312+e28*e322-e28*e332-e28*e342+e28*e352+e28*e362+e28*e372+3*e28*e382;
  A(9,19)=-e302*e38+2*e30*e32*e36-e312*e38+2*e31*e32*e37+e322*e38-e332*e38+2*e33*e35*e36-e342*e38+2*e34*e35*e37+e352*e38+e362*e38+e372*e38+e383;
}

double
opengv::relative_pose::modules::fivept_nister::polyVal(
    const Eigen::MatrixXd & p,
    double x)
{
  size_t degree = p.cols();
  double value = 0.0;
  for( size_t power = degree; power > 0; power--)
      value += p(0, (int)(degree-power))*pow(x,(int)(power-1));

  return value;
}

void
opengv::relative_pose::modules::fivept_nister::
    computeSeventhOrderPolynomial(
    const Eigen::Matrix<double,1,5> & p1,
    const Eigen::Matrix<double,1,4> & p2,
    Eigen::Matrix<double,1,8> & p_out )
{
  p_out = Eigen::Matrix<double,1,8>::Zero();
  p_out[0] = p1[0]*p2[0];
  p_out[1] = p1[0]*p2[1] + p1[1]*p2[0];
  p_out[2] = p1[0]*p2[2] + p1[1]*p2[1] + p1[2]*p2[0];
  p_out[3] = p1[0]*p2[3] + p1[1]*p2[2] + p1[2]*p2[1] + p1[3]*p2[0];
  p_out[4] = p1[1]*p2[3] + p1[2]*p2[2] + p1[3]*p2[1] + p1[4]*p2[0];
  p_out[5] = p1[2]*p2[3] + p1[3]*p2[2] + p1[4]*p2[1];
  p_out[6] = p1[3]*p2[3] + p1[4]*p2[2];
  p_out[7] = p1[4]*p2[3];
}

void
opengv::relative_pose::modules::fivept_nister::
    computeSixthOrderPolynomial(
    const Eigen::Matrix<double,1,4> & p1,
    const Eigen::Matrix<double,1,4> & p2,
    Eigen::Matrix<double,1,7> & p_out )
{
  p_out = Eigen::Matrix<double,1,7>::Zero();
  p_out[0] = p1[0]*p2[0];
  p_out[1] = p1[0]*p2[1] + p1[1]*p2[0];
  p_out[2] = p1[0]*p2[2] + p1[1]*p2[1] + p1[2]*p2[0];
  p_out[3] = p1[0]*p2[3] + p1[1]*p2[2] + p1[2]*p2[1] + p1[3]*p2[0];
  p_out[4] = p1[1]*p2[3] + p1[2]*p2[2] + p1[3]*p2[1];
  p_out[5] = p1[2]*p2[3] + p1[3]*p2[2];
  p_out[6] = p1[3]*p2[3];
}

void
opengv::relative_pose::modules::fivept_nister::
    computeTenthOrderPolynomialFrom73(
    const Eigen::Matrix<double,1,8> & p1,
    const Eigen::Matrix<double,1,4> & p2,
    Eigen::Matrix<double,1,11> & p_out )
{
  p_out = Eigen::Matrix<double,1,11>::Zero();
  p_out[0]  = p1[0]*p2[0];
  p_out[1]  = p1[0]*p2[1] + p1[1]*p2[0];
  p_out[2]  = p1[0]*p2[2] + p1[1]*p2[1] + p1[2]*p2[0];
  p_out[3]  = p1[0]*p2[3] + p1[1]*p2[2] + p1[2]*p2[1] + p1[3]*p2[0];
  p_out[4]  = p1[1]*p2[3] + p1[2]*p2[2] + p1[3]*p2[1] + p1[4]*p2[0];
  p_out[5]  = p1[2]*p2[3] + p1[3]*p2[2] + p1[4]*p2[1] + p1[5]*p2[0];
  p_out[6]  = p1[3]*p2[3] + p1[4]*p2[2] + p1[5]*p2[1] + p1[6]*p2[0];
  p_out[7]  = p1[4]*p2[3] + p1[5]*p2[2] + p1[6]*p2[1] + p1[7]*p2[0];
  p_out[8]  = p1[5]*p2[3] + p1[6]*p2[2] + p1[7]*p2[1];
  p_out[9]  = p1[6]*p2[3] + p1[7]*p2[2];
  p_out[10] = p1[7]*p2[3];
}

void
opengv::relative_pose::modules::fivept_nister::
    computeTenthOrderPolynomialFrom64(
    const Eigen::Matrix<double,1,7> & p1,
    const Eigen::Matrix<double,1,5> & p2,
    Eigen::Matrix<double,1,11> & p_out )
{
  p_out = Eigen::Matrix<double,1,11>::Zero();
  p_out[0]  = p1[0]*p2[0];
  p_out[1]  = p1[0]*p2[1] + p1[1]*p2[0];
  p_out[2]  = p1[0]*p2[2] + p1[1]*p2[1] + p1[2]*p2[0];
  p_out[3]  = p1[0]*p2[3] + p1[1]*p2[2] + p1[2]*p2[1] + p1[3]*p2[0];
  p_out[4]  = p1[0]*p2[4] + p1[1]*p2[3] + p1[2]*p2[2] + p1[3]*p2[1] + p1[4]*p2[0];
  p_out[5]  = p1[1]*p2[4] + p1[2]*p2[3] + p1[3]*p2[2] + p1[4]*p2[1] + p1[5]*p2[0];
  p_out[6]  = p1[2]*p2[4] + p1[3]*p2[3] + p1[4]*p2[2] + p1[5]*p2[1] + p1[6]*p2[0];
  p_out[7]  = p1[3]*p2[4] + p1[4]*p2[3] + p1[5]*p2[2] + p1[6]*p2[1];
  p_out[8]  = p1[4]*p2[4] + p1[5]*p2[3] + p1[6]*p2[2];
  p_out[9]  = p1[5]*p2[4] + p1[6]*p2[3];
  p_out[10] = p1[6]*p2[4];
}

namespace opengv
{
namespace relative_pose
{
namespace modules
{
namespace fivept_nister
{

struct PollishCoefficientsFunctor : OptimizationFunctor<double>
{
  const Eigen::Matrix<double,10,20> & _A;

  PollishCoefficientsFunctor( const Eigen::Matrix<double,10,20> & A ) :
      OptimizationFunctor<double>(3,10),
      _A(A) {}

  int operator()(const VectorXd &x, VectorXd &fvec) const
  {
    assert( x.size() == 3 );
    assert( (unsigned int) fvec.size() == 10);

    //create the monomials vector
    Eigen::Matrix<double,20,1> monomials;
    monomials[0] = pow(x[0],3);
    monomials[1] = pow(x[1],3);
    monomials[2] = pow(x[0],2)*x[1];
    monomials[3] = x[0]*pow(x[1],2);
    monomials[4] = pow(x[0],2)*x[2];
    monomials[5] = pow(x[0],2);
    monomials[6] = pow(x[1],2)*x[2];
    monomials[7] = pow(x[1],2);
    monomials[8] = x[0]*x[1]*x[2];
    monomials[9] = x[0]*x[1];
    monomials[10] = x[0]*pow(x[2],2);
    monomials[11] = x[0]*x[2];
    monomials[12] = x[0];
    monomials[13] = x[1]*pow(x[2],2);
    monomials[14] = x[1]*x[2];
    monomials[15] = x[1];
    monomials[16] = pow(x[2],3);
    monomials[17] = pow(x[2],2);
    monomials[18] = x[2];
    monomials[19] = 1.0;

    fvec = _A*monomials;

    return 0;
  }
};

}
}
}
}

void
opengv::relative_pose::modules::fivept_nister::pollishCoefficients(
    const Eigen::Matrix<double,10,20> & A,
    double & x_coeff,
    double & y_coeff,
    double & z_coeff)
{
  const int n=3;
  VectorXd x(n);

  x[0] = x_coeff;
  x[1] = y_coeff;
  x[2] = z_coeff;

  PollishCoefficientsFunctor functor( A );
  NumericalDiff<PollishCoefficientsFunctor> numDiff(functor);
  LevenbergMarquardt< NumericalDiff<PollishCoefficientsFunctor> >
      lm(numDiff);

  lm.resetParameters();
  lm.parameters.ftol = 1.E10*NumTraits<double>::epsilon();
  lm.parameters.xtol = 1.E10*NumTraits<double>::epsilon();
  lm.parameters.maxfev = 5;
  lm.minimize(x);

  x_coeff = x[0];
  y_coeff = x[1];
  z_coeff = x[2];
}
