# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8144 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64553);
 script_cve_id("CVE-2009-1895", "CVE-2009-2406", "CVE-2009-2407", "CVE-2009-1897");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-8144 (kernel)");

 desc = "The remote host is missing an update to kernel
announced via advisory FEDORA-2009-8144.

The kernel package contains the Linux kernel (vmlinuz), the core of any
Linux operating system.  The kernel handles the basic functions
of the operating system: memory allocation, process allocation, device
input and output, etc.

Update Information:

Fix security bugs:  CVE-2009-1895  CVE-2009-2406  CVE-2009-2407

ChangeLog:

* Wed Jul 29 2009 Chuck Ebbert  2.6.29.6-217.2.3
- Don't optimize away NULL pointer tests where pointer is used before the test.
(CVE-2009-1897)
* Wed Jul 29 2009 Chuck Ebbert  2.6.29.6-217.2.2
- Fix mmap_min_addr security bugs (CVE-2009-1895)
* Wed Jul 29 2009 Chuck Ebbert  2.6.29.6-217.2.1
- Fix eCryptfs overflow issues (CVE-2009-2406, CVE-2009-2407)
* Thu Jul 23 2009 Kyle McMartin  2.6.29.6-217
- Apply three patches requested by sgruszka@redhat.com:
- iwl3945-release-resources-before-shutting-down.patch
- iwl3945-add-debugging-for-wrong-command-queue.patch
- iwl3945-fix-rfkill-sw-and-hw-mishmash.patch
* Thu Jul 23 2009 Jarod Wilson 
- virtio_blk: don't bounce highmem requests, works around a frequent
oops in kvm guests using virtio block devices (#510304)
* Wed Jul 22 2009 Tom spot Callaway 
- We have to override the new %install behavior because, well... the kernel is
special.
* Wed Jul 22 2009 Ben Skeggs 
- drm-nouveau.patch: Fix DPMS off for DAC outputs, NV4x PFIFO typo

References:

[ 1 ] Bug #511171 - CVE-2009-1895 kernel: personality: fix PER_CLEAR_ON_SETID
https://bugzilla.redhat.com/show_bug.cgi?id=511171
[ 2 ] Bug #512861 - CVE-2009-2406 kernel: ecryptfs stack overflow in parse_tag_11_packet()
https://bugzilla.redhat.com/show_bug.cgi?id=512861
[ 3 ] Bug #512885 - CVE-2009-2407 kernel: ecryptfs heap overflow in parse_tag_3_packet()
https://bugzilla.redhat.com/show_bug.cgi?id=512885

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kernel' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8144

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8144 (kernel)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-devel", rpm:"kernel-devel~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-headers", rpm:"kernel-headers~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo", rpm:"kernel-debuginfo~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debuginfo-common", rpm:"kernel-debuginfo-common~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE", rpm:"kernel-PAE~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-devel", rpm:"kernel-PAE-devel~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug", rpm:"kernel-PAEdebug~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-devel", rpm:"kernel-PAEdebug-devel~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAE-debuginfo", rpm:"kernel-PAE-debuginfo~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-PAEdebug-debuginfo", rpm:"kernel-PAEdebug-debuginfo~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-firmware", rpm:"kernel-firmware~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-bootwrapper", rpm:"kernel-bootwrapper~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-devel", rpm:"kernel-smp-devel~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-smp-debuginfo", rpm:"kernel-smp-debuginfo~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-devel", rpm:"kernel-debug-devel~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-debuginfo", rpm:"kernel-debug-debuginfo~2.6.29.6~217.2.3.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
