###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_systemtap_shell_cmd_injection_vuln.nasl 7005 2010-01-29 12:33:29 jan $
#
# SystemTap 'stap-server' Remote Shell Command Injection Vulnerability
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902017);
  script_version("$Revision: 8288 $: 1.0");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-4273");
  script_name("SystemTap 'stap-server' Remote Shell Command Injection Vulnerability");
  desc = "
  Overview: This host has SystemTap installed and is prone to Arbitrary Command
  Execution vulnerability

  Vulnerability Insight:
  The flaw is caused due to input validation error in the 'stap-server' component
  when processing user-supplied requests.

  Impact:
  Successful exploitation could allow rmote attackers to inject and execute
  malicious shell commands or compromise a system.

  Impact Level: System.

  Affected Software/OS:
  SystemTap versions prior to 1.1

  Fix:
  No solution or patch is available as on 29th January, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sourceware.org/systemtap/

  References:
  http://secunia.com/advisories/38154
  http://www.vupen.com/english/advisories/2010/0169

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.4
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of SystemTap");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_dependencies("secpod_systemtap_detect.nasl");
  script_family("General");
  script_require_keys("SystemTap/Ver");
  exit(0);
}


include("version_func.inc");

systapVer = get_kb_item("SystemTap/Ver");
if(systapVer != NULL)
{
  if(version_is_less(version:systapVer, test_version:"1.1")){
    security_hole(0);
  }
}


