#
#VID 00d6040a-b8e0-11dd-a578-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 00d6040a-b8e0-11dd-a578-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61915);
 script_cve_id("CVE-2008-3102");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: mantis";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: mantis

CVE-2008-3102
Mantis 1.1.x through 1.1.2 and 1.2.x through 1.2.0a2 does not set the
secure flag for the session cookie in an https session, which can
cause the cookie to be sent in http requests and make it easier for
remote attackers to capture this cookie.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.mantisbt.org/bugs/view.php?id=9524
http://www.mantisbt.org/bugs/view.php?id=9533
http://enablesecurity.com/2008/08/11/surf-jack-https-will-not-save-you/
http://int21.de/cve/CVE-2008-3102-mantis.html
http://www.vuxml.org/freebsd/00d6040a-b8e0-11dd-a578-0030843d3802.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: mantis";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mantis");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.3")<0) {
    security_note(0, data:"Package mantis version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
