#
#VID 035d17b2-484a-11d9-813c-00065be4b5b6
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52274);
 script_cve_id("CVE-2004-0835");
 script_bugtraq_id(11357);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: mysql-server";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: mysql-server

CVE-2004-0835
MySQL 3.x before 3.23.59, 4.x before 4.0.19, 4.1.x before 4.1.2, and
5.x before 5.0.1, checks the CREATE/INSERT rights of the original
table instead of the target table in an ALTER TABLE RENAME operation,
which could allow attackers to conduct unauthorized activities.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bugs.mysql.com/bug.php?id=3270
http://rhn.redhat.com/errata/RHSA-2004-611.html
http://xforce.iss.net/xforce/xfdb/17666
http://www.vuxml.org/freebsd/035d17b2-484a-11d9-813c-00065be4b5b6.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: mysql-server";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mysql-server");
if(!isnull(bver) && revcomp(a:bver, b:"3.23.58_3")<=0) {
    security_note(0, data:"Package mysql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"4")>=0 && revcomp(a:bver, b:"4.0.21")<0) {
    security_note(0, data:"Package mysql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
