#
#VID a876df84-0fef-11db-ac96-000c6ec775d9
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57080);
 script_cve_id("CVE-2006-3336");
 script_bugtraq_id(18854);
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: twiki";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: twiki

CVE-2006-3336
TWiki 01-Dec-2000 up to 4.0.3 allows remote attackers to bypass the
upload filter and execute arbitrary code via filenames with double
extensions such as '.php.en', '.php.1', and other allowed extensions
that are not .txt.  NOTE: this is only a vulnerability when the server
allows script execution in the pub directory.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/20992/
http://twiki.org/cgi-bin/view/Codev/SecurityAlertSecureFileUploads
http://www.vuxml.org/freebsd/a876df84-0fef-11db-ac96-000c6ec775d9.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: twiki";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"twiki");
if(!isnull(bver) && revcomp(a:bver, b:"4.0.4,1")<0) {
    security_note(0, data:"Package twiki version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
