PHP_ARG_WITH(imlib, for imlib2 support,
[  --with-imlib[=DIR]      Include imlib support.  DIR is the Imlib2 base
                          directory, defaults to /usr/local.])

AC_DEFUN(AC_TEMP_LDFLAGS,[
  old_LDFLAGS="$LDFLAGS"
  LDFLAGS="$1 $LDFLAGS"
  $2
  LDFLAGS="$old_LDFLAGS"
])

if test "$PHP_IMLIB" != "no"; then
  AC_DEFINE(HAVE_IMLIB, 1, [ ])
  PHP_EXTENSION(imlib, $ext_shared)
  for i in /usr/local /usr $PHP_IMLIB; do
    if test -f $i/include/Imlib2.h; then
      IMLIB2_DIR=$i
    fi
  done

  if test -z "$IMLIB2_DIR"; then
    AC_MSG_ERROR(Cannot find imlib2)
  fi

  IMLIB2_LIBDIR=$IMLIB2_DIR/lib
  IMLIB2_INCDIR=$IMLIB2_DIR/include

  AC_TEMP_LDFLAGS(-L$IMLIB2_LIBDIR,[
  AC_CHECK_LIB(Imlib2, imlib_load_image, [AC_DEFINE(HAVE_IMLIB2,1,[ ])],
    [AC_MSG_ERROR(Imlib2 module requires CVS Imlib2)])
  ])

  PHP_ADD_LIBRARY_WITH_PATH(Imlib2, $IMLIB2_LIBDIR, IMLIB_SHARED_LIBADD)
  PHP_SUBST(IMLIB_SHARED_LIBADD)

  PHP_ADD_INCLUDE($IMLIB2_INCDIR)
fi
