/*
  +----------------------------------------------------------------------+
  | PHP Version 5                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2004 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.0 of the PHP license,       |
  | that is bundled with this package in the file LICENSE, and is        |
  | available at through the world-wide-web at                           |
  | http://www.php.net/license/3_0.txt.                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Jon Parise <jon@php.net>                                     |
  +----------------------------------------------------------------------+
*/

/* $Id: php_sasl.h,v 1.2 2004/01/23 08:34:28 jon Exp $ */

#ifndef PHP_SASL_H
#define PHP_SASL_H

#include <sasl.h>

extern zend_module_entry sasl_module_entry;
#define phpext_sasl_ptr &sasl_module_entry

#ifdef PHP_WIN32
#define PHP_SASL_API __declspec(dllexport)
#else
#define PHP_SASL_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(sasl);
PHP_MSHUTDOWN_FUNCTION(sasl);
PHP_MINFO_FUNCTION(sasl);

/* Common Functions */
PHP_FUNCTION(sasl_version);
PHP_FUNCTION(sasl_errstring);
#if SASL_VERSION_MAJOR >= 2
PHP_FUNCTION(sasl_errdetail);
#endif
PHP_FUNCTION(sasl_encode);
PHP_FUNCTION(sasl_decode);

/* Client Functions */
PHP_FUNCTION(sasl_client_init);
PHP_FUNCTION(sasl_client_new);
PHP_FUNCTION(sasl_client_start);
PHP_FUNCTION(sasl_client_step);

/* Server Functions */
PHP_FUNCTION(sasl_server_init);
PHP_FUNCTION(sasl_server_new);
PHP_FUNCTION(sasl_server_start);
PHP_FUNCTION(sasl_server_step);
PHP_FUNCTION(sasl_listmech);
PHP_FUNCTION(sasl_checkpass);

#if 0
#ifdef ZTS
#define SASLG(v) TSRMG(sasl_globals_id, zend_sasl_globals *, v)
#else
#define SASLG(v) (sasl_globals.v)
#endif
#endif

#endif /* PHP_SASL_H */
