package Process;
our $VERSION = '2004-01-20';
our @ISA = 'BaseObject';

use Classes::BaseObject;

sub new
{
	my $proto = shift;
	my @Constructor_Parameters = @_;

	my $class = ref( $proto ) || $proto;

	my $self = bless $proto->SUPER::new( @Constructor_Parameters ), $class;

	#

	$self->{'Comment'}			= 'unknown';
	$self->{'Command'}			= '/bin/echo';
	$self->{'AllowedUsers'}		= '';
	$self->{'OutputSeparator'}	= ' '; # ' ' or ',' or "\r\n" ...
	$self->{'Output'}			= 'Alert.ident'; # 'Address.address' = Source IP address

	#

	my %Hashage = @Constructor_Parameters;
	foreach my $Key ( keys %Hashage )
	{
		$self->set( $Key, $Hashage{$Key} );
	}

	return $self;
}

sub auth($)
{
	my $self = shift;

	my $UserName = $::ENV{'REMOTE_USER'} || 'guest';
	my $Found = 0;
	my $Count = 0;
	my @Allowed = split( ' ', $self->{'AllowedUsers'} );

	# print "Doing Authentication for User $UserName out of @Allowed<BR>\n";
	while ( ( ! $Found ) && ( $Count <= $#Allowed ) )
	{
		# print "Comparing $Allowed[$Count] with $UserName<BR>\n";
		if ( $Allowed[$Count] eq $UserName )
		{
			$Found = 1;
		}
		$Count ++;
	}

	return $Found;
}

sub load($$)
{
	my $self = shift;
	my $ProcName = shift;

	my $FileName = 'generated/Processing/'.$ProcName.'.proc';

	if ( -f $FileName )
	{
		local *PROCFILE;
		my $theCommand;
		undef $!;
		open( PROCFILE, $FileName );
		if ( $! and ( $! !~ m/Inappropriate ioctl for device/ ) )
		{
			::error( "load->error opening proc-profile \"$ProcName\"" );
			return 0;
		}
		else
		{
			my %Procfile;
			while( my $Line = <PROCFILE> )
			{
				$Line =~ s/^\s+//;
				$Line =~ s/\s*=\s*/=/;
				$Line =~ s/\s*#.*$//;
				$Line =~ s/\r|\n//g;

				if ( $Line )
				{
					my ( $Key, $Value ) = ( $Line =~ m/^(.*)=(.*)$/ );
					$Procfile{$Key} = $Value;
				}
			}

			$self->Comment( $Procfile{'Comment'} );
			$self->Command( $Procfile{'Command'} );
			$self->AllowedUsers( $Procfile{'AllowedUsers'} );
			$self->OutputSeparator( $Procfile{'OutputSeparator'} || ' ' );
			$self->Output( $Procfile{'Output'} || 'alert.ident' );

			return 1;
		}
		close( PROCFILE );
	}
	else
	{
		::error( "Process->load: Process does not exist: $ProcName" );
		return 0;
	}
}

sub ExecCommand($$)
{
	my $self = shift;
	my $AlertList = shift;

	  # Access allowed?
	if ( ! $self->auth() )
	{
		::error( "Authentication for processing failed!" );
		return 0;
	}

	my @Output = ();
	if ( $self->Output() eq 'Alert.ident' )
	{
		@Output = @{$AlertList};
	}
	else
	{
		local $dbh = $::dbh;
		local %db_table_type = %{::Load_TableType()};
		foreach my $AlertId ( @{$AlertList} )
		{
			push @Output, ::get_Data( $self->Output(), $AlertId, 'FIRST' );
		}
	}

	my $Separator = $self->OutputSeparator();
	if ( $Separator eq '$LF' )		{$Separator = "\n";};
	if ( $Separator eq '$CRLF' )	{$Separator = "\r\n";};
	if ( $Separator eq '$SPACE' )	{$Separator = ' ';};
	if ( $Separator eq '$TAB' )		{$Separator = "\t";};

	my $Output = join( $Separator, @Output );

	my $Command = $self->{'Command'};
	local *OUTPIPE;
	open( OUTPIPE, "|$Command" ) or ::error( "Error opening pipe to $Command" );
	print OUTPIPE "$Output\n";
	close( OUTPIPE );

	return ( $#Output+1 );
}

1;
