open Ppxlib

module type S = Ppx_compare_expander_intf.S

module Compare : sig
  include S

  (** [equal_core_type ~with_local ty] is an expression of type [ty -> ty -> bool],
      using the comparison function generated by [core_type]

      [~with_local:true] will make the arguments local *)
  val equal_core_type : with_local:bool -> core_type -> expression
end

module Equal : S
