Thank you for your contribution to the PynPoint repo! Before submitting this PR, please make sure:

- [ ] To read the documentation page on the [Python guidelines](https://pynpoint.readthedocs.io/en/latest/python.html).
- [ ] That your branch of the PR is up to date with the master branch of the upstream PynPoint repo.
- [ ] To update the dependencies to the latest versions with `pip install --upgrade -r requirements.txt`.
- [ ] To run both `pycodestyle` and `pylint` on the code that has been added and/or changed.
- [ ] That the documentation is successfully build after running `make docs` in your local repo folder. This requires the installation of `sphinx` and `sphinx_rtd_theme`.
- [ ] That all unit tests are finishing after running `make test` in your local repo folder. This requires the installation of `pytest` and `pytest-cov`.
- [ ] To add unit tests in case there are new pipeline modules and/or functionalities added.
- [ ] That only text files have been added and changed in the commits of the PR. Binary files will clutter up the repo because even after removing such files they will remain in the repo history.
- [ ] To add and/or update the docstrings (including the parameters, returns, types, and descriptions).
- [ ] To add and/or update the typehints and typechecks.
