# Pyntor::Blend - Blend screen
# Copyright (C) 2004 - 2006 Josef Spillner <josef@coolprojects.org>
# Published under GNU GPL conditions

import pygame
from pygame.locals import *
import sys
import time
import random
import os, pwd
import re

class Blend:
	def init(self, options):
		self.pages = 1
		#pass

	def render(self, screen, page, globalpage):
		screenorig = pygame.Surface((screen.get_width(), screen.get_height()))
		screenorig.blit(screen, (0, 0))

		white = pygame.Surface((screen.get_width(), screen.get_height()))
		white.fill((255, 255, 255))
		alphapart = 200
		for i in range(0, alphapart, 5):
			white.set_alpha(i)
			screen.blit(screenorig, (0, 0))
			screen.blit(white, (0, 0))
			pygame.display.flip()

	def interactive(self, event):
		return "next"

	#def interactive(self, event):
		#if event.type == KEYDOWN:
		#	key = event.key
		#	if key == K_ESCAPE or pygame.event.peek(QUIT):
		#		return "exit"
		#	if key == K_RETURN:
		#		return "next"

		#self.counter += 1
		#if self.counter == 150000:
		#	self.counter = 0
		#	return "reload"

component = Blend()

parameters = ()

metainfo = {
	"version": "0.2",
	"author": "Josef Spillner",
	"authoremail": "<josef@coolprojects.org>",
	"licence": "GPL"
}

doc = """
Blend: blend over the screen

Usage: simply 'blend'

Display: yes

Interactivity: no (but contains timer events)
"""

