# Pyntor::Wait - Wait for a key stroke
# Copyright (C) 2006 Josef Spillner <josef@coolprojects.org>
# Published under GNU GPL conditions

import pygame
from pygame.locals import *

class Wait:
	def init(self, options):
		pass

	def interactive(self, event):
		if event.type == KEYDOWN:
			key = event.key
			if key == K_ESCAPE or pygame.event.peek(QUIT):
				return "exit"
			if key == K_RETURN:
				return "next"

component = Wait()

parameters = ()

metainfo = {
	"version": "0.2",
	"author": "Josef Spillner",
	"authoremail": "<josef@coolprojects.org>",
	"licence": "GPL"
}

doc = """
Wait: waits for a key stroke to proceed with the presentation

Usage: simply 'wait'

Display: none

Interactivity: waits for a key stroke, then proceeds to next slide
"""

