# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential
    from azure.core.pipeline.transport import HttpRequest, HttpResponse

from ._configuration import NetworkManagementClientConfiguration
from .operations import NetworkManagersOperations
from .operations import NetworkManagerCommitsOperations
from .operations import NetworkManagerDeploymentStatusOperations
from .operations import EffectiveVirtualNetworksOperations
from .operations import ActiveConnectivityConfigurationsOperations
from .operations import ActiveSecurityAdminRulesOperations
from .operations import ActiveSecurityUserRulesOperations
from .operations import ConnectivityConfigurationsOperations
from .operations import EffectiveConnectivityConfigurationsOperations
from .operations import NetworkManagerEffectiveSecurityAdminRulesOperations
from .operations import NetworkGroupsOperations
from .operations import SecurityUserConfigurationsOperations
from .operations import UserRuleCollectionsOperations
from .operations import UserRulesOperations
from .operations import SecurityAdminConfigurationsOperations
from .operations import AdminRuleCollectionsOperations
from .operations import AdminRulesOperations
from .operations import NetworkSecurityPerimetersOperations
from .operations import PerimeterAssociableResourceTypesOperations
from . import models


class NetworkManagementClient(object):
    """Network Client.

    :ivar network_managers: NetworkManagersOperations operations
    :vartype network_managers: azure.mgmt.network.v2021_02_01_preview.operations.NetworkManagersOperations
    :ivar network_manager_commits: NetworkManagerCommitsOperations operations
    :vartype network_manager_commits: azure.mgmt.network.v2021_02_01_preview.operations.NetworkManagerCommitsOperations
    :ivar network_manager_deployment_status: NetworkManagerDeploymentStatusOperations operations
    :vartype network_manager_deployment_status: azure.mgmt.network.v2021_02_01_preview.operations.NetworkManagerDeploymentStatusOperations
    :ivar effective_virtual_networks: EffectiveVirtualNetworksOperations operations
    :vartype effective_virtual_networks: azure.mgmt.network.v2021_02_01_preview.operations.EffectiveVirtualNetworksOperations
    :ivar active_connectivity_configurations: ActiveConnectivityConfigurationsOperations operations
    :vartype active_connectivity_configurations: azure.mgmt.network.v2021_02_01_preview.operations.ActiveConnectivityConfigurationsOperations
    :ivar active_security_admin_rules: ActiveSecurityAdminRulesOperations operations
    :vartype active_security_admin_rules: azure.mgmt.network.v2021_02_01_preview.operations.ActiveSecurityAdminRulesOperations
    :ivar active_security_user_rules: ActiveSecurityUserRulesOperations operations
    :vartype active_security_user_rules: azure.mgmt.network.v2021_02_01_preview.operations.ActiveSecurityUserRulesOperations
    :ivar connectivity_configurations: ConnectivityConfigurationsOperations operations
    :vartype connectivity_configurations: azure.mgmt.network.v2021_02_01_preview.operations.ConnectivityConfigurationsOperations
    :ivar effective_connectivity_configurations: EffectiveConnectivityConfigurationsOperations operations
    :vartype effective_connectivity_configurations: azure.mgmt.network.v2021_02_01_preview.operations.EffectiveConnectivityConfigurationsOperations
    :ivar network_manager_effective_security_admin_rules: NetworkManagerEffectiveSecurityAdminRulesOperations operations
    :vartype network_manager_effective_security_admin_rules: azure.mgmt.network.v2021_02_01_preview.operations.NetworkManagerEffectiveSecurityAdminRulesOperations
    :ivar network_groups: NetworkGroupsOperations operations
    :vartype network_groups: azure.mgmt.network.v2021_02_01_preview.operations.NetworkGroupsOperations
    :ivar security_user_configurations: SecurityUserConfigurationsOperations operations
    :vartype security_user_configurations: azure.mgmt.network.v2021_02_01_preview.operations.SecurityUserConfigurationsOperations
    :ivar user_rule_collections: UserRuleCollectionsOperations operations
    :vartype user_rule_collections: azure.mgmt.network.v2021_02_01_preview.operations.UserRuleCollectionsOperations
    :ivar user_rules: UserRulesOperations operations
    :vartype user_rules: azure.mgmt.network.v2021_02_01_preview.operations.UserRulesOperations
    :ivar security_admin_configurations: SecurityAdminConfigurationsOperations operations
    :vartype security_admin_configurations: azure.mgmt.network.v2021_02_01_preview.operations.SecurityAdminConfigurationsOperations
    :ivar admin_rule_collections: AdminRuleCollectionsOperations operations
    :vartype admin_rule_collections: azure.mgmt.network.v2021_02_01_preview.operations.AdminRuleCollectionsOperations
    :ivar admin_rules: AdminRulesOperations operations
    :vartype admin_rules: azure.mgmt.network.v2021_02_01_preview.operations.AdminRulesOperations
    :ivar network_security_perimeters: NetworkSecurityPerimetersOperations operations
    :vartype network_security_perimeters: azure.mgmt.network.v2021_02_01_preview.operations.NetworkSecurityPerimetersOperations
    :ivar perimeter_associable_resource_types: PerimeterAssociableResourceTypesOperations operations
    :vartype perimeter_associable_resource_types: azure.mgmt.network.v2021_02_01_preview.operations.PerimeterAssociableResourceTypesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = NetworkManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.network_managers = NetworkManagersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.network_manager_commits = NetworkManagerCommitsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.network_manager_deployment_status = NetworkManagerDeploymentStatusOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.effective_virtual_networks = EffectiveVirtualNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.active_connectivity_configurations = ActiveConnectivityConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.active_security_admin_rules = ActiveSecurityAdminRulesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.active_security_user_rules = ActiveSecurityUserRulesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.connectivity_configurations = ConnectivityConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.effective_connectivity_configurations = EffectiveConnectivityConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.network_manager_effective_security_admin_rules = NetworkManagerEffectiveSecurityAdminRulesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.network_groups = NetworkGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.security_user_configurations = SecurityUserConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.user_rule_collections = UserRuleCollectionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.user_rules = UserRulesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.security_admin_configurations = SecurityAdminConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.admin_rule_collections = AdminRuleCollectionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.admin_rules = AdminRulesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.network_security_perimeters = NetworkSecurityPerimetersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.perimeter_associable_resource_types = PerimeterAssociableResourceTypesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, http_request, **kwargs):
        # type: (HttpRequest, Any) -> HttpResponse
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.HttpResponse
        """
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
        }
        http_request.url = self._client.format_url(http_request.url, **path_format_arguments)
        stream = kwargs.pop("stream", True)
        pipeline_response = self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> NetworkManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
