   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.24  05/17/06            */
   /*                                                     */
   /*      CONFLICT RESOLUTION STRATEGY HEADER MODULE     */
   /*******************************************************/

/*************************************************************/
/* Purpose: Used to determine where a new activation is      */
/*   placed on the agenda based on the current conflict      */
/*   resolution strategy (depth, breadth, mea, lex,          */
/*   simplicity, or complexity). Also provides the           */
/*   set-strategy and get-strategy commands.                 */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*      6.23: Corrected compilation errors for files         */
/*            generated by constructs-to-c. DR0861           */
/*                                                           */
/*      6.24: Removed CONFLICT_RESOLUTION_STRATEGIES         */
/*            compilation flag.                              */
/*                                                           */
/*************************************************************/

#ifndef _H_crstrtgy

#define _H_crstrtgy

#include "agenda.h"
#include "symbol.h"

#define DEPTH_STRATEGY 0
#define BREADTH_STRATEGY 1
#define LEX_STRATEGY 2
#define MEA_STRATEGY 3
#define COMPLEXITY_STRATEGY 4
#define SIMPLICITY_STRATEGY 5
#define RANDOM_STRATEGY 6

#define DEFAULT_STRATEGY DEPTH_STRATEGY

#ifdef LOCALE
#undef LOCALE
#endif

#ifdef _CRSTRTGY_SOURCE_
#define LOCALE
#else
#define LOCALE extern
#endif

#if ENVIRONMENT_API_ONLY
#define GetStrategy(theEnv) EnvGetStrategy(theEnv)
#define SetStrategy(theEnv,a) EnvSetStrategy(theEnv,a)
#else
#define GetStrategy() EnvGetStrategy(GetCurrentEnvironment())
#define SetStrategy(a) EnvSetStrategy(GetCurrentEnvironment(),a)
#endif

   LOCALE void                           PlaceActivation(void *,ACTIVATION **,ACTIVATION *);
   LOCALE int                            EnvSetStrategy(void *,int);
   LOCALE int                            EnvGetStrategy(void *);
   LOCALE void                          *SetStrategyCommand(void *);
   LOCALE void                          *GetStrategyCommand(void *);

#endif



