# Samples by API

## ![](http://www.google.com/images/icons/product/doubleclick-32.gif) Ad Exchange Buyer API

Lets you manage your Ad Exchange Buyer account.

Documentation for the Ad Exchange Buyer API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/adexchangebuyer/v1.3/python/latest/).

<table>
  <tr>
    <td><a href="adexchangebuyer">samples/adexchangebuyer</a></td>
    <td>Samples for working with the Ad Exchange Buyer API</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/adsense-32.png) AdSense Management API

Gives AdSense publishers access to their inventory and the ability to generate
reports.

Documentation for the AdSense Management API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/adsense/v1.3/python/latest/).

<table>
  <tr>
    <td><a href="adsense">samples/adsense</a></td>
    <td>Collection of command-line samples for the AdSense Management API</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/analytics-32.png) Google Analytics API

View and manage your Google Analytics data.

Documentation for the Google Analytics API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/analytics/v3/python/latest/).

<table>
  <tr>
    <td><a href="analytics">samples/analytics</a></td>
    <td>Command-line samples for producing reports with the Analytics API</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/search-32.gif) Enterprise Audit API

Lets you access user activities in your enterprise made through various
applications.

Documentation for the Enterprise Audit API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/audit/v1/python/latest/).

<table>
  <tr>
    <td><a href="audit">samples/audit</a></td>
    <td>Prints the activities for a domain using the Audit API</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/blogger-32.png) Blogger API

API for access to the data within Blogger.

Documentation for the Blogger API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/blogger/v3/python/latest/).

<table>
  <tr>
    <td><a href="blogger">samples/blogger</a></td>
    <td>Retrieve the list of blogs and their posts for a user</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/search-32.gif) Google Maps Coordinate API

Lets you view and manage jobs in a Coordinate team.

Documentation for the Google Maps Coordinate API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/coordinate/v1/python/latest/).

<table>
  <tr>
    <td><a href="coordinate">samples/coordinate</a></td>
    <td>Demonstrates how to use the Google Coordinate API</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/search-32.gif) CustomSearch API

Lets you search over a website or collection of websites.

Documentation for the CustomSearch API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/customsearch/v1/python/latest/).

<table>
  <tr>
    <td><a href="customsearch">samples/customsearch</a></td>
    <td>Search from the command-line</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/feature/filing_cabinet_search-g32.png) APIs Discovery Service

Lets you discover information about other Google APIs, such as what APIs are
available, the resource and method details for each API.

Documentation for the APIs Discovery Service in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/discovery/v1/python/latest/).

<table>
  <tr>
    <td><a href="api-python-client-doc">samples/api-python-client-doc</a></td>
    <td>
    Application serving up the Python help documentation for each API
    (see <a href="http://api-python-client-doc.appspot.com/">here</a>)
    </td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/search-32.gif) Groups Settings API

Lets you manage permission levels and related settings of a group.

Documentation for the Groups Settings API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/groupssettings/v1/python/latest/).

<table>
  <tr>
    <td><a href="groupssettings">samples/groupssettings</a></td>
    <td>Sample for the Groups Settings API</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/gplus-32.png) Google+ API

The Google+ API enables developers to build on top of the Google+ platform.

Documentation for the Google+ API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/plus/v1/python/latest/).

<table>
  <tr>
    <td><a href="appengine">samples/appengine</a></td>
    <td>Demonstrates the people API and OAuth 2.0 decorator for Google App
    Engine applications</td>
  </tr>
  <tr>
    <td><a href="plus">samples/plus</a></td>
    <td>Loop over all a user's activities and print a short snippet</td>
  </tr>
  <tr>
    <td><a href="django_sample">samples/django_sample</a></td>
    <td>Demonstrates oauth2client and the Google+ API from Django</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/feature/predictionapi-32.png) Prediction API

Lets you access a cloud hosted machine learning service that makes it easy to
build smart apps

Documentation for the Prediction API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/prediction/v1.6/python/latest/).

<table>
  <tr>
    <td><a href="prediction">samples/prediction</a></td>
    <td>Command-line application that trains on your input data</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/search-32.gif) Search Console API

Add sites to a Search Console account, retrieve site data and diagnostics, and submit sitemaps.

Documentation for the Search Console API in
[Google Developers](https://developers.google.com/webmaster-tools/v3/).

<table>
  <tr>
    <td><a href="searchconsole">samples/searchconsole</a></td>
    <td>Command-line samples for Search Console API (formerly known as Webmaster Tools API)</td>
  </tr>
</table>


## ![](http://www.google.com/images/icons/product/search-32.gif) Search API For Shopping

Lets you search over product data.

Documentation for the Search API For Shopping in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/shopping/v1/python/latest/).

<table>
  <tr>
    <td><a href="searchforshopping">samples/searchforshopping</a></td>
    <td>Demonstrates the query capabilities for the Search API for Shopping</td>
  </tr>
</table>

## ![](https://www.google.com/images/icons/product/cloud_storage-32.png) Cloud Storage API

Lets you store and retrieve potentially-large, immutable data objects.

Documentation for the Cloud Storage API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/storage/v1beta2/python/latest/).

<table>
  <tr>
    <td><a href="storage">samples/storage</a></td>
    <td>Uploads and downloads files between Google Cloud Storage and the local
    filesystem using the Google APIs Python Client Library</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/tasks-32.png) Tasks API

Lets you manage your tasks and task lists.

Documentation for the Tasks API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/tasks/v1/python/latest/).

<table>
  <tr>
    <td><a href="tasks_appengine">samples/tasks_appengine</a></td>
    <td>Sample code for the guide
    <a href="https://cloud.google.com/appengine/articles/python/getting_started_with_tasks_api">
    Getting Started with Google Tasks API</a></td>
  </tr>
  <tr>
    <td><a href="service_account">samples/service_account</a></td>
    <td>Demonstrates working with service accounts</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/translate-32.png) Translate API

Lets you translate text from one language to another.

Documentation for the Translate API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/translate/v2/python/latest/).

<table>
  <tr>
    <td><a href="translate">samples/translate</a></td>
    <td>Demonstrates the Translate API</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/search-32.gif) URL Shortener API

Lets you create, inspect, and manage `goo.gl` short URLs.

Documentation for the URL Shortener API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/urlshortener/v1/python/latest/).

<table>
  <tr>
    <td><a href="urlshortener">samples/urlshortener</a></td>
    <td>Shortens a URL with the URL Shortener API</td>
  </tr>
</table>

## ![](http://www.google.com/images/icons/product/youtube-32.png) YouTube Data API

Programmatic access to YouTube features.

Documentation for the YouTube Data API in
[PyDoc](https://google-api-client-libraries.appspot.com/documentation/youtube/v3/python/latest/).

<table>
  <tr>
    <td><a href="youtube">samples/youtube</a></td>
    <td>Demonstrates YouTube APIs</td>
  </tr>
</table>

# Pagination Samples

<table>
  <tr>
    <td><a href="plus">samples/plus</a></td>
    <td>Loop over all a user's activities and print a short snippet</td>
  </tr>
</table>

# OAuth 2.0 Samples

<table>
  <tr>
    <td><a href="appengine">samples/appengine</a></td>
    <td>Demonstrates the people API and OAuth 2.0 decorator for Google App
    Engine applications</td>
  </tr>
  <tr>
    <td><a href="django_sample">samples/django_sample</a></td>
    <td>Demonstrates oauth2client and the Google+ API from Django</td>
  </tr>
  <tr>
    <td><a href="service_account">samples/service_account</a></td>
    <td>Demonstrates working with service accounts</td>
  </tr>
</table>

# Media Upload and Download Samples

<table>
  <tr>
    <td><a href="storage">samples/storage</a></td>
    <td>Uploads and downloads files between Google Cloud Storage and the local
    filesystem using the Google APIs Python Client Library</td>
  </tr>
  <tr>
    <td><a href="youtube">samples/youtube</a></td>
    <td>Demonstrates YouTube APIs</td>
  </tr>
</table>

# Django Samples

<table>
  <tr>
    <td><a href="django_sample">samples/django_sample</a></td>
    <td>Demonstrates oauth2client and the Google+ API from Django</td>
  </tr>
</table>

# Command-line Samples

<table>
  <tr>
    <td><a href="adexchangebuyer">samples/adexchangebuyer</a></td>
    <td>Samples for working with the Ad Exchange Buyer API</td>
  </tr>
  <tr>
    <td><a href="adsense">samples/adsense</a></td>
    <td>Collection of command-line samples for the AdSense Management API</td>
  </tr>
  <tr>
    <td><a href="analytics">samples/analytics</a></td>
    <td>Command-line samples for producing reports with the Analytics API</td>
  </tr>
  <tr>
    <td><a href="audit">samples/audit</a></td>
    <td>Prints the activities for a domain using the Audit API</td>
  </tr>
  <tr>
    <td><a href="blogger">samples/blogger</a></td>
    <td>Retrieve the list of blogs and their posts for a user</td>
  </tr>
  <tr>
    <td><a href="coordinate">samples/coordinate</a></td>
    <td>Demonstrates how to use the Google Coordinate API</td>
  </tr>
  <tr>
    <td><a href="customsearch">samples/customsearch</a></td>
    <td>Search from the command-line</td>
  </tr>
  <tr>
    <td><a href="groupsettings">samples/groupsettings</a></td>
    <td>Sample for the Groups Settings API</td>
  </tr>
  <tr>
    <td><a href="plus">samples/plus</a></td>
    <td>Loop over all a user's activities and print a short snippet</td>
  </tr>
  <tr>
    <td><a href="prediction">samples/prediction</a></td>
    <td>Command-line application that trains on your input data</td>
  </tr>
  <tr>
    <td><a href="searchforshopping">samples/searchforshopping</a></td>
    <td>Demonstrates the query capabilities for the Search API for Shopping</td>
  </tr>
  <tr>
    <td><a href="storage">samples/storage</a></td>
    <td>Uploads and downloads files between Google Cloud Storage and the local
    filesystem using the Google APIs Python Client Library</td>
  </tr>
  <tr>
    <td><a href="translate">samples/translate</a></td>
    <td>Demonstrates the Translate API</td>
  </tr>
  <tr>
    <td><a href="urlshortener">samples/urlshortener</a></td>
    <td>Shortens a URL with the URL Shortener API</td>
  </tr>
  <tr>
    <td><a href="youtube">samples/youtube</a></td>
    <td>Demonstrates YouTube APIs</td>
  </tr>
</table>

# Google App Engine Samples

<table>
  <tr>
    <td><a href="api-python-client-doc">samples/api-python-client-doc</a></td>
    <td>
    Application serving up the Python help documentation for each API
    (see <a href="http://api-python-client-doc.appspot.com/">here</a>)
    </td>
  </tr>
  <tr>
    <td><a href="appengine">samples/appengine</a></td>
    <td>Demonstrates the people API and OAuth 2.0 decorator for Google App
    Engine applications</td>
  </tr>
  <tr>
    <td><a href="tasks_appengine">samples/tasks_appengine</a></td>
    <td>Sample code for the guide
    <a href="https://cloud.google.com/appengine/articles/python/getting_started_with_tasks_api">
    Getting Started with Google Tasks API</a></td>
  </tr>
</table>

