from __future__ import with_statement
import os.path

MODULE_TEMPLATE=""".. Autogenerated by genmods.py

******************************************************************************
%(name)s
******************************************************************************

:mod:`%(package)s.%(module)s`
==============================================================================

.. automodule:: %(package)s.%(module)s
   :members:
   :undoc-members:
   :inherited-members:
   :show-inheritance:

"""

INDEX_TEMPLATE=""".. Autogenerated by genmods.py

.. _api-index:

##############################################################################
   %(package_name)s
##############################################################################

.. only:: html

   :Release: |version|
   :Date: |today|

.. toctree::

   %(rsts)s
"""


def genfiles(package, package_name, modules, dir='api'):

    if not os.path.exists(dir):
        os.makedirs(dir)

    for module,name in modules:
        with open(os.path.join(dir,module+'.rst'), 'w') as f:
            f.write(MODULE_TEMPLATE%locals())

    rsts = "\n   ".join(module+'.rst' for module,name in modules)
    with open(os.path.join(dir,'index.rst'),'w') as f:
        f.write(INDEX_TEMPLATE%locals())


modules=[
    #('__init__', 'Top level namespace'),
    ('core', 'Core table'),
    ('formulas', 'Chemical formula operations'),
    #('chemicals', 'Chemical database'),
    ('covalent_radius', 'Covalent radius'),
    ('constants', 'Fundamental constants'),
    ('crystal_structure', 'Crystal structure'),
    ('density', 'Density'),
    ('fasta', 'FASTA format for DNA/RNA and amino acid sequences'),
    ('magnetic_ff', 'Magnetic Form Factor'),
    ('mass', 'Mass'),
    ('activation', 'Neutron activation'),
    ('nsf', 'Neutron scattering potentials'),
    ('xsf', 'X-ray scattering potentials'),
    ('cromermann', 'X-ray scattering factor f0 calculations'),
    ('plot', 'Element plotter'),
    ('util', 'Utility functions'),
]
package='periodictable'
package_name='Reference'
genfiles(package, package_name, modules)
