import re
from collections.abc import Generator as Generator
from typing import (
    Any,
    Callable,
    ClassVar,
    Dict,
    Generic,
    Iterable,
    List,
    Match,
    MutableMapping,
    Optional,
    Pattern,
    Type,
    TypeVar,
    Union,
)

from typing_extensions import Self

class BlockState:
    src: str
    tokens: List[Dict[str, Any]]
    cursor: int
    cursor_max: int
    list_tight: bool
    parent: Any
    env: MutableMapping[str, Any]
    def __init__(self, parent: Optional[Any] = None) -> None: ...
    def child_state(self, src: str) -> BlockState: ...
    def process(self, src: str) -> None: ...
    def find_line_end(self) -> int: ...
    def get_text(self, end_pos: int) -> str: ...
    def last_token(self) -> Any: ...
    def prepend_token(self, token: Dict[str, Any]) -> None: ...
    def append_token(self, token: Dict[str, Any]) -> None: ...
    def add_paragraph(self, text: str) -> None: ...
    def append_paragraph(self) -> Optional[int]: ...
    def depth(self) -> int: ...

class InlineState:
    env: MutableMapping[str, Any]
    src: str
    tokens: List[Dict[str, Any]]
    in_image: bool
    in_link: bool
    in_emphasis: bool
    in_strong: bool
    def __init__(self, env: MutableMapping[str, Any]) -> None: ...
    def prepend_token(self, token: Dict[str, Any]) -> None: ...
    def append_token(self, token: Dict[str, Any]) -> None: ...
    def copy(self) -> InlineState: ...

ST = TypeVar("ST", InlineState, BlockState)

class Parser(Generic[ST]):
    sc_flag: re._FlagsType
    state_cls: Type[ST]
    SPECIFICATION: ClassVar[Dict[str, str]]
    DEFAULT_RULES: ClassVar[Iterable[str]]
    specification: Dict[str, str]
    rules: Iterable[str]
    def __init__(self) -> None: ...
    def compile_sc(self, rules: Optional[List[str]] = None) -> Pattern[str]: ...
    def register(
        self,
        name: str,
        pattern: Union[str, None],
        func: Callable[[Self, Match[str], ST], Optional[int]],
        before: Optional[str] = None,
    ) -> None: ...
    def register_rule(self, name: str, pattern: str, func: Any) -> None: ...
    @staticmethod
    def insert_rule(rules: List[str], name: str, before: Optional[str] = None) -> None: ...
    def parse_method(self, m: Match[str], state: ST) -> Optional[int]: ...

class BaseRenderer:
    NAME: ClassVar[str]
    def __init__(self) -> None: ...
    def register(self, name: str, method: Callable[..., str]) -> None: ...
    def render_token(self, token: Dict[str, Any], state: BlockState) -> str: ...
    def iter_tokens(self, tokens: Iterable[Dict[str, Any]], state: BlockState) -> Iterable[str]: ...
    def render_tokens(self, tokens: Iterable[Dict[str, Any]], state: BlockState) -> str: ...
    def __call__(self, tokens: Iterable[Dict[str, Any]], state: BlockState) -> str: ...
