# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class TemplateTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.verify.v2.templates.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://verify.twilio.com/v2/Templates',
        ))

    def test_list_verification_templates_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "templates": [
                    {
                        "sid": "HJaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "friendly_name": "Friendly Template",
                        "translations": {
                            "en": {
                                "text": "Hello, your code is {code}.",
                                "locale": "en",
                                "status": "approved",
                                "date_created": "2021-07-26T22:30:13.003505841Z",
                                "date_updated": "2021-07-26T22:31:08.750971289Z"
                            }
                        }
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://verify.twilio.com/v2/Templates?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://verify.twilio.com/v2/Templates?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "templates"
                }
            }
            '''
        ))

        actual = self.client.verify.v2.templates.list()

        self.assertIsNotNone(actual)
