% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfc3339.R
\name{Rfc3339}
\alias{Rfc3339}
\alias{as.Rfc3339}
\alias{as.Rfc3339.character}
\alias{as.Rfc3339.default}
\alias{as.Rfc3339.POSIXt}
\alias{as.character.Rfc3339}
\alias{is.Rfc3339}
\alias{as.POSIXct.Rfc3339}
\alias{as.POSIXlt.Rfc3339}
\alias{[.Rfc3339}
\alias{[[.Rfc3339}
\alias{[<-.Rfc3339}
\alias{[[<-.Rfc3339}
\alias{c.Rfc3339}
\alias{saveObject,Rfc3339-method}
\title{Representing Internet date/times}
\usage{
as.Rfc3339(x)

\method{as.Rfc3339}{character}(x)

\method{as.Rfc3339}{default}(x)

\method{as.Rfc3339}{POSIXt}(x)

\method{as.character}{Rfc3339}(x, ...)

is.Rfc3339(x)

\method{as.POSIXct}{Rfc3339}(x, tz = "", ...)

\method{as.POSIXlt}{Rfc3339}(x, tz = "", ...)

\method{[}{Rfc3339}(x, i)

\method{[[}{Rfc3339}(x, i)

\method{[}{Rfc3339}(x, i) <- value

\method{[[}{Rfc3339}(x, i) <- value

\method{c}{Rfc3339}(..., recursive = TRUE)

\S4method{saveObject}{Rfc3339}(x, path, ...)
}
\arguments{
\item{x}{For \code{as.Rfc3339} methods, object to be coerced to an Rfc3339 instance.

For the subset and combining methods, an Rfc3339 instance.

For \code{as.character}, \code{as.POSIXlt} and \code{as.POSIXct} methods, an Rfc3339 instance.

For \code{is.Rfc3339}, any object to be tested for Rfc3339-ness.}

\item{tz, recursive, ...}{Further arguments to be passed to individual methods.}

\item{i}{Indices specifying elements to extract or replace.}

\item{value}{Replacement values, either as another Rfc3339 instance, a character vector or something that can be coerced into one.}

\item{path}{String containing the path to a directory in which to save \code{x}.}
}
\value{
For \code{as.Rfc3339}, the subset and combining methods, an Rfc3339 instance is returned.

For the other \code{as.*} methods, an instance of the corresponding type generated from an Rfc3339 instance.
}
\description{
The Rfc3339 class is a character vector that stores Internet Date/time timestamps, formatted as described in RFC3339.
It provides a faithful representation of any RFC3339-compliant string in an R session.
}
\details{
This class is motivated by the difficulty in using the various \link{POSIXt} classes to faithfully represent any RFC3339-compliant string.
In particular:
\itemize{
\item The POSIXt classes do not automatically capture the string's timezone offset, instead converting all times to the local timezone.
This is problematic as it discards information about the original timezone.
Technically, the \link{POSIXlt} class is capable of holding this information in the \code{gmtoff} field but it is not clear how to set this.
\item There is no way to distinguish between the timezones \code{Z} and \code{+00:00}.
These are functionally the same but will introduce differences in the checksums of saved files
and thus interfere with deduplication mechanisms in storage backends.
\item Coercion of POSIXt classes to strings may print more or fewer digits in the fractional seconds than what was present in the original string.
Functionally, this is probably unimportant but will still introduce differences in the checksums.
}

By comparison, the Rfc3339 class preserves all information in the original string,
avoiding unexpected modifications from a roundtrip through \code{\link{readObject}} and \code{\link{saveObject}}.
This is especially relevant for strings that were created from other languages, 
e.g., Node.js Date's ISO string conversion uses \code{Z} by default.

That said, users should not expect too much from this class.
It is only used to provide a faithful representation of RFC3339 strings, and does not support any time-related arithmetic.
Users are advised to convert to \link{POSIXct} or similar if such operations are required.
}
\examples{
out <- as.Rfc3339(Sys.time() + 1:10)
out

out[2:5]
out[2] <- "2"
c(out, out)

as.character(out)
as.POSIXct(out)
}
\author{
Aaron Lun
}
