% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSeqinfo.R
\name{readSeqinfo}
\alias{readSeqinfo}
\alias{loadSeqinfo}
\title{Read a Seqinfo from disk}
\usage{
readSeqinfo(path, metadata, ...)
}
\arguments{
\item{path}{String containing a path to a directory, itself created with the \code{\link{saveObject}} method for Seqinfo objects.}

\item{metadata}{Named list of metadata for this object, see \code{\link{readObjectFile}} for details.}

\item{...}{Further arguments, ignored.}
}
\value{
A \linkS4class{Seqinfo} object.
}
\description{
Read a \linkS4class{Seqinfo} object from its on-disk representation.
This is usually not directly called by users, but is instead called by dispatch in \code{\link{readObject}}.
}
\examples{
si <- Seqinfo(c("chrA", "chrB"), c(1000, 2000))

tmp <- tempfile()
saveObject(si, tmp)
readObject(tmp)

}
\seealso{
\code{"\link{saveObject,Seqinfo-method}"} for the corresponding saving method.
}
