% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colAnyNAs.R, R/rowAnyNAs.R
\name{colAnyNAs,DelayedMatrix-method}
\alias{colAnyNAs,DelayedMatrix-method}
\alias{rowAnyNAs,DelayedMatrix-method}
\title{Check if any elements in a row (column) of a matrix-like object is missing}
\usage{
\S4method{colAnyNAs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowAnyNAs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
Returns a \code{\link{logical}} \code{\link{vector}} of length N (K).
}
\description{
Check if any elements in a row (column) of a matrix-like object is missing.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowAnyNAs}} /
\code{matrixStats::\link[matrixStats]{colAnyNAs}}.
}
\examples{
# A DelayedMatrix with a 'matrix' seed
dm_matrix <- DelayedArray(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))
# A DelayedMatrix with a 'HDF5ArraySeed' seed
# NOTE: Requires that the HDF5Array package is installed
library(HDF5Array)
dm_HDF5 <- writeHDF5Array(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))

dm_matrix[dm_matrix > 3] <- NA
colAnyNAs(dm_matrix)
dm_HDF5[dm_HDF5 > 3] <- NA
rowAnyNAs(dm_HDF5)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:anyMissing]{rowAnyNAs}()} and
\code{matrixStats::\link[matrixStats:anyMissing]{colAnyNAs}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For checks if any element is equal to a value, see
\code{\link[MatrixGenerics]{rowAnys}()}.
\item \code{base::\link{is.na}()} and \code{base::\link{any}()}.
}
}
\author{
Peter Hickey
}
