% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSEA.R
\name{plotEnrichment}
\alias{plotEnrichment}
\title{Plot output of Feature Set Enrichment Analysis}
\usage{
plotEnrichment(object, fsea.results, factor, alpha = 0.1,
  max.pathways = 25, adjust = TRUE)
}
\arguments{
\item{object}{\code{\link{MOFAmodel}} object on which FSEA was performed}

\item{fsea.results}{output of \link{runEnrichmentAnalysis} function}

\item{factor}{string with factor name or numeric with factor index}

\item{alpha}{p.value threshold to filter out feature sets}

\item{max.pathways}{maximum number of enriched pathways to display}

\item{adjust}{use adjusted p-values?}
}
\value{
a \code{ggplot2} object
}
\description{
Method to plot the results of the Feature Set Enrichment Analyisis (FSEA)
}
\examples{
# Example on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFAobject <- loadModel(filepath)

# perform Enrichment Analysis on mRNA data using pre-build Reactome gene sets
data("reactomeGS", package = "MOFAdata")
fsea.results <- runEnrichmentAnalysis(MOFAobject, view="mRNA", feature.sets=reactomeGS)

# Plot top 10 enriched pathwyas on factor 5:
plotEnrichment(MOFAobject, fsea.results, factor=5,  max.pathways=10)
}
