% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MOFAmodel}
\alias{MOFAmodel}
\alias{MOFAmodel-class}
\title{Class to store a Multi-Omics Factor Analysis (MOFA) model}
\description{
The \code{MOFAmodel} is an S4 class used to store all
 relevant data to analyse a MOFA model.
}
\section{Slots}{

\describe{
\item{\code{InputData}}{the input data before being parsed to Training Data. 
Either a MultiAssayExperiment object or a list of matrices, one per view.}

\item{\code{TrainData}}{the parsed data used to fit the MOFA model
A list with one matrix per view.}

\item{\code{ImputedData}}{the parsed data with the missing
values imputed using the MOFA model. 
  A list with one matrix per view.}

\item{\code{Expectations}}{expected values of the different
variables of the model. A list of matrices, one per variable.
 The most relevant are "W" for weights and "Z" for factors.}

\item{\code{TrainStats}}{list with training statistics such as evidence lower bound (ELBO),
number of active factors, etc.}

\item{\code{DataOptions}}{list with the data processing options such as
whether to center or scale the data.}

\item{\code{TrainOptions}}{list with the training options such as
maximum number of iterations, tolerance for convergence, etc.}

\item{\code{ModelOptions}}{list with the model options such as
likelihoods, number of factors, etc.}

\item{\code{FeatureIntercepts}}{list with the feature-wise intercepts. 
Only used internally.}

\item{\code{Dimensions}}{list with the relevant dimensionalities of the model.
N for the number of samples, M for the number of views, 
D for the number of features of each view and K for the number of infered latent factors.}

\item{\code{Status}}{Auxiliary variable indicating whether the model has been trained.}
}}

