% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_signatures.R
\name{extract_signatures}
\alias{extract_signatures}
\title{Extract mutational signatures from 96 mutation matrix using NMF}
\usage{
extract_signatures(
  mut_matrix,
  rank,
  nrun = 200,
  nmf_type = c("regular", "variational_bayes"),
  single_core = FALSE,
  fudge = NULL
)
}
\arguments{
\item{mut_matrix}{96 mutation count matrix}

\item{rank}{Number of signatures to extract}

\item{nrun}{Number of iterations, default = 200.
A lower number will be faster, but result in less accurate results.}

\item{nmf_type}{Type of NMF to be used.
             Possible values:
             * 'regular'
             * 'variational_bayes'
The 'regular' method comes from the NMF package.
The 'variational_bayes' method comes from the ccfindR package.
This method uses bayesian inference, which makes it easier to determine the
mathematically optimal number of signatures.}

\item{single_core}{Boolean. If TRUE, it forces the NMF algorithm to
use only a single core. This can sometimes prevent issues.
Doesn't apply to variational-bayes NMF}

\item{fudge}{Small positive number that is used for the variational_bayes NMF.
Setting this to a small value like 0.0001 can prevent errors from occurring,
when extracting many signatures at once. In general, we recommend extracting
less signatures when errors occur, but this parameter can be used when that
is not an option.
Default = NULL.}
}
\value{
Named list of mutation matrix, signatures and signature contribution
}
\description{
Decomposes trinucleotide count matrix into signatures and contribution of
those signatures to the spectra of the samples/vcf files.
}
\examples{
## See the 'mut_matrix()' example for how we obtained the mutation matrix:
mut_mat <- readRDS(system.file("states/mut_mat_data.rds",
  package = "MutationalPatterns"
))

## This function is computationally intensive.
# nmf_res <- extract_signatures(mut_mat, rank = 2)

## It's also possible to use a variational Bayes method.
## It requires the ccfindR package to work.
# nmf_res <- extract_signatures(mut_mat, rank = 2, nmf_type = "variational_bayes")
}
\seealso{
\code{\link{mut_matrix}}
}
