% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation.R
\name{TCGAanalyze_DMC}
\alias{TCGAanalyze_DMC}
\title{Differentially methylated regions Analysis}
\usage{
TCGAanalyze_DMC(
  data,
  groupCol = NULL,
  group1 = NULL,
  group2 = NULL,
  alternative = "two.sided",
  diffmean.cut = 0.2,
  paired = FALSE,
  adj.method = "BH",
  plot.filename = "methylation_volcano.pdf",
  ylab = expression(paste(-Log[10], " (FDR corrected P-values)")),
  xlab = expression(paste("DNA Methylation difference (", beta, "-values)")),
  title = NULL,
  legend = "Legend",
  color = c("black", "red", "darkgreen"),
  label = NULL,
  xlim = NULL,
  ylim = NULL,
  p.cut = 0.01,
  probe.names = FALSE,
  cores = 1,
  save = TRUE,
  save.directory = ".",
  filename = NULL
)
}
\arguments{
\item{data}{SummarizedExperiment obtained from the TCGAPrepare}

\item{groupCol}{Columns with the groups inside the SummarizedExperiment
object. (This will be obtained by the function colData(data))}

\item{group1}{In case our object has more than 2 groups, you should set
the name of the group}

\item{group2}{In case our object has more than 2 groups, you should set
the name of the group}

\item{alternative}{wilcoxon test alternative}

\item{diffmean.cut}{diffmean threshold. Default: 0.2}

\item{paired}{Wilcoxon paired parameter. Default: FALSE}

\item{adj.method}{Adjusted method for the p-value calculation}

\item{plot.filename}{Filename. Default: volcano.pdf, volcano.svg, volcano.png. If set to FALSE, there will be no plot.}

\item{ylab}{y axis text}

\item{xlab}{x axis text}

\item{title}{main title. If not specified it will be
"Volcano plot (group1 vs group2)}

\item{legend}{Legend title}

\item{color}{vector of colors to be used in graph}

\item{label}{vector of labels to be used in the figure.
Example: c("Not Significant","Hypermethylated in group1",
"Hypomethylated in group1"))}

\item{xlim}{x limits to cut image}

\item{ylim}{y limits to cut image}

\item{p.cut}{p values threshold. Default: 0.01}

\item{probe.names}{is probe.names}

\item{cores}{Number of cores to be used in the non-parametric test
Default = groupCol.group1.group2.rda}

\item{save}{Save object with results? Default: TRUE}

\item{save.directory}{Directory to save the files. Default: working directory}

\item{filename}{Name of the file to save the object.}
}
\value{
Volcano plot saved and the given data with the results
(diffmean.group1.group2,p.value.group1.group2,
p.value.adj.group1.group2,status.group1.group2)
in the rowRanges where group1 and group2 are the names of the groups
}
\description{
This function will search for differentially methylated CpG sites,
  which are regarded as possible functional regions involved
  in gene transcriptional regulation.

  In order to find these regions we use the beta-values (methylation values
  ranging from 0.0 to 1.0) to compare two groups.

  Firstly, it calculates the difference between the mean methylation of each
  group for each probes. Secondly, it calculates the p-value using the
  wilcoxon test using the Benjamini-Hochberg adjustment method.
  The default parameters will require a minimum absolute beta values delta
  of 0.2 and a false discovery rate (FDR)-adjusted Wilcoxon rank-sum P-value
  of < 0.01 for the difference.

  After these analysis, we save a volcano plot (x-axis:diff mean methylation,
  y-axis: significance) that will help the user identify the differentially
  methylated CpG sites and return the object with the calculus in the rowRanges.

  If the calculus already exists in the object it will not recalculated.
  You should set overwrite parameter to TRUE to force it, or remove the
  columns with the results from the object.
}
\examples{
nrows <- 200; ncols <- 20
 counts <- matrix(
   runif(nrows * ncols, 1, 1e4), nrows,
   dimnames = list(paste0("cg",1:200),paste0("S",1:20))
)
rowRanges <- GenomicRanges::GRanges(
  rep(c("chr1", "chr2"), c(50, 150)),
  IRanges::IRanges(floor(runif(200, 1e5, 1e6)), width = 100),
  strand = sample(c("+", "-"), 200, TRUE),
  feature_id = sprintf("ID\%03d", 1:200)
)
names(rowRanges) <-  paste0("cg",1:200)
colData <- S4Vectors::DataFrame(
  Treatment = rep(c("ChIP", "Input"), 5),
  row.names = paste0("S",1:20),
  group = rep(c("group1","group2"),c(10,10))
)
data <- SummarizedExperiment::SummarizedExperiment(
         assays=S4Vectors::SimpleList(counts=counts),
         rowRanges = rowRanges,
         colData = colData
)
SummarizedExperiment::colData(data)$group <- c(rep("group 1",ncol(data)/2),
                         rep("group 2",ncol(data)/2))
hypo.hyper <- TCGAanalyze_DMC(data, p.cut = 0.85,"group","group 1","group 2")
SummarizedExperiment::colData(data)$group2 <- c(rep("group_1",ncol(data)/2),
                         rep("group_2",ncol(data)/2))
hypo.hyper <- TCGAanalyze_DMC(
  data = data,
  p.cut = 0.85,
  groupCol = "group2",
  group1 = "group_1",
  group2 = "group_2"
)
}
