\name{stateTransition}
\Rdversion{1.1}
\alias{stateTransition}

\title{
Perform a transition to the next state
}
\description{
Calculates the next state in a supplied network for a given current state
}
\usage{
stateTransition(network,
                state,
                type = c("synchronous","asynchronous","probabilistic"),
                geneProbabilities, 
                chosenGene, 
                chosenFunctions)
}
\arguments{
  \item{network}{
	A network structure of class \code{BooleanNetwork} or \code{ProbabilisticBooleanNetwork}. These networks can be read from files by \code{\link{loadNetwork}}, generated by \if{latex}{\cr}\code{\link{generateRandomNKNetwork}}, or reconstructed by \code{\link{reconstructNetwork}}.
}
  \item{state}{
	The current state of the network, encoded as a vector with one 0-1 element for each gene.
}
  \item{type}{The type of transition to be performed. 
  
  If set to "synchronous", all genes are updated using the corresponding transition functions. 
  
  If set to "asynchronous", only one gene is updated. This gene is either chosen randomly or supplied in parameter \code{chosenGene}. 
  
  If set to "probabilistic", one transition function is chosen for each gene, and the genes are updated synchronously. The functions are either chosen randomly depending on their probabilities, or they are supplied in parameter \code{chosenFunctions}.
    
  Default is "synchronous" for objects of class \code{BooleanNetwork} and "probabilistic" for objects of class \code{ProbabilisticBooleanNetwork}.}
  
  \item{geneProbabilities}{An optional vector of probabilities for the genes if \code{type="asynchronous"}. By default, each gene has the same probability to be chosen for the next state transition. These probabilities can be modified by supplying a vector of probabilities for the genes which sums up to one.}
  
  \item{chosenGene}{If \code{type="asynchronous"} and this parameter is supplied, no random update is performed. Instead, the gene with the supplied name or index is chosen for the next transition.}
  
  \item{chosenFunctions}{If \code{type="probabilistic"}, this parameter can contain a set of function indices for each gene. In this case, transition functions are not chosen randomly, but the provided functions are used in the state transition.}
}

\value{
	The subsequent state of the network, encoded as a vector with one 0-1 element for each gene.}
\seealso{
\code{\link{loadNetwork}}, \code{\link{generateRandomNKNetwork}}, \code{\link{generateState}}
}
\examples{
# load example network
data(cellcycle)

# calculate a synchronous state transition
print(stateTransition(cellcycle, c(1,1,1,1,1,1,1,1,1,1)))

# calculate an asynchronous state transition of gene CycA
print(stateTransition(cellcycle, c(1,1,1,1,1,1,1,1,1,1),
                      type="asynchronous", chosenGene="CycA"))
                      
# load probabilistic network
data(examplePBN)

# perform a probabilistic state transition
print(stateTransition(examplePBN, c(0,1,1),
                      type="probabilistic"))       
}
\keyword{state transition
	Boolean network
	synchronous update
	asynchronous update
	probabilistic Boolean network
	PBN
	transition
	state}
