% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-values.R
\name{check_values}
\alias{check_values}
\title{Check Values and Class}
\usage{
check_values(x, values, x_name = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{values}{An atomic vector specifying the S3 class and possible values.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
An informative error if the test fails or an invisible copy of x.
}
\description{
Checks values and S3 class of an atomic object.
}
\details{
To check the class simply pass a vector of the desired class.

To check that x does not include missing values pass
a single non-missing value (of the correct class).

To allow it to include missing values include a missing value.

To check that it only includes missing values only pass
a missing value (of the correct class).

To check the range of the values in x pass two non-missing values
(as well as the missing value if required).

To check that x only includes specific values
pass three or more non-missing values.

In the case of a factor ensure values has two levels to
check that the levels of x are an ordered superset of the levels of value
and three or more levels to check that they are identical.
}
\examples{
check_values(1, numeric(0))
check_values(1, 2)
try(check_values(1, 1L))
try(check_values(NA_real_, 1))
}
\seealso{
Other check: 
\code{\link{check_data}()},
\code{\link{check_dim}()},
\code{\link{check_dirs}()},
\code{\link{check_files}()},
\code{\link{check_key}()},
\code{\link{check_length}()},
\code{\link{check_names}()}
}
\concept{check}
