% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_edge_info.R
\name{get_edge_info}
\alias{get_edge_info}
\title{Get detailed information on edges}
\usage{
get_edge_info(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A data frame containing information specific to each edge within the
graph.
}
\description{
Obtain a data frame with detailed information on edges and their
interrelationships within the graph.
}
\examples{
# Create a simple graph
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 5, m = 10,
    set_seed = 23)

# Get information on the
# graph's edges
graph \%>\% get_edge_info()

}
