% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggally_points}
\alias{ggally_points}
\title{Scatter plot}
\usage{
ggally_points(data, mapping, ...)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{...}{other arguments are sent to geom_point}
}
\description{
Make a scatter plot with a given data set.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

data(mtcars)
p_(ggally_points(mtcars, mapping = ggplot2::aes(disp, hp)))
p_(ggally_points(mtcars, mapping = ggplot2::aes(disp, hp)))
p_(ggally_points(
  mtcars,
  mapping = ggplot2::aes(
    x     = disp,
    y     = hp,
    color = as.factor(cyl),
    size  = gear
  )
))
}
\author{
Barret Schloerke
}
\keyword{hplot}
