% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_legend.R
\name{get_legend}
\alias{get_legend}
\title{Extract Legends from a ggplot object}
\usage{
get_legend(p, position = NULL)
}
\arguments{
\item{p}{an object of class ggplot or a list of ggplots. If p is a list, only the first legend is returned.}

\item{position}{character specifying legend position. Allowed values are one of
c("top", "bottom", "left", "right", "none"). To remove the legend use
legend = "none".}
}
\value{
an object of class gtable.
}
\description{
Extract the legend labels from a ggplot object.
}
\examples{
# Create a scatter plot
p <- ggscatter(iris, x = "Sepal.Length", y = "Sepal.Width",
        color = "Species", palette = "jco",
        ggtheme = theme_minimal())
p

# Extract the legend. Returns a gtable
leg <- get_legend(p)

# Convert to a ggplot and print
as_ggplot(leg)

}
