% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-quasirandom-rast.R
\name{geom_quasirandom_rast}
\alias{geom_quasirandom_rast}
\title{This geom is similar to \code{\link[ggbeeswarm]{geom_quasirandom}}, but creates a raster layer}
\usage{
geom_quasirandom_rast(
  ...,
  width = NULL,
  varwidth = FALSE,
  bandwidth = 0.5,
  nbins = NULL,
  method = "quasirandom",
  groupOnX = NULL,
  dodge.width = 0,
  raster.dpi = getOption("ggrastr.default.dpi", 300),
  dev = "cairo",
  scale = 1
)
}
\arguments{
\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{width}{the maximum amount of spread (default: 0.4)}

\item{varwidth}{vary the width by the relative size of each group}

\item{bandwidth}{the bandwidth adjustment to use when calculating density
Smaller numbers (< 1) produce a tighter "fit". (default: 0.5)}

\item{nbins}{the number of bins used when calculating density
(has little effect with quasirandom/random distribution)}

\item{method}{the method used for distributing points
(quasirandom, pseudorandom, smiley, maxout, frowney, minout, tukey, tukeyDense).
See \code{\link[vipor:offsetX]{vipor::offsetSingleGroup()}} for the details of each method.}

\item{groupOnX}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} No longer needed.}

\item{dodge.width}{Amount by which points from different aesthetic groups
will be dodged. This requires that one of the aesthetics is a factor.}

\item{raster.dpi}{integer Resolution of the rastered image in dots per inch (default=300).}

\item{dev}{string Specifies the device used, which can be one of: \code{"cairo"}, \code{"ragg"} or \code{"ragg_png"} (default="cairo").}

\item{scale}{numeric Scaling factor to modify the raster object size (default=1). The parameter 'scale=1' results in an object size that is unchanged, 'scale'>1 increase the size, and 'scale'<1 decreases the size. These parameters are passed to 'height' and 'width' of grid::grid.raster(). Please refer to 'rasterise()' and 'grid::grid.raster()' for more details.}
}
\value{
geom_quasirandom plot with rasterized layer
}
\description{
This geom is similar to \code{\link[ggbeeswarm]{geom_quasirandom}}, but creates a raster layer
}
\section{Aesthetics}{


\code{geom_point()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{alpha}
\item \code{colour}
\item \code{fill}
\item \code{group}
\item \code{shape}
\item \code{size}
\item \code{stroke}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.

}

\examples{
library(ggplot2)
library(ggrastr)

ggplot(mtcars) + geom_quasirandom_rast(aes(x = factor(cyl), y = mpg), raster.dpi = 600)

}
