% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel.R
\name{excel_new_pal}
\alias{excel_new_pal}
\title{Excel (current versions) color palettes (discrete)}
\usage{
excel_new_pal(theme = "Office Theme")
}
\arguments{
\item{theme}{The name of the Office theme or color theme
(not to be confused with ggplot2 themes) from which to derive the color
palette. Available themes include:
\Sexpr[results=rd]{ggthemes:::rd_optlist(names(ggthemes::ggthemes_data$excel$themes))}}
}
\description{
Color palettes used by current versions of Microsoft Office and Excel.
}
\examples{
library("scales")

for (i in names(ggthemes::ggthemes_data$excel$palettes)) {
  show_col(excel_new_pal(theme = i))(6)
}
}
\seealso{
Other colour excel: \code{\link{excel_pal}},
  \code{\link{scale_colour_excel_new}},
  \code{\link{scale_fill_excel}}
}
\concept{colour excel}
