% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural-properties.R
\name{k_shortest_paths}
\alias{k_shortest_paths}
\title{Find the \eqn{k} shortest paths between two vertices}
\usage{
k_shortest_paths(
  graph,
  from,
  to,
  ...,
  k,
  weights = NULL,
  mode = c("out", "in", "all", "total")
)
}
\arguments{
\item{graph}{The input graph.}

\item{from}{The source vertex of the shortest paths.}

\item{to}{The target vertex of the shortest paths.}

\item{...}{These dots are for future extensions and must be empty.}

\item{k}{The number of paths to find. They will be returned in order of
increasing length.}

\item{weights}{Possibly a numeric vector giving edge weights. If this is
\code{NULL} and the graph has a \code{weight} edge attribute, then the
attribute is used. If this is \code{NA} then no weights are used (even if
the graph has a \code{weight} attribute). In a weighted graph, the length
of a path is the sum of the weights of its constituent edges.}

\item{mode}{Character constant, gives whether the shortest paths to or from
the given vertices should be calculated for directed graphs. If \code{out}
then the shortest paths \emph{from} the vertex, if \verb{in} then \emph{to}
it will be considered. If \code{all}, the default, then the graph is treated
as undirected, i.e. edge directions are not taken into account. This
argument is ignored for undirected graphs.}
}
\value{
A named list with two components is returned:
\describe{
\item{vpaths}{
The list of \eqn{k} shortest paths in terms of vertices
}
\item{epaths}{
The list of \eqn{k} shortest paths in terms of edges
}
}
}
\description{
Finds the \eqn{k} shortest paths between the given source and target
vertex in order of increasing length. Currently this function uses
Yen's algorithm.
}
\references{
Yen, Jin Y.:
An algorithm for finding shortest routes from all source nodes to a given
destination in general networks.
Quarterly of Applied Mathematics. 27 (4): 526–530. (1970)
\doi{10.1090/qam/253822}
}
\seealso{
\code{\link[=shortest_paths]{shortest_paths()}}, \code{\link[=all_shortest_paths]{all_shortest_paths()}}

Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{feedback_vertex_set}()},
\code{\link{girth}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{knn}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\concept{structural.properties}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Structural.html#igraph_get_k_shortest_paths}{\code{get_k_shortest_paths()}}.}

