% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_weights.R
\name{find_weights}
\alias{find_weights}
\title{Find names of model weights}
\usage{
find_weights(x, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}
}
\value{
The name of the weighting variable as character vector, or \code{NULL}
if no weights were specified.
}
\description{
Returns the name of the variable that describes the weights of a
model.
}
\examples{
data(mtcars)
mtcars$weight <- rnorm(nrow(mtcars), 1, .3)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars, weights = weight)
find_weights(m)
}
