% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dshapebivrProp}
\alias{dshapebivrProp}
\title{Bivariate Kernel density estimation for data classified in polygons or shapes}
\usage{
dshapebivrProp(
  data,
  burnin = 2,
  samples = 5,
  adaptive = FALSE,
  shapefile,
  gridsize = 200,
  boundary = FALSE,
  deleteShapes = NULL,
  fastWeights = TRUE,
  numChains = 1,
  numThreads = 1
)
}
\arguments{
\item{data}{data.frame with 4 columns: x-coordinate, y-coordinate (i.e. center of polygon) and number of observations in area for partial population and number of observations for complete observations.}

\item{burnin}{burn-in sample size}

\item{samples}{sampling iteration size}

\item{adaptive}{TRUE for adaptive kernel density estimation}

\item{shapefile}{shapefile with number of polygons equal to nrow(data)}

\item{gridsize}{number of evaluation grid points}

\item{boundary}{boundary corrected kernel density estimate?}

\item{deleteShapes}{shapefile containing areas without observations}

\item{fastWeights}{if TRUE weigths for boundary estimation are only computed for first 10 percent of samples to speed up computation}

\item{numChains}{number of chains of SEM algorithm}

\item{numThreads}{number of threads to be used (only applicable if more than one chains)}
}
\description{
Bivariate Kernel density estimation for data classified in polygons or shapes
}
\examples{
\dontrun{
library(maptools)

# Read Shapefile of Berlin Urban Planning Areas (download available from:
  https://www.statistik-berlin-brandenburg.de/opendata/RBS_OD_LOR_2015_12.zip)
Berlin <- rgdal::readOGR("X:/SomeDir/RBS_OD_LOR_2015_12.shp") #(von daten.berlin.de)

# Get Dataset of Berlin Population (download available from:
# https://www.statistik-berlin-brandenburg.de/opendata/EWR201512E_Matrix.csv)
data <- read.csv2("X:/SomeDir/EWR201512E_Matrix.csv")

# Form Dataset for Estimation Process
dataIn <- cbind(t(sapply(1:length(Berlin@polygons),
function(x) Berlin@polygons[[x]]@labpt)), data$E_E65U80, data$E_E)

#Estimate Bivariate Proportions (may take some minutes)
PropEst <- dshapebivrProp(data = dataIn, burnin = 5, samples = 20, adaptive = FALSE,
shapefile = Berlin, gridsize=325, numChains = 16, numThreads = 4)}

# Plot Proportions over Area:
\dontrun{
breaks <- seq(0,0.4,by=0.025)
image.plot(x=PropEst$Mestimates$eval.points[[1]],y=PropEst$Mestimates$eval.points[[2]],
          z=PropEst$proportion+1E-96, asp=1, breaks = breaks,
          col =  colorRampPalette(brewer.pal(9,"YlOrRd"))(length(breaks)-1))
plot(Berlin, add=TRUE)}
}
