% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{addLink}
\alias{addLink}
\alias{addLink.lvm}
\alias{addLink.lvm.reduced}
\title{Add a New Link Between Two Variables in a LVM}
\usage{
addLink(object, ...)

\method{addLink}{lvm}(object, var1, var2, covariance,
  all.vars = lava::vars(object), warnings = FALSE, ...)

\method{addLink}{lvm.reduced}(object, ...)
}
\arguments{
\item{object}{a \code{lvm} object.}

\item{...}{[internal] only used by the generic method and from \code{addLink.lvm.reduced} to \code{addLink.lvm}.}

\item{var1}{[character or formula] the exogenous variable of the new link or a formula describing the link to be added to the lvm.}

\item{var2}{[character] the endogenous variable of the new link. Disregarded if the argument \code{var1} is a formula.}

\item{covariance}{[logical] is the link is bidirectional? Ignored if one of the variables non-stochastic (e.g. exogenous variables).}

\item{all.vars}{[internal] a character vector containing all the variables of the \code{lvm} object.}

\item{warnings}{[logical] Should a warning be displayed when no link is added?}
}
\description{
Generic interface to add links to \code{lvm} objects.
}
\details{
The argument \code{all.vars} is useful for \code{lvm.reduce} object where the command \code{vars(object)} does not return all variables. The command \code{vars(object, xlp = TRUE)} must be used instead.

Arguments \code{var1} and \code{var2} are passed to \code{initVarlink}.
}
\examples{
library(lava)
set.seed(10)

m <- lvm()
regression(m) <- c(y1,y2,y3)~u
regression(m) <- u~x1+x2
latent(m) <- ~u
m2 <- m

addLink(m, x1 ~ y1, covariance = FALSE)
addLink(m, y1 ~ x1, covariance = FALSE)
coef(addLink(m, y1 ~ y2, covariance = TRUE))

addLink(m2, "x1", "y1", covariance = FALSE)
addLink(m2, "y1", "x1", covariance = FALSE)
newM <- addLink(m, "y1", "y2", covariance = TRUE)
coef(newM)

}
\concept{setter}
