% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Measure_make_cost.R
\name{makeCostMeasure}
\alias{makeCostMeasure}
\title{Creates a measure for non-standard misclassification costs.}
\usage{
makeCostMeasure(
  id = "costs",
  minimize = TRUE,
  costs,
  combine = mean,
  best = NULL,
  worst = NULL,
  name = id,
  note = ""
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Name of measure.
Default is \dQuote{costs}.}

\item{minimize}{(\code{logical(1)})\cr
Should the measure be minimized?
Otherwise you are effectively specifying a benefits matrix.
Default is \code{TRUE}.}

\item{costs}{(\link{matrix})\cr
Matrix of misclassification costs. Rows and columns have to be named with class labels, order does not matter.
Rows indicate true classes, columns predicted classes.}

\item{combine}{(\code{function})\cr
How to combine costs over all cases for a SINGLE test set?
Note this is not the same as the \code{aggregate} argument in \link{makeMeasure}
You can set this as well via \link{setAggregation}, as for any measure.
Default is \link{mean}.}

\item{best}{(`numeric(1)`)\cr
Best obtainable value for measure.
Default is -`Inf` or `Inf`, depending on `minimize`.}

\item{worst}{(`numeric(1)`)\cr
Worst obtainable value for measure.
Default is `Inf` or -`Inf`, depending on `minimize`.}

\item{name}{([character]) \cr
Name of the measure. Default is `id`.}

\item{note}{([character]) \cr
Description and additional notes for the measure. Default is \dQuote{}.}
}
\value{
\link{Measure}.
}
\description{
Creates a cost measure for non-standard classification error costs.
}
\seealso{
Other performance: 
\code{\link{ConfusionMatrix}},
\code{\link{calculateConfusionMatrix}()},
\code{\link{calculateROCMeasures}()},
\code{\link{estimateRelativeOverfitting}()},
\code{\link{makeCustomResampledMeasure}()},
\code{\link{makeMeasure}()},
\code{\link{measures}},
\code{\link{performance}()},
\code{\link{setAggregation}()},
\code{\link{setMeasurePars}()}
}
\concept{performance}
