% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriv.mpoly.R
\name{deriv.mpoly}
\alias{deriv.mpoly}
\title{Compute partial derivatives of a multivariate polynomial.}
\usage{
\method{deriv}{mpoly}(expr, var, ..., bring_power_down = TRUE)
}
\arguments{
\item{expr}{an object of class mpoly}

\item{var}{character - the partial derivative desired}

\item{...}{any additional arguments}

\item{bring_power_down}{if \code{FALSE}, x^n -> x^(n-1), not n x^(n-1)}
}
\value{
An object of class mpoly or mpolyList.
}
\description{
This is a deriv method for mpoly objects.  It does not call the
\code{\link[stats:deriv]{stats::deriv()}}.
}
\examples{
p <- mp("x y + y z + z^2")
deriv(p, "x")
deriv(p, "y")
deriv(p, "z")
deriv(p, "t")
deriv(p, c("x","y","z"))

is.mpoly(deriv(p, "x"))
is.mpolyList( deriv(p, c("x","y","z")) )

p <- mp("x^5")
deriv(p, "x")
deriv(p, "x", bring_power_down = FALSE)

}
